package dev.greencat.shimmer.mixin;

import dev.greencat.shimmer.Shimmer;
import dev.greencat.shimmer.module.modules.player.Camera;
import net.minecraft.class_4184;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin({class_4184.class})
public class MixinCamera {

   @ModifyVariable(
      method = {"clipToSpace"},
      at =          @At("HEAD"),
      ordinal = 0,
      argsOnly = true
   )
   private float modifyClipToSpace(float d) {
      return Shimmer.getInstance().getModuleManager().isModuleEnabled("Camera")?(float)Camera.Distance.getValue():4.0F;
   }

   @Inject(
      method = {"clipToSpace"},
      at = {         @At("HEAD")},
      cancellable = true
   )
   private void onClipToSpace(float desiredCameraDistance, CallbackInfoReturnable info) {
      if(Camera.CameraClip.isEnabled() && Shimmer.getInstance().getModuleManager().isModuleEnabled("Camera")) {
         info.setReturnValue(Float.valueOf(desiredCameraDistance));
      }

   }
}
