package dev.greencat.shimmer.mixin;

import dev.greencat.shimmer.Shimmer;
import dev.greencat.shimmer.event.events.LivingEntityRenderPreEvent;
import net.minecraft.class_10042;
import net.minecraft.class_1309;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_922;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin({class_922.class})
public abstract class LivingEntityRendererMixin {

   @Inject(
      method = {"render(Lnet/minecraft/client/render/entity/state/LivingEntityRenderState;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"},
      at = {         @At("HEAD")},
      cancellable = true
   )
   public void onRender(class_10042 livingEntityRenderState, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, CallbackInfo ci) {
      try {
         class_1309 entity = (class_1309)livingEntityRenderState.field_58171.method_31794().newInstance();
         entity.method_23327(livingEntityRenderState.field_53325, livingEntityRenderState.field_53326, livingEntityRenderState.field_53327);
         entity.method_5636(livingEntityRenderState.field_53446);
         entity.method_36457(livingEntityRenderState.field_53448);
         LivingEntityRenderPreEvent event = new LivingEntityRenderPreEvent(entity);
         Shimmer.getInstance().getEventBus().post(event);
         if(event.isCancelled()) {
            ci.cancel();
         }
      } catch (Exception var8) {
         ;
      }

   }
}
