package dev.greencat.shimmer.mixin;

import dev.greencat.shimmer.Shimmer;
import dev.greencat.shimmer.event.events.RenderInGameHudEvent;
import dev.greencat.shimmer.module.modules.render.Hud;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_9779;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin({class_329.class})
public class InGameHudMixin {

   @Inject(
      method = {"render"},
      at = {         @At("RETURN")},
      cancellable = true
   )
   private void render(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
      RenderInGameHudEvent event = new RenderInGameHudEvent(context);
      Shimmer.getInstance().getEventBus().post(event);
      if(event.isCancelled()) {
         ci.cancel();
      }

   }

   @Inject(
      method = {"renderScoreboardSidebar(Lnet/minecraft/client/gui/DrawContext;Lnet/minecraft/client/render/RenderTickCounter;)V"},
      at = {         @At("HEAD")}
   )
   public void renderSidebar(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
      if(Shimmer.getInstance() != null && Shimmer.getInstance().getModuleManager() != null) {
         boolean isHUDEnabled = Shimmer.getInstance().getModuleManager().isModuleEnabled("HUD");
         if(isHUDEnabled && ((Hud)Shimmer.getInstance().getModuleManager().getModule("HUD")).getArrayListHeight() >= class_310.method_1551().method_22683().method_4502() / 3) {
            context.method_51448().method_22903();
            context.method_51448().method_46416(0.0F, (float)(((Hud)Shimmer.getInstance().getModuleManager().getModule("HUD")).getArrayListHeight() + 3) - (float)class_310.method_1551().method_22683().method_4502() / 4.0F, 0.0F);
         }
      }

   }

   @Inject(
      method = {"renderScoreboardSidebar(Lnet/minecraft/client/gui/DrawContext;Lnet/minecraft/client/render/RenderTickCounter;)V"},
      at = {         @At("RETURN")}
   )
   public void renderSidebar2(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
      if(Shimmer.getInstance() != null && Shimmer.getInstance().getModuleManager() != null) {
         boolean isHUDEnabled = Shimmer.getInstance().getModuleManager().isModuleEnabled("HUD");
         if(isHUDEnabled && ((Hud)Shimmer.getInstance().getModuleManager().getModule("HUD")).getArrayListHeight() >= class_310.method_1551().method_22683().method_4502() / 3) {
            context.method_51448().method_22909();
         }
      }

   }
}
