package dev.greencat.shimmer.mixin;

import dev.greencat.shimmer.Shimmer;
import dev.greencat.shimmer.event.events.PacketEvent;
import dev.greencat.shimmer.event.events.PacketEvent.Type;
import dev.greencat.shimmer.util.HaikuLogger;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.class_2535;
import net.minecraft.class_2596;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin({class_2535.class})
public class ClientConnectionMixin {

   @Inject(
      method = {"channelRead0*"},
      at = {         @At("HEAD")},
      cancellable = true
   )
   private void packetReceive(ChannelHandlerContext channelHandlerContext, class_2596 packet, CallbackInfo ci) {
      PacketEvent event = new PacketEvent(packet, Type.RECEIVE);
      Shimmer.getInstance().getEventBus().post(event);
      if(event.isCancelled()) {
         ci.cancel();
      }

   }

   @Inject(
      method = {"send(Lnet/minecraft/network/packet/Packet;)V"},
      at = {         @At("HEAD")},
      cancellable = true
   )
   private void packetSend(class_2596 param1, CallbackInfo param2) {
      // $FF: Couldn't be decompiled
   }

   // $FF: synthetic method
   private static void lambda$packetSend$0() {
      if(Shimmer.getInstance().IRC != null) {
         try {
            Shimmer.getInstance().IRC.closed = true;
            Shimmer.getInstance().IRC.interrupt();
            if(!Shimmer.getInstance().IRC.socket.isClosed()) {
               Shimmer.getInstance().IRC.socket.shutdownInput();
            }

            if(!Shimmer.getInstance().IRC.socket.isClosed()) {
               Shimmer.getInstance().IRC.socket.shutdownOutput();
            }

            if(!Shimmer.getInstance().IRC.socket.isClosed()) {
               Shimmer.getInstance().IRC.socket.close();
            }

            HaikuLogger.info("[IRC] IRC已断开链接,输入!reconnect重新链接");
            Shimmer.getInstance().IRC = null;
         } catch (Exception var1) {
            var1.printStackTrace();
         }
      } else {
         HaikuLogger.info("[IRC] IRC已经处于断开链接状态");
      }

   }
}
