package dev.greencat.shimmer.eventbus;

import dev.greencat.shimmer.eventbus.IEventBus;
import dev.greencat.shimmer.eventbus.Listener;
import dev.greencat.shimmer.eventbus.ShimmerEvent;
import dev.greencat.shimmer.eventbus.ShimmerSubscribe;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MethodHandles.Lookup;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class EventBus implements IEventBus {

   private final Map listeners = new ConcurrentHashMap();


   public void register(Object param1) {
      // $FF: Couldn't be decompiled
   }

   public void unregister(Object registerClass) {
      this.listeners.values().forEach((Consumer)registerClass);
   }

   public void post(ShimmerEvent event) {
      List listenersList = (List)this.listeners.get(event.getClass());
      if(listenersList != null) {
         Iterator var3 = listenersList.iterator();

         while(var3.hasNext()) {
            Listener listener = (Listener)var3.next();
            if(event.isCancelled()) {
               return;
            }

            if(listener.getLambda() != null) {
               listener.getLambda().accept(event);
            } else {
               try {
                  listener.getMethod().invoke(listener.getListenerClass(), new Object[]{event});
               } catch (InvocationTargetException | IllegalAccessException var6) {
                  var6.printStackTrace();
               }
            }
         }
      }

   }

   protected Consumer getLambda(Object object, Method method, Class event) {
      Consumer eventLambda = null;

      try {
         Lookup e = MethodHandles.lookup();
         MethodType subscription = MethodType.methodType(Void.TYPE, event);
         MethodHandle target = e.findVirtual(object.getClass(), method.getName(), subscription);
         CallSite site = LambdaMetafactory.metafactory(e, "accept", MethodType.methodType(Consumer.class, object.getClass()), subscription.changeParameterType(0, Object.class), target, subscription);
         MethodHandle factory = site.getTarget();
         eventLambda = factory.bindTo(object).invokeExact();
      } catch (Throwable var10) {
         var10.printStackTrace();
      }

      return eventLambda;
   }

   // $FF: synthetic method
   private static void lambda$unregister$4(Object registerClass, CopyOnWriteArrayList arrayList) {
      arrayList.removeIf((Predicate)registerClass);
   }

   // $FF: synthetic method
   private static boolean lambda$unregister$3(Object registerClass, Listener listener) {
      return listener.getListenerClass().equals(registerClass);
   }

   // $FF: synthetic method
   private void lambda$register$2(Object registerClass, Method method) {
      if(!method.canAccess(registerClass)) {
         method.setAccessible(true);
      }

      Class event = method.getParameterTypes()[0];
      Consumer lambda = null;
      if(((ShimmerSubscribe)method.getDeclaredAnnotation(ShimmerSubscribe.class)).lambda()) {
         lambda = this.getLambda(registerClass, method, event);
      }

      if(!this.listeners.containsKey(event)) {
         this.listeners.put(event, new CopyOnWriteArrayList());
      }

      ((CopyOnWriteArrayList)this.listeners.get(event)).add(new Listener(registerClass, method, lambda));
   }

   // $FF: synthetic method
   private static boolean lambda$register$1(Method method) {
      return method.getParameterCount() == 1;
   }

   // $FF: synthetic method
   private static boolean lambda$register$0(Method method) {
      return method.isAnnotationPresent(ShimmerSubscribe.class);
   }
}
