package dev.greencat.shimmer;

import dev.greencat.MaterialConfig;
import dev.greencat.MaterialConfigFactory;
import dev.greencat.core.type.settings.BooleanSettings;
import dev.greencat.core.type.settings.KeybindSettings;
import dev.greencat.core.type.settings.ModeSettings;
import dev.greencat.core.type.settings.NumberSettings;
import dev.greencat.core.type.settings.SettingBase;
import dev.greencat.core.type.settings.StringSettings;
import dev.greencat.shimmer.command.CommandManager;
import dev.greencat.shimmer.event.events.ActionBarRenderEvent;
import dev.greencat.shimmer.event.events.WorldChangeEvent;
import dev.greencat.shimmer.event.events.RenderEvent.AfterEntities;
import dev.greencat.shimmer.event.events.RenderEvent.Post;
import dev.greencat.shimmer.event.events.RenderEvent.Pre;
import dev.greencat.shimmer.eventbus.EventBus;
import dev.greencat.shimmer.keybind.VanillaKeyBind;
import dev.greencat.shimmer.module.Module;
import dev.greencat.shimmer.module.ModuleManager;
import dev.greencat.shimmer.module.modules.misc.Cat;
import dev.greencat.shimmer.setting.SettingManager;
import dev.greencat.shimmer.setting.settings.BooleanSetting;
import dev.greencat.shimmer.setting.settings.KeybindSetting;
import dev.greencat.shimmer.setting.settings.ModeSetting;
import dev.greencat.shimmer.setting.settings.NumberSetting;
import dev.greencat.shimmer.setting.settings.StringSetting;
import dev.greencat.shimmer.util.HaikuLogger;
import dev.greencat.shimmer.util.RankingOverrider;
import dev.greencat.shimmer.util.irc.IRC;
import dev.greencat.shimmer.util.render.animation.AnimationManager;
import dev.greencat.shimmer.util.world.LocationUtils;
import dev.greencat.utils.color.ColorPalette;
import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1059;
import net.minecraft.class_10811;
import net.minecraft.class_1087;
import net.minecraft.class_155;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_638;
import net.minecraft.class_778;
import net.minecraft.class_7833;
import net.minecraft.class_4587.class_4665;
import org.joml.Matrix4f;

public class Shimmer implements ModInitializer {

   public static final String MOD_NAME = "Shimmer Neon";
   public static final String MOD_VERSION = "202";
   public static final class_310 mc = class_310.method_1551();
   public HashMap moduleEnabledMap = new HashMap();
   public boolean lastHasWorld = false;
   public boolean isIRCToggled = false;
   private static Shimmer INSTANCE;
   private final VanillaKeyBind keyBind = new VanillaKeyBind();
   private final EventBus EVENT_BUS = new EventBus();
   private final ModuleManager MODULE_MANAGER = new ModuleManager();
   private final CommandManager COMMAND_MANAGER = new CommandManager();
   private final SettingManager SETTING_MANAGER = new SettingManager();
   private final RankingOverrider RANKING_OVERRIDER = new RankingOverrider();
   public int guiCustomR = 0;
   public int guiCustomG = 0;
   public int guiCustomB = 0;
   public final MaterialConfigFactory factory = new MaterialConfigFactory("Shimmer");
   public IRC IRC;
   private String title = "Shimmer Neon v202";
   public boolean isSorted = false;
   private final AnimationManager ANIMATION_MANAGER = new AnimationManager();


   public Shimmer() {
      INSTANCE = this;
   }

   public static Shimmer getInstance() {
      return INSTANCE;
   }

   public void onInitialize() {
      // $FF: Couldn't be decompiled
   }

   public void postInitialize() {
      // $FF: Couldn't be decompiled
   }

   public EventBus getEventBus() {
      return this.EVENT_BUS;
   }

   public ModuleManager getModuleManager() {
      return this.MODULE_MANAGER;
   }

   public CommandManager getCommandManager() {
      return this.COMMAND_MANAGER;
   }

   public SettingManager getSettingManager() {
      return this.SETTING_MANAGER;
   }

   public VanillaKeyBind getKeyBindManager() {
      return this.keyBind;
   }

   // $FF: synthetic method
   private void lambda$postInitialize$31(ModeSettings backgroundDefault, SettingBase settingBase, Object value) {
      if(settingBase.name.equals(backgroundDefault.name) && settingBase.module.equals(backgroundDefault.module)) {
         String valueStr = value.toString();
         if(valueStr.equals("Default White")) {
            MaterialConfig.colorPalette = new ColorPalette(new Color(175, 198, 255));
         }

         if(valueStr.equals("Default Dark")) {
            MaterialConfig.colorPalette = new ColorPalette(new Color(32, 33, 36));
         }

         if(valueStr.equals("Indigo")) {
            MaterialConfig.colorPalette = new ColorPalette(new Color(63, 81, 181));
         }

         if(valueStr.equals("Blue")) {
            MaterialConfig.colorPalette = new ColorPalette(new Color(33, 150, 243));
         }

         if(valueStr.equals("Purple")) {
            MaterialConfig.colorPalette = new ColorPalette(new Color(156, 39, 176));
         }

         if(valueStr.equals("Teal")) {
            MaterialConfig.colorPalette = new ColorPalette(new Color(0, 150, 136));
         }

         if(valueStr.equals("Orange")) {
            MaterialConfig.colorPalette = new ColorPalette(new Color(255, 152, 0));
         }

         if(valueStr.equals("Red")) {
            MaterialConfig.colorPalette = new ColorPalette(new Color(244, 67, 54));
         }

         if(valueStr.equals("Custom")) {
            MaterialConfig.colorPalette = new ColorPalette(new Color(this.guiCustomR, this.guiCustomG, this.guiCustomB));
         }
      }

   }

   // $FF: synthetic method
   private void lambda$postInitialize$30(ModeSettings value) {
      String valueStr = (String)value.getValue();
      if(valueStr.equals("Default White")) {
         MaterialConfig.colorPalette = new ColorPalette(new Color(175, 198, 255));
      }

      if(valueStr.equals("Default Dark")) {
         MaterialConfig.colorPalette = new ColorPalette(new Color(32, 33, 36));
      }

      if(valueStr.equals("Indigo")) {
         MaterialConfig.colorPalette = new ColorPalette(new Color(63, 81, 181));
      }

      if(valueStr.equals("Blue")) {
         MaterialConfig.colorPalette = new ColorPalette(new Color(33, 150, 243));
      }

      if(valueStr.equals("Purple")) {
         MaterialConfig.colorPalette = new ColorPalette(new Color(156, 39, 176));
      }

      if(valueStr.equals("Teal")) {
         MaterialConfig.colorPalette = new ColorPalette(new Color(0, 150, 136));
      }

      if(valueStr.equals("Orange")) {
         MaterialConfig.colorPalette = new ColorPalette(new Color(255, 152, 0));
      }

      if(valueStr.equals("Red")) {
         MaterialConfig.colorPalette = new ColorPalette(new Color(244, 67, 54));
      }

      if(valueStr.equals("Custom")) {
         MaterialConfig.colorPalette = new ColorPalette(new Color(this.guiCustomR, this.guiCustomG, this.guiCustomB));
      }

   }

   // $FF: synthetic method
   private void lambda$postInitialize$29(NumberSettings backgroundB, ModeSettings backgroundDefault, SettingBase settingBase, Object value) {
      if(settingBase.name.equals(backgroundB.name) && settingBase.module.equals(backgroundB.module)) {
         this.guiCustomB = ((Double)value).intValue();
         if(((String)backgroundDefault.getValue()).equals("Custom")) {
            MaterialConfig.colorPalette = new ColorPalette(new Color(this.guiCustomR, this.guiCustomG, this.guiCustomB));
         }
      }

   }

   // $FF: synthetic method
   private void lambda$postInitialize$28(NumberSettings backgroundG, ModeSettings backgroundDefault, SettingBase settingBase, Object value) {
      if(settingBase.name.equals(backgroundG.name) && settingBase.module.equals(backgroundG.module)) {
         this.guiCustomG = ((Double)value).intValue();
         if(((String)backgroundDefault.getValue()).equals("Custom")) {
            MaterialConfig.colorPalette = new ColorPalette(new Color(this.guiCustomR, this.guiCustomG, this.guiCustomB));
         }
      }

   }

   // $FF: synthetic method
   private void lambda$postInitialize$27(NumberSettings backgroundR, ModeSettings backgroundDefault, SettingBase settingBase, Object value) {
      if(settingBase.name.equals(backgroundR.name) && settingBase.module.equals(backgroundR.module)) {
         this.guiCustomR = ((Double)value).intValue();
         if(((String)backgroundDefault.getValue()).equals("Custom")) {
            MaterialConfig.colorPalette = new ColorPalette(new Color(this.guiCustomR, this.guiCustomG, this.guiCustomB));
         }
      }

   }

   // $FF: synthetic method
   private static void lambda$postInitialize$26(NumberSettings backgroundAlpha, SettingBase settingBase, Object value) {
      if(settingBase.name.equals(backgroundAlpha.name) && settingBase.module.equals(backgroundAlpha.module)) {
         MaterialConfig.backgroundAlpha = ((Double)value).floatValue();
      }

   }

   // $FF: synthetic method
   private static void lambda$postInitialize$25(NumberSettings value) {
      MaterialConfig.backgroundAlpha = ((Double)value.getValue()).floatValue();
   }

   // $FF: synthetic method
   private void lambda$postInitialize$24(NumberSettings value) {
      this.guiCustomB = ((Double)value.getValue()).intValue();
   }

   // $FF: synthetic method
   private void lambda$postInitialize$23(NumberSettings value) {
      this.guiCustomG = ((Double)value.getValue()).intValue();
   }

   // $FF: synthetic method
   private void lambda$postInitialize$22(NumberSettings value) {
      this.guiCustomR = ((Double)value.getValue()).intValue();
   }

   // $FF: synthetic method
   private static void lambda$postInitialize$21(KeybindSetting originalSetting4, String moduleName, SettingBase settingBase, Object value) {
      if(settingBase.name.equals(originalSetting4.name) && moduleName.equals(settingBase.module)) {
         originalSetting4.setKeyCode(((Integer)value).intValue());
      }

   }

   // $FF: synthetic method
   private static void lambda$postInitialize$20(KeybindSetting originalSetting4, KeybindSettings value) {
      originalSetting4.setKeyCode(((Integer)value.getValue()).intValue());
   }

   // $FF: synthetic method
   private static void lambda$postInitialize$19(ModeSetting originalSetting3, String moduleName, SettingBase settingBase, Object value) {
      if(settingBase.name.equals(originalSetting3.name) && moduleName.equals(settingBase.module)) {
         originalSetting3.setMode((String)value);
      }

   }

   // $FF: synthetic method
   private static void lambda$postInitialize$18(ModeSetting originalSetting3, ModeSettings value) {
      originalSetting3.setMode((String)value.getValue());
   }

   // $FF: synthetic method
   private static void lambda$postInitialize$17(StringSetting originalSetting2, String moduleName, SettingBase settingBase, Object value) {
      if(settingBase.name.equals(originalSetting2.name) && moduleName.equals(settingBase.module)) {
         originalSetting2.setString((String)value);
      }

   }

   // $FF: synthetic method
   private static void lambda$postInitialize$16(StringSetting originalSetting2, StringSettings value) {
      originalSetting2.setString((String)value.getValue());
   }

   // $FF: synthetic method
   private static void lambda$postInitialize$15(NumberSetting originalSetting1, String moduleName, SettingBase settingBase, Object value) {
      if(settingBase.name.equals(originalSetting1.name) && moduleName.equals(settingBase.module)) {
         originalSetting1.setValue(((Double)value).doubleValue());
      }

   }

   // $FF: synthetic method
   private static void lambda$postInitialize$14(NumberSetting originalSetting1, NumberSettings value) {
      originalSetting1.setValue(((Double)value.getValue()).doubleValue());
   }

   // $FF: synthetic method
   private static void lambda$postInitialize$13(BooleanSetting originalSetting, String moduleName, SettingBase settingBase, Object value) {
      if(settingBase.name.equals(originalSetting.name) && moduleName.equals(settingBase.module)) {
         originalSetting.setEnabled(((Boolean)value).booleanValue());
      }

   }

   // $FF: synthetic method
   private static void lambda$postInitialize$12(BooleanSetting originalSetting, BooleanSettings value) {
      originalSetting.setEnabled(((Boolean)value.getValue()).booleanValue());
   }

   // $FF: synthetic method
   private static void lambda$postInitialize$11(BooleanSettings booleanSettings, Module module, SettingBase settingBase, Object value) {
      if(settingBase.module.equals(booleanSettings.module) && settingBase.name.equals(booleanSettings.name)) {
         module.setEnabled(((Boolean)value).booleanValue());
      }

   }

   // $FF: synthetic method
   private static void lambda$postInitialize$10(Module module, BooleanSettings value) {
      module.setEnabled(((Boolean)value.getValue()).booleanValue());
   }

   // $FF: synthetic method
   private void lambda$postInitialize$9(class_310 client) {
      if(System.currentTimeMillis() - Cat.lastChange >= 20000L) {
         this.title = "Shimmer Neon v202";
         if(Cat.randomTitle.enabled) {
            this.title.title = Cat.titles.getProperty(String.valueOf(Cat.random.nextInt(649) + 1));
         }

         Cat.lastChange = System.currentTimeMillis();
      }

      class_310.method_1551().method_22683();
      this.title.method_24286(class_155.method_16673().method_48019());
   }

   // $FF: synthetic method
   private static void lambda$onInitialize$8() {
      if(getInstance().IRC != null) {
         try {
            getInstance().IRC.socket.close();
            getInstance().IRC.reader.close();
            getInstance().IRC.writer.close();
         } catch (IOException var1) {
            throw new RuntimeException(var1);
         }
      }

   }

   // $FF: synthetic method
   private static void lambda$onInitialize$7(WorldRenderContext context) {
      if(LocationUtils.sideBarString.toLowerCase().contains("village")) {
         class_2680 blockState = class_10811.method_68014(false, true);
         class_1087 blockStateModel = class_310.method_1551().method_1541().method_3349(blockState);
         class_4597 vertexConsumerProvider = context.consumers();
         class_4587 matrixStack = context.matrixStack();
         if(matrixStack != null && vertexConsumerProvider != null) {
            matrixStack.method_22903();
            class_243 pos = context.camera().method_19326();
            matrixStack.method_22904(-pos.field_1352 + Cat.RENDER_POSITION.field_1352 + 1.0D, -pos.field_1351 + Cat.RENDER_POSITION.field_1351, -pos.field_1350 + Cat.RENDER_POSITION.field_1350 + 1.0D + 0.0125D);
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(180.0F));
            class_4665 peek = matrixStack.method_23760();
            class_778.method_3367(peek, vertexConsumerProvider.getBuffer(class_1921.method_62290(class_1059.field_5275)), blockStateModel, 1.0F, 1.0F, 1.0F, 15, class_4608.field_21444);
            matrixStack.method_46416(1.0F, 1.0F, 0.0F);
            matrixStack.method_22907(class_7833.field_40718.rotationDegrees(180.0F));
            Matrix4f matrix4f = peek.method_23761();
            class_4588 cat = vertexConsumerProvider.getBuffer(class_1921.method_23028(Cat.TEXTURE));
            float z = 0.9370117F;
            cat.method_22918(matrix4f, 0.0F, 1.0F, z).method_39415(-1).method_22913(0.0F, 1.0F).method_60803(15);
            cat.method_22918(matrix4f, 1.0F, 1.0F, z).method_39415(-1).method_22913(1.0F, 1.0F).method_60803(15);
            cat.method_22918(matrix4f, 1.0F, 0.0F, z).method_39415(-1).method_22913(1.0F, 0.0F).method_60803(15);
            cat.method_22918(matrix4f, 0.0F, 0.0F, z).method_39415(-1).method_22913(0.0F, 0.0F).method_60803(15);
            matrixStack.method_22909();
            matrixStack.method_22903();
            matrixStack.method_22904(-pos.field_1352 + Cat.BIG_RENDER_POSITION.field_1352 + 1.0D, -pos.field_1351 + Cat.BIG_RENDER_POSITION.field_1351, -pos.field_1350 + Cat.BIG_RENDER_POSITION.field_1350 + 1.0D + 0.0125D);
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(180.0F));
            matrixStack.method_22905(7.0F, 7.0F, 1.0F);
            class_4665 peek1 = matrixStack.method_23760();
            class_778.method_3367(peek1, vertexConsumerProvider.getBuffer(class_1921.method_62290(class_1059.field_5275)), blockStateModel, 1.0F, 1.0F, 1.0F, 15, class_4608.field_21444);
            matrixStack.method_46416(1.0F, 1.0F, 0.0F);
            matrixStack.method_22907(class_7833.field_40718.rotationDegrees(180.0F));
            Matrix4f matrix4f1 = peek1.method_23761();
            class_4588 cat1 = vertexConsumerProvider.getBuffer(class_1921.method_23028(Cat.TEXTURE));
            cat1.method_22918(matrix4f1, 0.0F, 1.0F, z).method_39415(-1).method_22913(0.0F, 1.0F).method_60803(15);
            cat1.method_22918(matrix4f1, 1.0F, 1.0F, z).method_39415(-1).method_22913(1.0F, 1.0F).method_60803(15);
            cat1.method_22918(matrix4f1, 1.0F, 0.0F, z).method_39415(-1).method_22913(1.0F, 0.0F).method_60803(15);
            cat1.method_22918(matrix4f1, 0.0F, 0.0F, z).method_39415(-1).method_22913(0.0F, 0.0F).method_60803(15);
            matrixStack.method_22909();
         }
      }
   }

   // $FF: synthetic method
   private static void lambda$onInitialize$6(class_310 client, class_638 world) {
      WorldChangeEvent event = new WorldChangeEvent();
      getInstance().getEventBus().post(event);
   }

   // $FF: synthetic method
   private void lambda$onInitialize$5(class_310 mc) {
      if(!this.lastHasWorld && mc.field_1687 != null) {
         HaikuLogger.info("[IRC] IRC已链接,输入\"!disconnect\"断开链接,\"!消息\"发送消息");
         HaikuLogger.info("[IRC] 输入\"!list\"查看当前玩家列表,\"!toggle\"来将IRC设为默认聊天频道");
      }

      this.lastHasWorld = mc.field_1687 != null;
   }

   // $FF: synthetic method
   private static boolean lambda$onInitialize$4(class_2561 text, boolean overlay) {
      ActionBarRenderEvent event = new ActionBarRenderEvent(text);
      getInstance().getEventBus().post(event);
      return true;
   }

   // $FF: synthetic method
   private static void lambda$onInitialize$3(class_310 client) {
      if(class_310.method_1551().field_1687 != null) {
         LocationUtils.update();
      }

   }

   // $FF: synthetic method
   private static void lambda$onInitialize$2(WorldRenderContext wrc) {
      AfterEntities event = new AfterEntities(wrc);
      getInstance().getEventBus().post(event);
   }

   // $FF: synthetic method
   private static void lambda$onInitialize$1(WorldRenderContext wrc) {
      Post event = new Post(wrc);
      getInstance().getEventBus().post(event);
   }

   // $FF: synthetic method
   private static void lambda$onInitialize$0(WorldRenderContext wrc) {
      Pre event = new Pre(wrc);
      getInstance().getEventBus().post(event);
   }

}
