package baritone.launch.mixins;

import baritone.api.BaritoneAPI;
import baritone.api.IBaritone;
import baritone.api.event.events.PacketEvent;
import baritone.api.event.events.type.EventState;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.util.Iterator;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin({vv.class})
public class MixinNetworkManager {

   @Shadow
   private Channel n;
   @Shadow
   @Final
   private zp k;


   @Inject(
      method = {"sendPacket"},
      at = {         @At("HEAD")}
   )
   private void preDispatchPacket(zo var1, wl var2, boolean var3, CallbackInfo var4) {
      if(this.k == zp.b) {
         Iterator var5 = BaritoneAPI.getProvider().getAllBaritones().iterator();

         while(var5.hasNext()) {
            IBaritone var6;
            if((var6 = (IBaritone)var5.next()).getPlayerContext().player() != null && var6.getPlayerContext().player().j.j() == (vv)this) {
               var6.getGameEventHandler().onSendPacket(new PacketEvent((vv)this, EventState.PRE, var1));
            }
         }

      }
   }

   @Inject(
      method = {"sendPacket"},
      at = {         @At("RETURN")}
   )
   private void postDispatchPacket(zo var1, wl var2, boolean var3, CallbackInfo var4) {
      if(this.k == zp.b) {
         Iterator var5 = BaritoneAPI.getProvider().getAllBaritones().iterator();

         while(var5.hasNext()) {
            IBaritone var6;
            if((var6 = (IBaritone)var5.next()).getPlayerContext().player() != null && var6.getPlayerContext().player().j.j() == (vv)this) {
               var6.getGameEventHandler().onSendPacket(new PacketEvent((vv)this, EventState.POST, var1));
            }
         }

      }
   }

   @Inject(
      method = {"channelRead0"},
      at = {         @At(
            value = "INVOKE",
            target = "net/minecraft/network/Connection.genericsFtw(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;)V"
         )}
   )
   private void preProcessPacket(ChannelHandlerContext var1, zo var2, CallbackInfo var3) {
      if(this.k == zp.b) {
         Iterator var4 = BaritoneAPI.getProvider().getAllBaritones().iterator();

         while(var4.hasNext()) {
            IBaritone var5;
            if((var5 = (IBaritone)var4.next()).getPlayerContext().player() != null && var5.getPlayerContext().player().j.j() == (vv)this) {
               var5.getGameEventHandler().onReceivePacket(new PacketEvent((vv)this, EventState.PRE, var2));
            }
         }

      }
   }

   @Inject(
      method = {"channelRead0"},
      at = {         @At("RETURN")}
   )
   private void postProcessPacket(ChannelHandlerContext var1, zo var2, CallbackInfo var3) {
      if(this.n.isOpen() && this.k == zp.b) {
         Iterator var4 = BaritoneAPI.getProvider().getAllBaritones().iterator();

         while(var4.hasNext()) {
            IBaritone var5;
            if((var5 = (IBaritone)var4.next()).getPlayerContext().player() != null && var5.getPlayerContext().player().j.j() == (vv)this) {
               var5.getGameEventHandler().onReceivePacket(new PacketEvent((vv)this, EventState.POST, var2));
            }
         }

      }
   }
}
