package baritone.launch.mixins;

import baritone.api.BaritoneAPI;
import baritone.api.IBaritone;
import baritone.api.event.events.RotationMoveEvent;
import baritone.api.event.events.RotationMoveEvent.Type;
import java.util.Optional;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.At.Shift;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin({byf.class})
public abstract class MixinLivingEntity extends bxe {

   @Unique
   private RotationMoveEvent jumpRotationEvent;
   @Unique
   private RotationMoveEvent elytraRotationEvent;


   private MixinLivingEntity(bxn var1, dkj var2) {
      super(var1, var2);
   }

   @Inject(
      method = {"jumpFromGround"},
      at = {         @At("HEAD")}
   )
   private void preMoveRelative(CallbackInfo var1) {
      this.getBaritone().ifPresent(this);
   }

   @Redirect(
      method = {"jumpFromGround"},
      at =          @At(
            value = "INVOKE",
            target = "net/minecraft/world/entity/LivingEntity.getYRot()F"
         )
   )
   private float overrideYaw(byf var1) {
      return var1 instanceof gqm && BaritoneAPI.getProvider().getBaritoneForPlayer((gqm)this) != null?this.jumpRotationEvent.getYaw():var1.dL();
   }

   @Inject(
      method = {"updateFallFlyingMovement"},
      at = {         @At(
            value = "INVOKE",
            target = "net/minecraft/world/entity/LivingEntity.getLookAngle()Lnet/minecraft/world/phys/Vec3;"
         )}
   )
   private void onPreElytraMove(fgc var1, CallbackInfoReturnable var2) {
      this.getBaritone().ifPresent(this);
   }

   @Inject(
      method = {"travelFallFlying"},
      at = {         @At(
            value = "INVOKE",
            target = "net/minecraft/world/entity/LivingEntity.move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V",
            shift = Shift.AFTER
         )}
   )
   private void onPostElytraMove(CallbackInfo var1) {
      if(this.elytraRotationEvent != null) {
         this.w(this.elytraRotationEvent.getOriginal().getYaw());
         this.x(this.elytraRotationEvent.getOriginal().getPitch());
         this.elytraRotationEvent = null;
      }

   }

   @Unique
   private Optional getBaritone() {
      return gqm.class.isInstance(this)?Optional.ofNullable(BaritoneAPI.getProvider().getBaritoneForPlayer((gqm)this)):Optional.empty();
   }

   // $FF: synthetic method
   private void lambda$onPreElytraMove$1(IBaritone var1) {
      this.elytraRotationEvent = new RotationMoveEvent(Type.MOTION_UPDATE, this.dL(), this.dN());
      var1.getGameEventHandler().onPlayerRotationMove(this.elytraRotationEvent);
      this.w(this.elytraRotationEvent.getYaw());
      this.x(this.elytraRotationEvent.getPitch());
   }

   // $FF: synthetic method
   private void lambda$preMoveRelative$0(IBaritone var1) {
      this.jumpRotationEvent = new RotationMoveEvent(Type.JUMP, this.dL(), this.dN());
      var1.getGameEventHandler().onPlayerRotationMove(this.jumpRotationEvent);
   }
}
