package baritone.launch.mixins;

import baritone.api.utils.accessor.IItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin({dak.class})
public abstract class MixinItemStack implements IItemStack {

   @Shadow
   @Final
   private dag s;
   @Unique
   private int baritoneHash;


   @Shadow
   public abstract int o();

   private void recalculateHash() {
      this.baritoneHash = this.s == null?-1:this.s.hashCode() + this.o();
   }

   @Inject(
      method = {"<init>*"},
      at = {         @At("RETURN")}
   )
   private void onInit(CallbackInfo var1) {
      this.recalculateHash();
   }

   @Inject(
      method = {"setDamageValue"},
      at = {         @At("TAIL")}
   )
   private void onItemDamageSet(CallbackInfo var1) {
      this.recalculateHash();
   }

   public int getBaritoneHash() {
      if(this.baritoneHash == 0) {
         this.recalculateHash();
      }

      return this.baritoneHash;
   }
}
