package baritone.launch.mixins;

import baritone.api.BaritoneAPI;
import baritone.api.event.events.RotationMoveEvent;
import baritone.api.event.events.RotationMoveEvent.Type;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin({bxe.class})
public class MixinEntity {

   @Shadow
   private float aE;
   @Shadow
   private float aF;
   @Unique
   private RotationMoveEvent motionUpdateRotationEvent;


   @Inject(
      method = {"moveRelative"},
      at = {         @At("HEAD")}
   )
   private void moveRelativeHead(CallbackInfo var1) {
      if(gqm.class.isInstance(this) && BaritoneAPI.getProvider().getBaritoneForPlayer((gqm)this) != null) {
         this.motionUpdateRotationEvent = new RotationMoveEvent(Type.MOTION_UPDATE, this.aE, this.aF);
         BaritoneAPI.getProvider().getBaritoneForPlayer((gqm)this).getGameEventHandler().onPlayerRotationMove(this.motionUpdateRotationEvent);
         this.aE = this.motionUpdateRotationEvent.getYaw();
         this.aF = this.motionUpdateRotationEvent.getPitch();
      }
   }

   @Inject(
      method = {"moveRelative"},
      at = {         @At("RETURN")}
   )
   private void moveRelativeReturn(CallbackInfo var1) {
      if(this.motionUpdateRotationEvent != null) {
         this.aE = this.motionUpdateRotationEvent.getOriginal().getYaw();
         this.aF = this.motionUpdateRotationEvent.getOriginal().getPitch();
         this.motionUpdateRotationEvent = null;
      }

   }
}
