package baritone.launch.mixins;

import baritone.f;
import baritone.api.BaritoneAPI;
import baritone.api.IBaritone;
import baritone.api.event.events.PlayerUpdateEvent;
import baritone.api.event.events.SprintStateEvent;
import baritone.api.event.events.type.EventState;
import baritone.api.utils.Rotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Group;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.At.Shift;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin({gqm.class})
public class MixinClientPlayerEntity {

   @Unique
   private static final MethodHandle MAY_FLY = baritone$resolveMayFly();


   @Unique
   private static MethodHandle baritone$resolveMayFly() {
      try {
         return MethodHandles.publicLookup().findVirtual(gqm.class, "mayFly", MethodType.methodType(Boolean.TYPE));
      } catch (NoSuchMethodException var1) {
         return null;
      } catch (IllegalAccessException var2) {
         throw new RuntimeException(var2);
      }
   }

   @Inject(
      method = {"tick"},
      at = {         @At(
            value = "INVOKE",
            target = "net/minecraft/client/player/AbstractClientPlayer.tick()V",
            shift = Shift.AFTER
         )}
   )
   private void onPreUpdate(CallbackInfo var1) {
      IBaritone var2;
      if((var2 = BaritoneAPI.getProvider().getBaritoneForPlayer((gqm)this)) != null) {
         var2.getGameEventHandler().onPlayerUpdate(new PlayerUpdateEvent(EventState.PRE));
      }

   }

   @Redirect(
      method = {"aiStep"},
      at =          @At(
            value = "FIELD",
            target = "net/minecraft/world/entity/player/Abilities.mayfly:Z"
         )
   )
   @Group(
      name = "mayFly",
      min = 1,
      max = 1
   )
   private boolean isAllowFlying(cse var1) {
      IBaritone var2;
      return (var2 = BaritoneAPI.getProvider().getBaritoneForPlayer((gqm)this)) == null?var1.c:!var2.getPathingBehavior().isPathing() && var1.c;
   }

   @Redirect(
      method = {"aiStep"},
      at =          @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/player/LocalPlayer;mayFly()Z"
         )
   )
   @Group(
      name = "mayFly",
      min = 1,
      max = 1
   )
   private boolean onMayFlyNeoforge(gqm var1) {
      IBaritone var2;
      return (var2 = BaritoneAPI.getProvider().getBaritoneForPlayer((gqm)this)) == null?MAY_FLY.invokeExact(var1):!var2.getPathingBehavior().isPathing() && MAY_FLY.invokeExact(var1);
   }

   @Redirect(
      method = {"aiStep"},
      at =          @At(
            value = "INVOKE",
            target = "Lnet/minecraft/world/entity/player/Input;sprint()Z"
         )
   )
   private boolean redirectSprintInput(csg var1) {
      IBaritone var2;
      if((var2 = BaritoneAPI.getProvider().getBaritoneForPlayer((gqm)this)) == null) {
         return var1.g();
      } else {
         SprintStateEvent var3 = new SprintStateEvent();
         var2.getGameEventHandler().onPlayerSprintState(var3);
         return var3.getState() != null?var3.getState().booleanValue():(var2 != BaritoneAPI.getProvider().getPrimaryBaritone()?false:var1.g());
      }
   }

   @Inject(
      method = {"rideTick"},
      at = {         @At("HEAD")}
   )
   private void updateRidden(CallbackInfo var1) {
      IBaritone var3;
      f var4;
      if((var3 = BaritoneAPI.getProvider().getBaritoneForPlayer((gqm)this)) != null && (var4 = (f)var3.getLookBehavior()).a != null) {
         Rotation var2 = var4.a.peekRotation(var4.a.a);
         var4.a.player().w(var2.getYaw());
      }

   }

   @Redirect(
      method = {"aiStep"},
      at =          @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/player/LocalPlayer;tryToStartFallFlying()Z"
         )
   )
   private boolean tryToStartFallFlying(gqm var1) {
      IBaritone var2;
      return (var2 = BaritoneAPI.getProvider().getBaritoneForPlayer(var1)) != null && var2.getPathingBehavior().isPathing()?false:var1.gq();
   }

}
