package baritone.launch.mixins;

import baritone.a;
import baritone.m;
import baritone.api.BaritoneAPI;
import baritone.api.IBaritone;
import baritone.api.event.events.BlockChangeEvent;
import baritone.api.event.events.ChatEvent;
import baritone.api.event.events.ChunkEvent;
import baritone.api.event.events.ChunkEvent.Type;
import baritone.api.event.events.type.EventState;
import baritone.api.utils.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin({glp.class})
public abstract class MixinClientPlayNetHandler extends gll {

   protected MixinClientPlayNetHandler(fqq var1, vv var2, glt var3) {
      super(var1, var2, var3);
   }

   @Inject(
      method = {"sendChat(Ljava/lang/String;)V"},
      at = {         @At("HEAD")},
      cancellable = true
   )
   private void sendChatMessage(String var1, CallbackInfo var2) {
      ChatEvent var4 = new ChatEvent(var1);
      IBaritone var3;
      if((var3 = BaritoneAPI.getProvider().getBaritoneForPlayer(this.a.t)) != null) {
         var3.getGameEventHandler().onSendChatMessage(var4);
         if(var4.isCancelled()) {
            var2.cancel();
         }

      }
   }

   @Inject(
      method = {"handleLevelChunkWithLight"},
      at = {         @At("RETURN")}
   )
   private void postHandleChunkData(adr var1, CallbackInfo var2) {
      Iterator var5 = BaritoneAPI.getProvider().getAllBaritones().iterator();

      while(var5.hasNext()) {
         IBaritone var3;
         gqm var4;
         if((var4 = (var3 = (IBaritone)var5.next()).getPlayerContext().player()) != null && var4.j == (glp)this) {
            var3.getGameEventHandler().onChunkEvent(new ChunkEvent(EventState.POST, !var1.c()?Type.POPULATE_FULL:Type.POPULATE_PARTIAL, var1.b(), var1.e()));
         }
      }

   }

   @Inject(
      method = {"handleForgetLevelChunk"},
      at = {         @At("HEAD")}
   )
   private void preChunkUnload(adl var1, CallbackInfo var2) {
      Iterator var5 = BaritoneAPI.getProvider().getAllBaritones().iterator();

      while(var5.hasNext()) {
         IBaritone var3;
         gqm var4;
         if((var4 = (var3 = (IBaritone)var5.next()).getPlayerContext().player()) != null && var4.j == (glp)this) {
            var3.getGameEventHandler().onChunkEvent(new ChunkEvent(EventState.PRE, Type.UNLOAD, var1.b().h, var1.b().i));
         }
      }

   }

   @Inject(
      method = {"handleForgetLevelChunk"},
      at = {         @At("RETURN")}
   )
   private void postChunkUnload(adl var1, CallbackInfo var2) {
      Iterator var5 = BaritoneAPI.getProvider().getAllBaritones().iterator();

      while(var5.hasNext()) {
         IBaritone var3;
         gqm var4;
         if((var4 = (var3 = (IBaritone)var5.next()).getPlayerContext().player()) != null && var4.j == (glp)this) {
            var3.getGameEventHandler().onChunkEvent(new ChunkEvent(EventState.POST, Type.UNLOAD, var1.b().h, var1.b().i));
         }
      }

   }

   @Inject(
      method = {"handleBlockUpdate"},
      at = {         @At("RETURN")}
   )
   private void postHandleBlockChange(acn var1, CallbackInfo var2) {
      if(((Boolean)a.a().repackOnAnyBlockChange.value).booleanValue()) {
         if(m.a.contains(var1.b().b())) {
            Iterator var5 = BaritoneAPI.getProvider().getAllBaritones().iterator();

            while(var5.hasNext()) {
               IBaritone var3;
               gqm var4;
               if((var4 = (var3 = (IBaritone)var5.next()).getPlayerContext().player()) != null && var4.j == (glp)this) {
                  var3.getGameEventHandler().onChunkEvent(new ChunkEvent(EventState.POST, Type.POPULATE_FULL, var1.e().u() >> 4, var1.e().w() >> 4));
               }
            }

         }
      }
   }

   @Inject(
      method = {"handleChunkBlocksUpdate"},
      at = {         @At("RETURN")}
   )
   private void postHandleMultiBlockChange(aez var1, CallbackInfo var2) {
      IBaritone var4;
      if((var4 = BaritoneAPI.getProvider().getBaritoneForConnection((glp)this)) != null) {
         ArrayList var3 = new ArrayList();
         var1.a(var3);
         if(!var3.isEmpty()) {
            var4.getGameEventHandler().onBlockChange(new BlockChangeEvent(new djo((iw)((Pair)var3.get(0)).first()), var3));
         }
      }
   }

   @Inject(
      method = {"handlePlayerCombatKill"},
      at = {         @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/player/LocalPlayer;shouldShowDeathScreen()Z"
         )}
   )
   private void onPlayerDeath(aek var1, CallbackInfo var2) {
      Iterator var4 = BaritoneAPI.getProvider().getAllBaritones().iterator();

      while(var4.hasNext()) {
         gqm var3;
         IBaritone var5;
         if((var3 = (var5 = (IBaritone)var4.next()).getPlayerContext().player()) != null && var3.j == (glp)this) {
            var5.getGameEventHandler().onPlayerDeath();
         }
      }

   }

   // $FF: synthetic method
   private static void lambda$postHandleMultiBlockChange$0(List var0, iw var1, ebq var2) {
      var0.add(new Pair(var1.j(), var2));
   }
}
