package baritone.command.defaults;

import baritone.b;
import baritone.api.command.Command;
import baritone.api.command.argument.IArgConsumer;
import baritone.api.command.datatypes.EntityClassById;
import baritone.api.command.datatypes.IDatatypeFor;
import baritone.api.command.datatypes.NearbyPlayer;
import baritone.api.command.exception.CommandErrorMessageException;
import baritone.api.command.helpers.TabCompleteHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;

public final class FollowCommand extends Command {

   public FollowCommand(baritone.a var1) {
      super(var1, new String[]{"follow"});
   }

   public final void execute(String param1, IArgConsumer param2) {
      // $FF: Couldn't be decompiled
   }

   public final Stream tabComplete(String var1, IArgConsumer var2) {
      if(var2.hasExactlyOne()) {
         return (new TabCompleteHelper()).append(FollowCommand.FollowGroup.class).append(FollowCommand.FollowList.class).filterPrefix(var2.getString()).stream();
      } else {
         IDatatypeFor var4;
         try {
            var4 = ((FollowCommand.FollowList)var2.getEnum(FollowCommand.FollowList.class)).a;
         } catch (NullPointerException var3) {
            return Stream.empty();
         }

         while(var2.has(2)) {
            if(var2.peekDatatypeOrNull(var4) == null) {
               return Stream.empty();
            }

            var2.get();
         }

         return var2.tabCompleteDatatype(var4);
      }
   }

   public final String getShortDesc() {
      return "Follow entity things";
   }

   public final List getLongDesc() {
      return Arrays.asList(new String[]{"The follow command tells Baritone to follow certain kinds of entities.", "", "Usage:", "> follow entities - Follows all entities.", "> follow entity <entity1> <entity2> <...> - Follow certain entities (for example \'skeleton\', \'horse\' etc.)", "> follow players - Follow players", "> follow player <username1> <username2> <...> - Follow certain players"});
   }

   // $FF: synthetic method
   private static boolean a(List var0, bxe var1) {
      return var0.stream().anyMatch(var1);
   }

   // $FF: synthetic method
   private static boolean a(bxe var0, bxn var1) {
      return var0.an().equals(var1);
   }

   @b
   private static enum FollowGroup {

      a,
      b;
      final Predicate a;
      // $FF: synthetic field
      private static final FollowCommand.FollowGroup[] a;


      private FollowGroup(Predicate var3) {
         this.a = var3;
      }

      static {
         Objects.requireNonNull(byf.class);
         a = new FollowCommand.FollowGroup("ENTITIES", 0, byf.class);
         Objects.requireNonNull(csi.class);
         b = new FollowCommand.FollowGroup("PLAYERS", 1, csi.class);
         a = new FollowCommand.FollowGroup[]{a, b};
      }
   }

   @b
   private static enum FollowList {

      a(EntityClassById.INSTANCE),
      b(NearbyPlayer.INSTANCE);
      final IDatatypeFor a;
      // $FF: synthetic field
      private static final FollowCommand.FollowList[] a = new FollowCommand.FollowList[]{a, b};


      private FollowList(IDatatypeFor var3) {
         this.a = var3;
      }

   }

   public static class a extends CommandErrorMessageException {

      protected a() {
         super("No valid entities in range!");
      }
   }
}
