package baritone;

import baritone.a;
import baritone.api.command.Command;
import baritone.api.command.argument.IArgConsumer;
import baritone.api.command.datatypes.ForBlockOptionalMeta;
import baritone.api.command.datatypes.RelativeCoordinate;
import baritone.api.command.datatypes.RelativeGoal;
import baritone.api.pathing.goals.Goal;
import baritone.api.utils.BetterBlockPos;
import baritone.api.utils.BlockOptionalMeta;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public final class ay extends Command {

   protected ay(a var1) {
      super(var1, new String[]{"goto"});
   }

   public final void execute(String var1, IArgConsumer var2) {
      if(var2.peekDatatypeOrNull(RelativeCoordinate.INSTANCE) != null) {
         var2.requireMax(3);
         BetterBlockPos var4 = super.ctx.playerFeet();
         Goal var5 = (Goal)var2.getDatatypePost(RelativeGoal.INSTANCE, var4);
         this.logDirect(String.format("Going to: %s", new Object[]{var5.toString()}));
         super.baritone.getCustomGoalProcess().setGoalAndPath(var5);
      } else {
         var2.requireMax(1);
         BlockOptionalMeta var3 = (BlockOptionalMeta)var2.getDatatypeFor(ForBlockOptionalMeta.INSTANCE);
         super.baritone.getGetToBlockProcess().getToBlock(var3);
      }
   }

   public final Stream tabComplete(String var1, IArgConsumer var2) {
      var2.requireMax(1);
      return var2.tabCompleteDatatype(ForBlockOptionalMeta.INSTANCE);
   }

   public final String getShortDesc() {
      return "Go to a coordinate or block";
   }

   public final List getLongDesc() {
      return Arrays.asList(new String[]{"The goto command tells Baritone to head towards a given goal or block.", "", "Wherever a coordinate is expected, you can use ~ just like in regular Minecraft commands. Or, you can just use regular numbers.", "", "Usage:", "> goto <block> - Go to a block, wherever it is in the world", "> goto <y> - Go to a Y level", "> goto <x> <z> - Go to an X,Z position", "> goto <x> <y> <z> - Go to an X,Y,Z position"});
   }
}
