package baritone;

import baritone.a;
import baritone.api.command.Command;
import baritone.api.command.argument.IArgConsumer;
import baritone.api.command.datatypes.RelativeFile;
import baritone.api.command.exception.CommandInvalidStateException;
import baritone.api.command.exception.CommandInvalidTypeException;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public final class as extends Command {

   public as(a var1) {
      super(var1, new String[]{"explorefilter"});
   }

   public final void execute(String var1, IArgConsumer var2) {
      var2.requireMax(2);
      File var7 = (File)var2.getDatatypePost(RelativeFile.INSTANCE, super.ctx.minecraft().q.getAbsoluteFile().getParentFile());
      boolean var3 = false;
      if(var2.hasAny()) {
         if(!var2.getString().equalsIgnoreCase("invert")) {
            throw new CommandInvalidTypeException(var2.consumed(), "either \"invert\" or nothing");
         }

         var3 = true;
      }

      try {
         super.baritone.getExploreProcess().applyJsonFilter(var7.toPath().toAbsolutePath(), var3);
      } catch (NoSuchFileException var4) {
         throw new CommandInvalidStateException("File not found");
      } catch (JsonSyntaxException var5) {
         throw new CommandInvalidStateException("Invalid JSON syntax");
      } catch (Exception var6) {
         throw new IllegalStateException(var6);
      }

      this.logDirect(String.format("Explore filter applied. Inverted: %s", new Object[]{Boolean.toString(var3)}));
   }

   public final Stream tabComplete(String var1, IArgConsumer var2) {
      return var2.hasExactlyOne()?RelativeFile.tabComplete(var2, RelativeFile.gameDir(super.ctx.minecraft())):Stream.empty();
   }

   public final String getShortDesc() {
      return "Explore chunks from a json";
   }

   public final List getLongDesc() {
      return Arrays.asList(new String[]{"Apply an explore filter before using explore, which tells the explore process which chunks have been explored/not explored.", "", "The JSON file will follow this format: [{\"x\":0,\"z\":0},...]", "", "If \'invert\' is specified, the chunks listed will be considered NOT explored, rather than explored.", "", "Usage:", "> explorefilter <path> [invert] - Load the JSON file referenced by the specified path. If invert is specified, it must be the literal word \'invert\'."});
   }
}
