package baritone.api.utils;

import baritone.api.BaritoneAPI;
import baritone.api.utils.IPlayerContext;
import baritone.api.utils.RayTraceUtils;
import baritone.api.utils.Rotation;
import baritone.api.utils.VecUtils;
import fga.a;
import java.util.Optional;

public final class RotationUtils {

   public static final double DEG_TO_RAD = 0.017453292519943295D;
   public static final float DEG_TO_RAD_F = 0.017453292F;
   public static final double RAD_TO_DEG = 57.29577951308232D;
   public static final float RAD_TO_DEG_F = 57.29578F;
   private static final fgc[] BLOCK_SIDE_MULTIPLIERS = new fgc[]{new fgc(0.5D, 0.0D, 0.5D), new fgc(0.5D, 1.0D, 0.5D), new fgc(0.5D, 0.5D, 0.0D), new fgc(0.5D, 0.5D, 1.0D), new fgc(0.0D, 0.5D, 0.5D), new fgc(1.0D, 0.5D, 0.5D)};


   public static Rotation calcRotationFromCoords(iw var0, iw var1) {
      return calcRotationFromVec3d(new fgc((double)var0.u(), (double)var0.v(), (double)var0.w()), new fgc((double)var1.u(), (double)var1.v(), (double)var1.w()));
   }

   public static Rotation wrapAnglesToRelative(Rotation var0, Rotation var1) {
      return var0.yawIsReallyClose(var1)?new Rotation(var0.getYaw(), var1.getPitch()):var1.subtract(var0).normalize().add(var0);
   }

   public static Rotation calcRotationFromVec3d(fgc var0, fgc var1, Rotation var2) {
      return wrapAnglesToRelative(var2, calcRotationFromVec3d(var0, var1));
   }

   private static Rotation calcRotationFromVec3d(fgc var0, fgc var1) {
      double[] var8;
      double var2 = azz.d((var8 = new double[]{var0.d - var1.d, var0.e - var1.e, var0.f - var1.f})[0], -var8[2]);
      double var4 = Math.sqrt(var8[0] * var8[0] + var8[2] * var8[2]);
      double var6 = azz.d(var8[1], var4);
      return new Rotation((float)(var2 * 57.29577951308232D), (float)(var6 * 57.29577951308232D));
   }

   public static fgc calcLookDirectionFromRotation(Rotation var0) {
      float var1 = azz.b(-var0.getYaw() * 0.017453292F - 3.1415927F);
      float var2 = azz.a(-var0.getYaw() * 0.017453292F - 3.1415927F);
      float var3 = -azz.b(-var0.getPitch() * 0.017453292F);
      float var4 = azz.a(-var0.getPitch() * 0.017453292F);
      return new fgc((double)(var2 * var3), (double)var4, (double)(var1 * var3));
   }

   @Deprecated
   public static fgc calcVec3dFromRotation(Rotation var0) {
      return calcLookDirectionFromRotation(var0);
   }

   public static Optional reachable(IPlayerContext var0, iw var1) {
      return reachable(var0, var1, false);
   }

   public static Optional reachable(IPlayerContext var0, iw var1, boolean var2) {
      return reachable((IPlayerContext)var0, var1, var0.playerController().getBlockReachDistance(), var2);
   }

   public static Optional reachable(IPlayerContext var0, iw var1, double var2) {
      return reachable((IPlayerContext)var0, var1, var2, false);
   }

   public static Optional reachable(IPlayerContext var0, iw var1, double var2, boolean var4) {
      if(((Boolean)BaritoneAPI.getSettings().remainWithExistingLookDirection.value).booleanValue() && var0.isLookingAt(var1)) {
         Rotation var5 = var0.playerRotations().add(new Rotation(0.0F, 1.0E-4F));
         if(!var4) {
            return Optional.of(var5);
         }

         fga var6;
         if((var6 = RayTraceUtils.rayTraceTowards(var0.player(), var5, var2, true)) != null && var6.d() == a.b && ((ffy)var6).b().equals(var1)) {
            return Optional.of(var5);
         }
      }

      Optional var16;
      if((var16 = reachableCenter((IPlayerContext)var0, var1, var2, var4)).isPresent()) {
         return var16;
      } else {
         fgw var18;
         if((var18 = var0.world().a_(var1).f(var0.world(), var1)).c()) {
            var18 = fgt.b();
         }

         fgc[] var7 = BLOCK_SIDE_MULTIPLIERS;
         int var8 = BLOCK_SIDE_MULTIPLIERS.length;

         for(int var9 = 0; var9 < var8; ++var9) {
            fgc var17 = var7[var9];
            double var10 = var18.b(jc.a.a) * var17.d + var18.c(jc.a.a) * (1.0D - var17.d);
            double var12 = var18.b(jc.a.b) * var17.e + var18.c(jc.a.b) * (1.0D - var17.e);
            double var14 = var18.b(jc.a.c) * var17.f + var18.c(jc.a.c) * (1.0D - var17.f);
            if((var16 = reachableOffset((IPlayerContext)var0, var1, (new fgc((double)var1.u(), (double)var1.v(), (double)var1.w())).b(var10, var12, var14), var2, var4)).isPresent()) {
               return var16;
            }
         }

         return Optional.empty();
      }
   }

   public static Optional reachableOffset(IPlayerContext var0, iw var1, fgc var2, double var3, boolean var5) {
      Rotation var7 = calcRotationFromVec3d(var5?RayTraceUtils.inferSneakingEyePosition(var0.player()):var0.player().n(1.0F), var2, var0.playerRotations());
      Rotation var6 = BaritoneAPI.getProvider().getBaritoneForPlayer(var0.player()).getLookBehavior().getAimProcessor().peekRotation(var7);
      fga var8;
      if((var8 = RayTraceUtils.rayTraceTowards(var0.player(), var6, var3, var5)) != null && var8.d() == a.b) {
         if(((ffy)var8).b().equals(var1)) {
            return Optional.of(var7);
         }

         if(var0.world().a_(var1).b() instanceof dnb && ((ffy)var8).b().equals(var1.e())) {
            return Optional.of(var7);
         }
      }

      return Optional.empty();
   }

   public static Optional reachableCenter(IPlayerContext var0, iw var1, double var2, boolean var4) {
      return reachableOffset((IPlayerContext)var0, var1, VecUtils.calculateBlockCenter(var0.world(), var1), var2, var4);
   }

   @Deprecated
   public static Optional reachable(gqm var0, iw var1, double var2) {
      return reachable((gqm)var0, var1, var2, false);
   }

   @Deprecated
   public static Optional reachable(gqm var0, iw var1, double var2, boolean var4) {
      return reachable((IPlayerContext)BaritoneAPI.getProvider().getBaritoneForPlayer(var0).getPlayerContext(), var1, var2, var4);
   }

   @Deprecated
   public static Optional reachableOffset(bxe var0, iw var1, fgc var2, double var3, boolean var5) {
      Rotation var6 = calcRotationFromVec3d(var5?RayTraceUtils.inferSneakingEyePosition(var0):var0.n(1.0F), var2, new Rotation(var0.dL(), var0.dN()));
      fga var7;
      if((var7 = RayTraceUtils.rayTraceTowards(var0, var6, var3, var5)) != null && var7.d() == a.b) {
         if(((ffy)var7).b().equals(var1)) {
            return Optional.of(var6);
         }

         if(var0.dV().a_(var1).b() instanceof dnb && ((ffy)var7).b().equals(var1.e())) {
            return Optional.of(var6);
         }
      }

      return Optional.empty();
   }

   @Deprecated
   public static Optional reachableCenter(bxe var0, iw var1, double var2, boolean var4) {
      return reachableOffset((bxe)var0, var1, VecUtils.calculateBlockCenter(var0.dV(), var1), var2, var4);
   }

}
