package baritone.api.utils;

import baritone.api.cache.IWorldData;
import baritone.api.utils.BetterBlockPos;
import baritone.api.utils.IPlayerController;
import baritone.api.utils.Rotation;
import fga.a;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface IPlayerContext {

   fqq minecraft();

   gqm player();

   IPlayerController playerController();

   dkj world();

   default Iterable entities() {
      return ((glo)this.world()).d();
   }

   default Stream entitiesStream() {
      return StreamSupport.stream(this.entities().spliterator(), false);
   }

   IWorldData worldData();

   fga objectMouseOver();

   default BetterBlockPos playerFeet() {
      BetterBlockPos var1 = new BetterBlockPos(this.player().dt().d, this.player().dt().e + 0.1251D, this.player().dt().f);

      try {
         if(this.world().a_(var1).b() instanceof dvb) {
            return var1.above();
         }
      } catch (NullPointerException var2) {
         ;
      }

      return var1;
   }

   default fgc playerFeetAsVec() {
      return new fgc(this.player().dt().d, this.player().dt().e, this.player().dt().f);
   }

   default fgc playerHead() {
      return new fgc(this.player().dt().d, this.player().dt().e + (double)this.player().cS(), this.player().dt().f);
   }

   default fgc playerMotion() {
      return this.player().dy();
   }

   BetterBlockPos viewerPos();

   default Rotation playerRotations() {
      return new Rotation(this.player().dL(), this.player().dN());
   }

   @Deprecated
   static default double eyeHeight(boolean var0) {
      return var0?1.27D:1.62D;
   }

   default Optional getSelectedBlock() {
      fga var1;
      return (var1 = this.objectMouseOver()) != null && var1.d() == a.b?Optional.of(((ffy)var1).b()):Optional.empty();
   }

   default boolean isLookingAt(iw var1) {
      return this.getSelectedBlock().equals(Optional.of(var1));
   }
}
