package baritone.api.utils;

import baritone.api.utils.BlockOptionalMeta;
import baritone.api.utils.accessor.IItemStack;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class BlockOptionalMetaLookup {

   private final ImmutableSet blockSet;
   private final ImmutableSet blockStateSet;
   private final ImmutableSet stackHashes;
   private final BlockOptionalMeta[] boms;


   public BlockOptionalMetaLookup(BlockOptionalMeta ... var1) {
      this.boms = var1;
      HashSet var2 = new HashSet();
      HashSet var3 = new HashSet();
      HashSet var4 = new HashSet();
      int var5 = var1.length;

      for(int var6 = 0; var6 < var5; ++var6) {
         BlockOptionalMeta var7 = var1[var6];
         var2.add(var7.getBlock());
         var3.addAll(var7.getAllBlockStates());
         var4.addAll(var7.stackHashes());
      }

      this.blockSet = ImmutableSet.copyOf(var2);
      this.blockStateSet = ImmutableSet.copyOf(var3);
      this.stackHashes = ImmutableSet.copyOf(var4);
   }

   public BlockOptionalMetaLookup(dno ... param1) {
      // $FF: Couldn't be decompiled
   }

   public BlockOptionalMetaLookup(List param1) {
      // $FF: Couldn't be decompiled
   }

   public BlockOptionalMetaLookup(String ... param1) {
      // $FF: Couldn't be decompiled
   }

   public boolean has(dno var1) {
      return this.blockSet.contains(var1);
   }

   public boolean has(ebq var1) {
      return this.blockStateSet.contains(var1);
   }

   public boolean has(dak var1) {
      int var2 = ((IItemStack)var1).getBaritoneHash() - var1.o();
      return this.stackHashes.contains(Integer.valueOf(var2));
   }

   public List blocks() {
      return Arrays.asList(this.boms);
   }

   public String toString() {
      return String.format("BlockOptionalMetaLookup{%s}", new Object[]{Arrays.toString(this.boms)});
   }

   // $FF: synthetic method
   private static BlockOptionalMeta[] lambda$new$2(int var0) {
      return new BlockOptionalMeta[var0];
   }

   // $FF: synthetic method
   private static BlockOptionalMeta[] lambda$new$1(int var0) {
      return new BlockOptionalMeta[var0];
   }

   // $FF: synthetic method
   private static BlockOptionalMeta[] lambda$new$0(int var0) {
      return new BlockOptionalMeta[var0];
   }
}
