package baritone.api.utils;

import amb.b;
import baritone.api.utils.BlockUtils;
import baritone.api.utils.accessor.IItemStack;
import baritone.api.utils.accessor.ILootTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableMap.Builder;
import fah.c;
import faw.a;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.Map.Entry;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import sun.misc.Unsafe;

public final class BlockOptionalMeta {

   private static final Pattern PATTERN = Pattern.compile("^(?<id>.+?)(?:\\[(?<properties>.+?)?\\])?$");
   private final dno block;
   private final String propertiesDescription;
   private final Set blockstates;
   private final ImmutableSet stateHashes;
   private final ImmutableSet stackHashes;
   private static Map drops = new HashMap();
   private static Method getVanillaServerPack;


   public BlockOptionalMeta(@Nonnull dno var1) {
      this.block = var1;
      this.propertiesDescription = "{}";
      this.blockstates = getStates(var1, Collections.emptyMap());
      this.stateHashes = getStateHashes(this.blockstates);
      this.stackHashes = getStackHashes(this.blockstates);
   }

   public BlockOptionalMeta(@Nonnull String var1) {
      Matcher var3;
      if(!(var3 = PATTERN.matcher(var1)).find()) {
         throw new IllegalArgumentException("invalid block selector");
      } else {
         this.block = BlockUtils.stringToBlockRequired(var3.group("id"));
         Map var2 = (var1 = var3.group("properties")) != null && !var1.equals("")?parseProperties(this.block, var1):Collections.emptyMap();
         this.propertiesDescription = var1 == null?"{}":var1.replace("=", ":");
         this.blockstates = getStates(this.block, var2);
         this.stateHashes = getStateHashes(this.blockstates);
         this.stackHashes = getStackHashes(this.blockstates);
      }
   }

   private static ect castToIProperty(Object var0) {
      return (ect)var0;
   }

   private static Map parseProperties(dno var0, String var1) {
      Builder var2 = ImmutableMap.builder();
      String[] var7;
      int var3 = (var7 = var1.split(",")).length;

      for(int var4 = 0; var4 < var3; ++var4) {
         String var5;
         String[] var6;
         if((var6 = (var5 = var7[var4]).split("=")).length != 2) {
            throw new IllegalArgumentException(String.format("\"%s\" is not a valid property-value pair", new Object[]{var5}));
         }

         var5 = var6[0];
         String var9 = var6[1];
         ect var8;
         castToIProperty(var8 = var0.l().a(var5)).b(var9);
         Comparable var10 = (Comparable)var8.orElseThrow(var0);
         var2.put(var8, var10);
      }

      return var2.build();
   }

   private static Set getStates(@Nonnull dno var0, @Nonnull Map var1) {
      return (Set)var0.l().a().stream().filter(var1).collect(Collectors.toSet());
   }

   private static ImmutableSet getStateHashes(Set param0) {
      // $FF: Couldn't be decompiled
   }

   private static ImmutableSet getStackHashes(Set param0) {
      // $FF: Couldn't be decompiled
   }

   public final dno getBlock() {
      return this.block;
   }

   public final boolean matches(@Nonnull dno var1) {
      return var1 == this.block;
   }

   public final boolean matches(@Nonnull ebq var1) {
      return var1.b() == this.block && this.stateHashes.contains(Integer.valueOf(var1.hashCode()));
   }

   public final boolean matches(dak var1) {
      int var2 = ((IItemStack)var1).getBaritoneHash() - var1.o();
      return this.stackHashes.contains(Integer.valueOf(var2));
   }

   public final String toString() {
      return String.format("BlockOptionalMeta{block=%s,properties=%s}", new Object[]{this.block, this.propertiesDescription});
   }

   public final ebq getAnyBlockState() {
      return this.blockstates.size() > 0?(ebq)this.blockstates.iterator().next():null;
   }

   public final Set getAllBlockStates() {
      return this.blockstates;
   }

   public final Set stackHashes() {
      return this.stackHashes;
   }

   private static aue getVanillaServerPack() {
      // $FF: Couldn't be decompiled
   }

   private static synchronized List drops(dno var0) {
      return (List)drops.computeIfAbsent(var0, var0);
   }

   private static List getDrops(dno var0, a var1) {
      Optional var2;
      faw var3;
      return (List)((var2 = var0.u()).isEmpty()?Collections.emptyList():((ILootTable)((BlockOptionalMeta.ServerLevelStub)(var3 = var1.a(fdn.g, var0.m()).a(fdm.r)).a()).holder().b((alq)var2.get())).invokeGetRandomItems((new fat.a(var3)).a(1L).a((Optional)null)));
   }

   // $FF: synthetic method
   private static List lambda$drops$9(dno param0, dno param1) {
      // $FF: Couldn't be decompiled
   }

   // $FF: synthetic method
   private static boolean lambda$getVanillaServerPack$8(Method var0) {
      return var0.getReturnType() == aue.class;
   }

   // $FF: synthetic method
   private static Integer[] lambda$getStackHashes$7(int var0) {
      return new Integer[var0];
   }

   // $FF: synthetic method
   private static Integer lambda$getStackHashes$6(dak var0) {
      return Integer.valueOf(((IItemStack)var0).getBaritoneHash());
   }

   // $FF: synthetic method
   private static Stream lambda$getStackHashes$5(ebq param0) {
      // $FF: Couldn't be decompiled
   }

   // $FF: synthetic method
   private static dak lambda$getStackHashes$4(dag var0) {
      return new dak(var0, 1);
   }

   // $FF: synthetic method
   private static Integer[] lambda$getStateHashes$3(int var0) {
      return new Integer[var0];
   }

   // $FF: synthetic method
   private static boolean lambda$getStates$2(Map var0, ebq var1) {
      return var0.entrySet().stream().allMatch(var1);
   }

   // $FF: synthetic method
   private static boolean lambda$getStates$1(ebq var0, Entry var1) {
      return var0.c((ect)var1.getKey()) == var1.getValue();
   }

   // $FF: synthetic method
   private static IllegalArgumentException lambda$parseProperties$0(String var0, ect var1, dno var2) {
      return new IllegalArgumentException(String.format("\"%s\" is not a valid value for %s on %s", new Object[]{var0, var1, var2}));
   }


   public static class ServerLevelStub extends asb {

      private static fqq client = fqq.Q();
      private static Unsafe unsafe = getUnsafe();
      private static CompletableFuture registryAccess = load();


      public ServerLevelStub(MinecraftServer var1, Executor var2, c var3, fam var4, alq var5, efo var6, asl var7, boolean var8, long var9, List var11, boolean var12, @Nullable bvh var13) {
         super(var1, var2, var3, var4, var5, var6, var7, var8, var9, var11, var12, var13);
      }

      public cvs K() {
         assert client.s != null;

         return client.s.K();
      }

      public static BlockOptionalMeta.ServerLevelStub fastCreate() {
         try {
            return (BlockOptionalMeta.ServerLevelStub)unsafe.allocateInstance(BlockOptionalMeta.ServerLevelStub.class);
         } catch (InstantiationException var1) {
            throw new RuntimeException(var1);
         }
      }

      public ju J_() {
         return (ju)registryAccess.join();
      }

      public amb.a holder() {
         return new amb.a(this.J_().e());
      }

      public static Unsafe getUnsafe() {
         try {
            Field var0;
            (var0 = Unsafe.class.getDeclaredField("theUnsafe")).setAccessible(true);
            return (Unsafe)var0.get((Object)null);
         } catch (Exception var1) {
            throw new RuntimeException(var1);
         }
      }

      public static CompletableFuture load() {
         // $FF: Couldn't be decompiled
      }

      // $FF: synthetic method
      public edr S() {
         return super.m();
      }

      // $FF: synthetic method
      public edn a(int var1, int var2) {
         return super.d(var1, var2);
      }

      // $FF: synthetic method
      public fhq T() {
         return super.o();
      }

      // $FF: synthetic method
      public fhq U() {
         return super.n();
      }

      // $FF: synthetic method
      public dfc Q() {
         return super.t();
      }

      // $FF: synthetic method
      public fhh R() {
         return super.g();
      }

      @org.jetbrains.annotations.Nullable
      // $FF: synthetic method
      public egj c(UUID var1) {
         return super.b(var1);
      }

      // $FF: synthetic method
      private static ju lambda$load$0(b var0) {
         return var0.a().a();
      }

   }
}
