package baritone.api.utils;

import baritone.api.utils.SettingsUtil;
import javax.annotation.Nonnull;
import jc.a;

public final class BetterBlockPos extends iw {

   private static final int NUM_X_BITS = 26;
   private static final int NUM_Z_BITS = 26;
   private static final int NUM_Y_BITS = 12;
   private static final int Y_SHIFT = 26;
   private static final int X_SHIFT = 38;
   private static final long X_MASK = 67108863L;
   private static final long Y_MASK = 4095L;
   private static final long Z_MASK = 67108863L;
   public static final BetterBlockPos ORIGIN = new BetterBlockPos(0, 0, 0);
   public final int x;
   public final int y;
   public final int z;


   public BetterBlockPos(int var1, int var2, int var3) {
      super(var1, var2, var3);
      this.x = var1;
      this.y = var2;
      this.z = var3;
   }

   public BetterBlockPos(double var1, double var3, double var5) {
      this(azz.a(var1), azz.a(var3), azz.a(var5));
   }

   public BetterBlockPos(iw var1) {
      this(var1.u(), var1.v(), var1.w());
   }

   public static BetterBlockPos from(iw var0) {
      return var0 == null?null:new BetterBlockPos(var0);
   }

   public final int hashCode() {
      return (int)longHash(this.x, this.y, this.z);
   }

   public static long longHash(BetterBlockPos var0) {
      return longHash(var0.x, var0.y, var0.z);
   }

   public static long longHash(int var0, int var1, int var2) {
      long var3 = 11206370049L + (long)var0;
      var3 = 8734625L * var3 + (long)var1;
      return 2873465L * var3 + (long)var2;
   }

   public final boolean equals(Object var1) {
      BetterBlockPos var2;
      iw var3;
      return var1 == null?false:(var1 instanceof BetterBlockPos?(var2 = (BetterBlockPos)var1).x == this.x && var2.y == this.y && var2.z == this.z:(var3 = (iw)var1).u() == this.x && var3.v() == this.y && var3.w() == this.z);
   }

   public final BetterBlockPos above() {
      return new BetterBlockPos(this.x, this.y + 1, this.z);
   }

   public final BetterBlockPos above(int var1) {
      return var1 == 0?this:new BetterBlockPos(this.x, this.y + var1, this.z);
   }

   public final BetterBlockPos below() {
      return new BetterBlockPos(this.x, this.y - 1, this.z);
   }

   public final BetterBlockPos below(int var1) {
      return var1 == 0?this:new BetterBlockPos(this.x, this.y - var1, this.z);
   }

   public final BetterBlockPos relative(jc var1) {
      kb var2 = var1.q();
      return new BetterBlockPos(this.x + var2.u(), this.y + var2.v(), this.z + var2.w());
   }

   public final BetterBlockPos relative(jc var1, int var2) {
      if(var2 == 0) {
         return this;
      } else {
         kb var3 = var1.q();
         return new BetterBlockPos(this.x + var3.u() * var2, this.y + var3.v() * var2, this.z + var3.w() * var2);
      }
   }

   public final BetterBlockPos north() {
      return new BetterBlockPos(this.x, this.y, this.z - 1);
   }

   public final BetterBlockPos north(int var1) {
      return var1 == 0?this:new BetterBlockPos(this.x, this.y, this.z - var1);
   }

   public final BetterBlockPos south() {
      return new BetterBlockPos(this.x, this.y, this.z + 1);
   }

   public final BetterBlockPos south(int var1) {
      return var1 == 0?this:new BetterBlockPos(this.x, this.y, this.z + var1);
   }

   public final BetterBlockPos east() {
      return new BetterBlockPos(this.x + 1, this.y, this.z);
   }

   public final BetterBlockPos east(int var1) {
      return var1 == 0?this:new BetterBlockPos(this.x + var1, this.y, this.z);
   }

   public final BetterBlockPos west() {
      return new BetterBlockPos(this.x - 1, this.y, this.z);
   }

   public final BetterBlockPos west(int var1) {
      return var1 == 0?this:new BetterBlockPos(this.x - var1, this.y, this.z);
   }

   public final double distanceSq(BetterBlockPos var1) {
      double var2 = (double)this.x - (double)var1.x;
      double var4 = (double)this.y - (double)var1.y;
      double var6 = (double)this.z - (double)var1.z;
      return var2 * var2 + var4 * var4 + var6 * var6;
   }

   public final double distanceTo(BetterBlockPos var1) {
      double var2 = (double)this.x - (double)var1.x;
      double var4 = (double)this.y - (double)var1.y;
      double var6 = (double)this.z - (double)var1.z;
      return Math.sqrt(var2 * var2 + var4 * var4 + var6 * var6);
   }

   @Nonnull
   public final String toString() {
      return String.format("BetterBlockPos{x=%s,y=%s,z=%s}", new Object[]{SettingsUtil.maybeCensor(this.x), SettingsUtil.maybeCensor(this.y), SettingsUtil.maybeCensor(this.z)});
   }

   public static long serializeToLong(int var0, int var1, int var2) {
      return ((long)var0 & 67108863L) << 38 | ((long)var1 & 4095L) << 26 | (long)var2 & 67108863L;
   }

   public static BetterBlockPos deserializeFromLong(long var0) {
      int var2 = (int)(var0 >> 38);
      int var3 = (int)(var0 << 26 >> 52);
      int var4 = (int)(var0 << 38 >> 38);
      return new BetterBlockPos(var2, var3, var4);
   }

   // $FF: synthetic method
   public final iw a(jc var1, int var2) {
      return this.relative(var1, var2);
   }

   // $FF: synthetic method
   public final iw a(jc var1) {
      return this.relative(var1);
   }

   // $FF: synthetic method
   public final iw g(int var1) {
      return this.east(var1);
   }

   // $FF: synthetic method
   public final iw i() {
      return this.east();
   }

   // $FF: synthetic method
   public final iw f(int var1) {
      return this.west(var1);
   }

   // $FF: synthetic method
   public final iw h() {
      return this.west();
   }

   // $FF: synthetic method
   public final iw e(int var1) {
      return this.south(var1);
   }

   // $FF: synthetic method
   public final iw g() {
      return this.south();
   }

   // $FF: synthetic method
   public final iw d(int var1) {
      return this.north(var1);
   }

   // $FF: synthetic method
   public final iw f() {
      return this.north();
   }

   // $FF: synthetic method
   public final iw c(int var1) {
      return this.below(var1);
   }

   // $FF: synthetic method
   public final iw e() {
      return this.below();
   }

   // $FF: synthetic method
   public final iw b(int var1) {
      return this.above(var1);
   }

   // $FF: synthetic method
   public final iw d() {
      return this.above();
   }

   // $FF: synthetic method
   public final kb d(kb var1) {
      return super.c(var1);
   }

   // $FF: synthetic method
   public final kb b(a var1, int var2) {
      return super.a(var1, var2);
   }

   // $FF: synthetic method
   public final kb b(jc var1, int var2) {
      return this.relative(var1, var2);
   }

   // $FF: synthetic method
   public final kb b(jc var1) {
      return this.relative(var1);
   }

   // $FF: synthetic method
   public final kb i(int var1) {
      return this.east(var1);
   }

   // $FF: synthetic method
   public final kb l() {
      return this.east();
   }

   // $FF: synthetic method
   public final kb j(int var1) {
      return this.west(var1);
   }

   // $FF: synthetic method
   public final kb m() {
      return this.west();
   }

   // $FF: synthetic method
   public final kb k(int var1) {
      return this.south(var1);
   }

   // $FF: synthetic method
   public final kb n() {
      return this.south();
   }

   // $FF: synthetic method
   public final kb l(int var1) {
      return this.north(var1);
   }

   // $FF: synthetic method
   public final kb o() {
      return this.north();
   }

   // $FF: synthetic method
   public final kb m(int var1) {
      return this.below(var1);
   }

   // $FF: synthetic method
   public final kb p() {
      return this.below();
   }

   // $FF: synthetic method
   public final kb n(int var1) {
      return this.above(var1);
   }

   // $FF: synthetic method
   public final kb q() {
      return this.above();
   }

   // $FF: synthetic method
   public final kb o(int var1) {
      return super.a(var1);
   }

   // $FF: synthetic method
   public final kb e(kb var1) {
      return super.b(var1);
   }

   // $FF: synthetic method
   public final kb f(kb var1) {
      return super.a(var1);
   }

   // $FF: synthetic method
   public final kb c(int var1, int var2, int var3) {
      return super.b(var1, var2, var3);
   }

   // $FF: synthetic method
   public final int compareTo(Object var1) {
      return super.i((kb)var1);
   }

}
