package baritone.api.schematic.mask.shape;

import baritone.api.schematic.mask.AbstractMask;
import baritone.api.schematic.mask.StaticMask;
import jc.a;

public final class CylinderMask extends AbstractMask implements StaticMask {

   private final double centerA;
   private final double centerB;
   private final double radiusSqA;
   private final double radiusSqB;
   private final boolean filled;
   private final a alignment;


   public CylinderMask(int var1, int var2, int var3, boolean var4, a var5) {
      super(var1, var2, var3);
      this.centerA = (double)getA(var1, var2, var5) / 2.0D;
      this.centerB = (double)getB(var2, var3, var5) / 2.0D;
      this.radiusSqA = (this.centerA - 1.0D) * (this.centerA - 1.0D);
      this.radiusSqB = (this.centerB - 1.0D) * (this.centerB - 1.0D);
      this.filled = var4;
      this.alignment = var5;
   }

   public final boolean partOfMask(int var1, int var2, int var3) {
      double var4 = Math.abs((double)getA(var1, var2, this.alignment) + 0.5D - this.centerA);
      double var6 = Math.abs((double)getB(var2, var3, this.alignment) + 0.5D - this.centerB);
      return this.outside(var4, var6)?false:this.filled || this.outside(var4 + 1.0D, var6) || this.outside(var4, var6 + 1.0D);
   }

   private boolean outside(double var1, double var3) {
      return var1 * var1 / this.radiusSqA + var3 * var3 / this.radiusSqB > 1.0D;
   }

   private static int getA(int var0, int var1, a var2) {
      return var2 == a.a?var1:var0;
   }

   private static int getB(int var0, int var1, a var2) {
      return var2 == a.c?var0:var1;
   }
}
