package baritone.api.schematic.mask;

import baritone.api.schematic.mask.Mask;
import baritone.api.schematic.mask.PreComputedMask;
import baritone.api.schematic.mask.operator.NotMask.Static;
import baritone.api.utils.BooleanBinaryOperators;

public interface StaticMask extends Mask {

   boolean partOfMask(int var1, int var2, int var3);

   default boolean partOfMask(int var1, int var2, int var3, ebq var4) {
      return this.partOfMask(var1, var2, var3);
   }

   default StaticMask not() {
      return new Static(this);
   }

   default StaticMask union(StaticMask var1) {
      return new baritone.api.schematic.mask.operator.BinaryOperatorMask.Static(this, var1, BooleanBinaryOperators.OR);
   }

   default StaticMask intersection(StaticMask var1) {
      return new baritone.api.schematic.mask.operator.BinaryOperatorMask.Static(this, var1, BooleanBinaryOperators.AND);
   }

   default StaticMask xor(StaticMask var1) {
      return new baritone.api.schematic.mask.operator.BinaryOperatorMask.Static(this, var1, BooleanBinaryOperators.XOR);
   }

   default StaticMask compute() {
      return new PreComputedMask(this);
   }
}
