package baritone.api.schematic;

import baritone.api.schematic.ISchematic;
import java.util.List;
import java.util.stream.Collectors;

public class RotatedSchematic implements ISchematic {

   private final ISchematic schematic;
   private final dui rotation;
   private final dui inverseRotation;


   public RotatedSchematic(ISchematic var1, dui var2) {
      this.schematic = var1;
      this.rotation = var2;
      this.inverseRotation = var2.a(var2).a(var2);
   }

   public boolean inSchematic(int var1, int var2, int var3, ebq var4) {
      return this.schematic.inSchematic(rotateX(var1, var3, this.widthX(), this.lengthZ(), this.inverseRotation), var2, rotateZ(var1, var3, this.widthX(), this.lengthZ(), this.inverseRotation), rotate((ebq)var4, this.inverseRotation));
   }

   public ebq desiredState(int var1, int var2, int var3, ebq var4, List var5) {
      return rotate((ebq)this.schematic.desiredState(rotateX(var1, var3, this.widthX(), this.lengthZ(), this.inverseRotation), var2, rotateZ(var1, var3, this.widthX(), this.lengthZ(), this.inverseRotation), rotate((ebq)var4, this.inverseRotation), rotate((List)var5, this.inverseRotation)), this.rotation);
   }

   public void reset() {
      this.schematic.reset();
   }

   public int widthX() {
      return flipsCoordinates(this.rotation)?this.schematic.lengthZ():this.schematic.widthX();
   }

   public int heightY() {
      return this.schematic.heightY();
   }

   public int lengthZ() {
      return flipsCoordinates(this.rotation)?this.schematic.widthX():this.schematic.lengthZ();
   }

   private static boolean flipsCoordinates(dui var0) {
      return var0 == dui.b || var0 == dui.d;
   }

   private static int rotateX(int var0, int var1, int var2, int var3, dui var4) {
      switch(null.$SwitchMap$net$minecraft$world$level$block$Rotation[var4.ordinal()]) {
      case 1:
         return var0;
      case 2:
         return var3 - var1 - 1;
      case 3:
         return var2 - var0 - 1;
      case 4:
         return var1;
      default:
         throw new IllegalArgumentException("Unknown rotation");
      }
   }

   private static int rotateZ(int var0, int var1, int var2, int var3, dui var4) {
      switch(null.$SwitchMap$net$minecraft$world$level$block$Rotation[var4.ordinal()]) {
      case 1:
         return var1;
      case 2:
         return var0;
      case 3:
         return var3 - var1 - 1;
      case 4:
         return var2 - var0 - 1;
      default:
         throw new IllegalArgumentException("Unknown rotation");
      }
   }

   private static ebq rotate(ebq var0, dui var1) {
      return var0 == null?null:var0.a(var1);
   }

   private static List rotate(List var0, dui var1) {
      return var0 == null?null:(List)var0.stream().map(var1).collect(Collectors.toList());
   }

   // $FF: synthetic method
   private static ebq lambda$rotate$0(dui var0, ebq var1) {
      return rotate((ebq)var1, var0);
   }
}
