package baritone.api.schematic;

import baritone.api.schematic.ISchematic;
import baritone.api.schematic.MaskSchematic;
import baritone.api.utils.BlockOptionalMetaLookup;

public class ReplaceSchematic extends MaskSchematic {

   private final BlockOptionalMetaLookup filter;
   private final Boolean[][][] cache;


   public ReplaceSchematic(ISchematic var1, BlockOptionalMetaLookup var2) {
      super(var1);
      this.filter = var2;
      this.cache = new Boolean[this.widthX()][this.heightY()][this.lengthZ()];
   }

   public void reset() {
      for(int var1 = 0; var1 < this.cache.length; ++var1) {
         for(int var2 = 0; var2 < this.cache[0].length; ++var2) {
            for(int var3 = 0; var3 < this.cache[0][0].length; ++var3) {
               this.cache[var1][var2][var3] = null;
            }
         }
      }

   }

   protected boolean partOfMask(int var1, int var2, int var3, ebq var4) {
      if(this.cache[var1][var2][var3] == null) {
         this.cache[var1][var2][var3] = Boolean.valueOf(this.filter.has(var4));
      }

      return this.cache[var1][var2][var3].booleanValue();
   }
}
