package baritone.api.schematic;

import baritone.api.schematic.ISchematic;
import java.util.List;
import java.util.stream.Collectors;

public class MirroredSchematic implements ISchematic {

   private final ISchematic schematic;
   private final dsr mirror;


   public MirroredSchematic(ISchematic var1, dsr var2) {
      this.schematic = var1;
      this.mirror = var2;
   }

   public boolean inSchematic(int var1, int var2, int var3, ebq var4) {
      return this.schematic.inSchematic(mirrorX(var1, this.widthX(), this.mirror), var2, mirrorZ(var3, this.lengthZ(), this.mirror), mirror((ebq)var4, this.mirror));
   }

   public ebq desiredState(int var1, int var2, int var3, ebq var4, List var5) {
      return mirror((ebq)this.schematic.desiredState(mirrorX(var1, this.widthX(), this.mirror), var2, mirrorZ(var3, this.lengthZ(), this.mirror), mirror((ebq)var4, this.mirror), mirror((List)var5, this.mirror)), this.mirror);
   }

   public void reset() {
      this.schematic.reset();
   }

   public int widthX() {
      return this.schematic.widthX();
   }

   public int heightY() {
      return this.schematic.heightY();
   }

   public int lengthZ() {
      return this.schematic.lengthZ();
   }

   private static int mirrorX(int var0, int var1, dsr var2) {
      switch(null.$SwitchMap$net$minecraft$world$level$block$Mirror[var2.ordinal()]) {
      case 1:
      case 2:
         return var0;
      case 3:
         return var1 - var0 - 1;
      default:
         throw new IllegalArgumentException("Unknown mirror");
      }
   }

   private static int mirrorZ(int var0, int var1, dsr var2) {
      switch(null.$SwitchMap$net$minecraft$world$level$block$Mirror[var2.ordinal()]) {
      case 1:
      case 3:
         return var0;
      case 2:
         return var1 - var0 - 1;
      default:
         throw new IllegalArgumentException("Unknown mirror");
      }
   }

   private static ebq mirror(ebq var0, dsr var1) {
      return var0 == null?null:var0.a(var1);
   }

   private static List mirror(List var0, dsr var1) {
      return var0 == null?null:(List)var0.stream().map(var1).collect(Collectors.toList());
   }

   // $FF: synthetic method
   private static ebq lambda$mirror$0(dsr var0, ebq var1) {
      return mirror((ebq)var1, var0);
   }
}
