package baritone.api.process;

import baritone.api.process.IBaritoneProcess;
import baritone.api.utils.BlockOptionalMeta;
import baritone.api.utils.BlockOptionalMetaLookup;

public interface IMineProcess extends IBaritoneProcess {

   void mineByName(int var1, String ... var2);

   void mine(int var1, BlockOptionalMetaLookup var2);

   default void mine(BlockOptionalMetaLookup var1) {
      this.mine(0, (BlockOptionalMetaLookup)var1);
   }

   default void mineByName(String ... var1) {
      this.mineByName(0, var1);
   }

   default void mine(int var1, BlockOptionalMeta ... var2) {
      this.mine(var1, (BlockOptionalMetaLookup)(new BlockOptionalMetaLookup(var2)));
   }

   default void mine(BlockOptionalMeta ... var1) {
      this.mine(0, (BlockOptionalMeta[])var1);
   }

   default void mine(int param1, dno ... param2) {
      // $FF: Couldn't be decompiled
   }

   default void mine(dno ... var1) {
      this.mine(0, (dno[])var1);
   }

   default void cancel() {
      this.onLostControl();
   }

   // $FF: synthetic method
   private static default BlockOptionalMeta[] lambda$mine$0(int var0) {
      return new BlockOptionalMeta[var0];
   }
}
