package baritone.api.process;

import baritone.api.process.IBaritoneProcess;
import baritone.api.schematic.ISchematic;
import java.io.File;
import java.util.List;
import java.util.Optional;

public interface IBuilderProcess extends IBaritoneProcess {

   void build(String var1, ISchematic var2, kb var3);

   boolean build(String var1, File var2, kb var3);

   @Deprecated
   default boolean build(String var1, iw var2) {
      File var3 = new File(new File(fqq.Q().q, "schematics"), var1);
      return this.build(var1, (File)var3, var2);
   }

   void buildOpenSchematic();

   void buildOpenLitematic(int var1);

   void pause();

   boolean isPaused();

   void resume();

   void clearArea(iw var1, iw var2);

   List getApproxPlaceable();

   Optional getMinLayer();

   Optional getMaxLayer();
}
