package baritone.api.pathing.movement;


public interface ActionCosts {

   double WALK_ONE_BLOCK_COST = 4.63284688441047D;
   double WALK_ONE_IN_WATER_COST = 9.09090909090909D;
   double WALK_ONE_OVER_SOUL_SAND_COST = 9.26569376882094D;
   double LADDER_UP_ONE_COST = 8.51063829787234D;
   double LADDER_DOWN_ONE_COST = 6.666666666666667D;
   double SNEAK_ONE_BLOCK_COST = 15.384615384615383D;
   double SPRINT_ONE_BLOCK_COST = 3.563791874554526D;
   double SPRINT_MULTIPLIER = 0.7692444761225944D;
   double WALK_OFF_BLOCK_COST = 3.7062775075283763D;
   double CENTER_AFTER_FALL_COST = 0.9265693768820937D;
   double COST_INF = 1000000.0D;
   double[] FALL_N_BLOCKS_COST = generateFallNBlocksCost();
   double FALL_1_25_BLOCKS_COST = distanceToTicks(1.25D);
   double FALL_0_25_BLOCKS_COST = distanceToTicks(0.25D);
   double JUMP_ONE_BLOCK_COST = FALL_1_25_BLOCKS_COST - FALL_0_25_BLOCKS_COST;


   static default double[] generateFallNBlocksCost() {
      double[] var0 = new double[4097];

      for(int var1 = 0; var1 < 4097; ++var1) {
         var0[var1] = distanceToTicks((double)var1);
      }

      return var0;
   }

   static default double velocity(int var0) {
      return (Math.pow(0.98D, (double)var0) - 1.0D) * -3.92D;
   }

   static default double oldFormula(double var0) {
      return -3.92D * (99.0D - 49.5D * (Math.pow(0.98D, var0) + 1.0D) - var0);
   }

   static default double distanceToTicks(double var0) {
      if(var0 == 0.0D) {
         return 0.0D;
      } else {
         double var2 = var0;
         int var6 = 0;

         while(true) {
            double var4 = velocity(var6);
            if(var2 <= var4) {
               return (double)var6 + var2 / var4;
            }

            var2 -= var4;
            ++var6;
         }
      }
   }

}
