package baritone.api.pathing.goals;

import baritone.api.pathing.goals.Goal;
import baritone.api.pathing.goals.GoalXZ;
import baritone.api.pathing.goals.GoalYLevel;
import baritone.api.utils.SettingsUtil;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import java.util.Arrays;
import java.util.Objects;

public class GoalRunAway implements Goal {

   private final iw[] from;
   private final int distanceSq;
   private final Integer maintainY;


   public GoalRunAway(double var1, iw ... var3) {
      this(var1, (Integer)null, var3);
   }

   public GoalRunAway(double var1, Integer var3, iw ... var4) {
      if(var4.length == 0) {
         throw new IllegalArgumentException("Positions to run away from must not be empty");
      } else {
         this.from = var4;
         this.distanceSq = (int)(var1 * var1);
         this.maintainY = var3;
      }
   }

   public boolean isInGoal(int var1, int var2, int var3) {
      if(this.maintainY != null && this.maintainY.intValue() != var2) {
         return false;
      } else {
         iw[] var8 = this.from;
         int var4 = this.from.length;

         for(int var5 = 0; var5 < var4; ++var5) {
            iw var6 = var8[var5];
            int var7 = var1 - var6.u();
            int var9 = var3 - var6.w();
            if(var7 * var7 + var9 * var9 < this.distanceSq) {
               return false;
            }
         }

         return true;
      }
   }

   public double heuristic(int var1, int var2, int var3) {
      double var4 = Double.MAX_VALUE;
      iw[] var6 = this.from;
      int var7 = this.from.length;

      for(int var8 = 0; var8 < var7; ++var8) {
         iw var9;
         double var10;
         if((var10 = GoalXZ.calculate((double)((var9 = var6[var8]).u() - var1), (double)(var9.w() - var3))) < var4) {
            var4 = var10;
         }
      }

      var4 = -var4;
      if(this.maintainY != null) {
         var4 = var4 * 0.6D + GoalYLevel.calculate(this.maintainY.intValue(), var2) * 1.5D;
      }

      return var4;
   }

   public double heuristic() {
      int var1 = (int)Math.ceil(Math.sqrt((double)this.distanceSq));
      int var2 = Integer.MAX_VALUE;
      int var3 = Integer.MAX_VALUE;
      int var4 = Integer.MAX_VALUE;
      int var5 = Integer.MIN_VALUE;
      int var6 = Integer.MIN_VALUE;
      int var7 = Integer.MIN_VALUE;
      iw[] var8 = this.from;
      int var9 = this.from.length;

      for(int var10 = 0; var10 < var9; ++var10) {
         iw var11 = var8[var10];
         var2 = Math.min(var2, var11.u() - var1);
         var3 = Math.min(var3, var11.v() - var1);
         var4 = Math.min(var4, var11.w() - var1);
         var5 = Math.max(var2, var11.u() + var1);
         var6 = Math.max(var3, var11.v() + var1);
         var7 = Math.max(var4, var11.w() + var1);
      }

      DoubleOpenHashSet var16 = new DoubleOpenHashSet();
      double var17 = Double.POSITIVE_INFINITY;

      double var13;
      for(int var18 = var2; var18 <= var5; ++var18) {
         for(int var12 = var3; var12 <= var6; ++var12) {
            for(var1 = var4; var1 <= var7; ++var1) {
               if((var13 = this.heuristic(var18, var12, var1)) < var17 && this.isInGoal(var18, var12, var1)) {
                  var16.add(var13);
               } else {
                  var17 = Math.min(var17, var13);
               }
            }
         }
      }

      double var19 = Double.NEGATIVE_INFINITY;
      DoubleIterator var15 = var16.iterator();

      while(var15.hasNext()) {
         if((var13 = var15.nextDouble()) < var17) {
            var19 = Math.max(var19, var13);
         }
      }

      return var19;
   }

   public boolean equals(Object var1) {
      if(this == var1) {
         return true;
      } else if(var1 != null && this.getClass() == var1.getClass()) {
         GoalRunAway var2 = (GoalRunAway)var1;
         return this.distanceSq == var2.distanceSq && Arrays.equals(this.from, var2.from) && Objects.equals(this.maintainY, var2.maintainY);
      } else {
         return false;
      }
   }

   public int hashCode() {
      return (Arrays.hashCode(this.from) * 1196803141 + this.distanceSq) * -2053788840 + this.maintainY.intValue();
   }

   public String toString() {
      return this.maintainY != null?String.format("GoalRunAwayFromMaintainY y=%s, %s", new Object[]{SettingsUtil.maybeCensor(this.maintainY.intValue()), Arrays.asList(this.from)}):String.valueOf(Arrays.asList(this.from));
   }
}
