package baritone.api.pathing.goals;

import baritone.api.pathing.goals.Goal;
import baritone.api.pathing.goals.GoalBlock;
import baritone.api.utils.BetterBlockPos;
import baritone.api.utils.SettingsUtil;
import baritone.api.utils.interfaces.IGoalRenderPos;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;

public class GoalNear implements Goal, IGoalRenderPos {

   private final int x;
   private final int y;
   private final int z;
   private final int rangeSq;


   public GoalNear(iw var1, int var2) {
      this.x = var1.u();
      this.y = var1.v();
      this.z = var1.w();
      this.rangeSq = var2 * var2;
   }

   public boolean isInGoal(int var1, int var2, int var3) {
      var1 -= this.x;
      var2 -= this.y;
      var3 -= this.z;
      return var1 * var1 + var2 * var2 + var3 * var3 <= this.rangeSq;
   }

   public double heuristic(int var1, int var2, int var3) {
      var1 -= this.x;
      var2 -= this.y;
      var3 -= this.z;
      return GoalBlock.calculate((double)var1, var2, (double)var3);
   }

   public double heuristic() {
      int var1 = (int)Math.ceil(Math.sqrt((double)this.rangeSq));
      DoubleOpenHashSet var2 = new DoubleOpenHashSet();
      double var3 = Double.POSITIVE_INFINITY;

      double var8;
      for(int var5 = -var1; var5 <= var1; ++var5) {
         for(int var6 = -var1; var6 <= var1; ++var6) {
            for(int var7 = -var1; var7 <= var1; ++var7) {
               if((var8 = this.heuristic(this.x + var5, this.y + var6, this.z + var7)) < var3 && this.isInGoal(this.x + var5, this.y + var6, this.z + var7)) {
                  var2.add(var8);
               } else {
                  var3 = Math.min(var3, var8);
               }
            }
         }
      }

      double var10 = Double.NEGATIVE_INFINITY;
      DoubleIterator var11 = var2.iterator();

      while(var11.hasNext()) {
         if((var8 = var11.nextDouble()) < var3) {
            var10 = Math.max(var10, var8);
         }
      }

      return var10;
   }

   public iw getGoalPos() {
      return new iw(this.x, this.y, this.z);
   }

   public boolean equals(Object var1) {
      if(this == var1) {
         return true;
      } else if(var1 != null && this.getClass() == var1.getClass()) {
         GoalNear var2 = (GoalNear)var1;
         return this.x == var2.x && this.y == var2.y && this.z == var2.z && this.rangeSq == var2.rangeSq;
      } else {
         return false;
      }
   }

   public int hashCode() {
      return (int)BetterBlockPos.longHash(this.x, this.y, this.z) + this.rangeSq;
   }

   public String toString() {
      return String.format("GoalNear{x=%s, y=%s, z=%s, rangeSq=%d}", new Object[]{SettingsUtil.maybeCensor(this.x), SettingsUtil.maybeCensor(this.y), SettingsUtil.maybeCensor(this.z), Integer.valueOf(this.rangeSq)});
   }
}
