package baritone.api.event.events;

import org.joml.Matrix4f;

public final class RenderEvent {

   private final float partialTicks;
   private final Matrix4f projectionMatrix;
   private final fld modelViewStack;


   public RenderEvent(float var1, fld var2, Matrix4f var3) {
      this.partialTicks = var1;
      this.modelViewStack = var2;
      this.projectionMatrix = var3;
   }

   public final float getPartialTicks() {
      return this.partialTicks;
   }

   public final fld getModelViewStack() {
      return this.modelViewStack;
   }

   public final Matrix4f getProjectionMatrix() {
      return this.projectionMatrix;
   }
}
