package baritone.api.command.registry;

import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Registry {

   private final Deque _entries = new LinkedList();
   private final Set registered = new HashSet();
   public final Collection entries;


   public Registry() {
      this.entries = Collections.unmodifiableCollection(this._entries);
   }

   public boolean registered(Object var1) {
      return this.registered.contains(var1);
   }

   public boolean register(Object var1) {
      if(!this.registered(var1)) {
         this._entries.addFirst(var1);
         this.registered.add(var1);
         return true;
      } else {
         return false;
      }
   }

   public void unregister(Object var1) {
      if(this.registered(var1)) {
         this._entries.remove(var1);
         this.registered.remove(var1);
      }
   }

   public Iterator iterator() {
      return this._entries.iterator();
   }

   public Iterator descendingIterator() {
      return this._entries.descendingIterator();
   }

   public Stream stream() {
      return this._entries.stream();
   }

   public Stream descendingStream() {
      return StreamSupport.stream(Spliterators.spliterator(this.descendingIterator(), (long)this._entries.size(), 16448), false);
   }
}
