package baritone.api.command.helpers;

import baritone.api.command.argument.IArgConsumer;
import baritone.api.command.exception.CommandInvalidTypeException;
import baritone.api.utils.Helper;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import xe.f;
import xm.e;

public class Paginator implements Helper {

   public final List entries;
   public int pageSize = 8;
   public int page = 1;


   public Paginator(List var1) {
      this.entries = var1;
   }

   public Paginator(Object ... var1) {
      this.entries = Arrays.asList(var1);
   }

   public Paginator setPageSize(int var1) {
      this.pageSize = var1;
      return this;
   }

   public int getMaxPage() {
      return (this.entries.size() - 1) / this.pageSize + 1;
   }

   public boolean validPage(int var1) {
      return var1 > 0 && var1 <= this.getMaxPage();
   }

   public Paginator skipPages(int var1) {
      this.page += var1;
      return this;
   }

   public void display(Function var1, String var2) {
      int var3;
      for(int var4 = var3 = (this.page - 1) * this.pageSize; var4 < var3 + this.pageSize; ++var4) {
         if(var4 < this.entries.size()) {
            this.logDirect(new xg[]{(xg)var1.apply(this.entries.get(var4))});
         } else {
            this.logDirect("--", o.i);
         }
      }

      boolean var8 = var2 != null && this.validPage(this.page - 1);
      boolean var5 = var2 != null && this.validPage(this.page + 1);
      xu var7 = xg.b("<<");
      if(var8) {
         var7.b(var7.a().a(new f(String.format("%s %d", new Object[]{var2, Integer.valueOf(this.page - 1)}))).a(new e(xg.b("Click to view previous page"))));
      } else {
         var7.b(var7.a().a(o.i));
      }

      xu var9 = xg.b(">>");
      if(var5) {
         var9.b(var9.a().a(new f(String.format("%s %d", new Object[]{var2, Integer.valueOf(this.page + 1)}))).a(new e(xg.b("Click to view next page"))));
      } else {
         var9.b(var9.a().a(o.i));
      }

      xu var6;
      xu var10000 = var6 = xg.b("");
      var10000.b(var10000.a().a(o.h));
      var6.b(var7);
      var6.f(" | ");
      var6.b(var9);
      var6.f(String.format(" %d/%d", new Object[]{Integer.valueOf(this.page), Integer.valueOf(this.getMaxPage())}));
      this.logDirect(new xg[]{var6});
   }

   public void display(Function var1) {
      this.display(var1, (String)null);
   }

   public static void paginate(IArgConsumer var0, Paginator var1, Runnable var2, Function var3, String var4) {
      int var5 = 1;
      var0.requireMax(1);
      if(var0.hasAny()) {
         var5 = ((Integer)var0.getAs(Integer.class)).intValue();
         if(!var1.validPage(var5)) {
            throw new CommandInvalidTypeException(var0.consumed(), String.format("a valid page (1-%d)", new Object[]{Integer.valueOf(var1.getMaxPage())}), var0.consumed().getValue());
         }
      }

      var1.skipPages(var5 - var1.page);
      if(var2 != null) {
         var2.run();
      }

      var1.display(var3, var4);
   }

   public static void paginate(IArgConsumer var0, List var1, Runnable var2, Function var3, String var4) {
      paginate(var0, (Paginator)(new Paginator(var1)), var2, var3, var4);
   }

   public static void paginate(IArgConsumer var0, Object[] var1, Runnable var2, Function var3, String var4) {
      paginate(var0, (List)Arrays.asList(var1), var2, var3, var4);
   }

   public static void paginate(IArgConsumer var0, Paginator var1, Function var2, String var3) {
      paginate(var0, (Paginator)var1, (Runnable)null, var2, var3);
   }

   public static void paginate(IArgConsumer var0, List var1, Function var2, String var3) {
      paginate(var0, (Paginator)(new Paginator(var1)), (Runnable)null, var2, var3);
   }

   public static void paginate(IArgConsumer var0, Object[] var1, Function var2, String var3) {
      paginate(var0, (List)Arrays.asList(var1), (Runnable)null, var2, var3);
   }

   public static void paginate(IArgConsumer var0, Paginator var1, Runnable var2, Function var3) {
      paginate(var0, (Paginator)var1, var2, var3, (String)null);
   }

   public static void paginate(IArgConsumer var0, List var1, Runnable var2, Function var3) {
      paginate(var0, (Paginator)(new Paginator(var1)), var2, var3, (String)null);
   }

   public static void paginate(IArgConsumer var0, Object[] var1, Runnable var2, Function var3) {
      paginate(var0, (List)Arrays.asList(var1), var2, var3, (String)null);
   }

   public static void paginate(IArgConsumer var0, Paginator var1, Function var2) {
      paginate(var0, (Paginator)var1, (Runnable)null, var2, (String)null);
   }

   public static void paginate(IArgConsumer var0, List var1, Function var2) {
      paginate(var0, (Paginator)(new Paginator(var1)), (Runnable)null, var2, (String)null);
   }

   public static void paginate(IArgConsumer var0, Object[] var1, Function var2) {
      paginate(var0, (List)Arrays.asList(var1), (Runnable)null, var2, (String)null);
   }
}
