package baritone.api.command.datatypes;

import baritone.api.command.argument.IArgConsumer;
import baritone.api.command.datatypes.IDatatypeContext;
import baritone.api.command.datatypes.IDatatypePost;
import baritone.api.utils.Helper;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystems;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Stream;

public enum RelativeFile implements IDatatypePost {

   INSTANCE;
   // $FF: synthetic field
   private static final RelativeFile[] $VALUES = $values();


   public final File apply(IDatatypeContext var1, File var2) {
      if(var2 == null) {
         var2 = new File("./");
      }

      Path var4;
      try {
         var4 = FileSystems.getDefault().getPath(var1.getConsumer().getString(), new String[0]);
      } catch (InvalidPathException var3) {
         throw new IllegalArgumentException("invalid path");
      }

      return getCanonicalFileUnchecked(var2.toPath().resolve(var4).toFile());
   }

   public final Stream tabComplete(IDatatypeContext var1) {
      return Stream.empty();
   }

   private static File getCanonicalFileUnchecked(File var0) {
      try {
         return var0.getCanonicalFile();
      } catch (IOException var1) {
         throw new UncheckedIOException(var1);
      }
   }

   public static Stream tabComplete(IArgConsumer var0, File var1) {
      var1 = getCanonicalFileUnchecked(var1);
      String var5 = var0.getString();
      Path var2;
      Path var3 = (var2 = FileSystems.getDefault().getPath(var5, new String[0])).isAbsolute()?var2.getRoot():var1.toPath();
      boolean var4 = !var5.isEmpty() && !var5.endsWith(File.separator);
      var1 = var2.isAbsolute()?var2.toFile():new File(var1, var5);
      return Stream.of((File[])Objects.requireNonNull(getCanonicalFileUnchecked(var4?var1.getParentFile():var1).listFiles())).filter(var2.map(var3).filter(var5));
   }

   @Deprecated
   public static File gameDir() {
      return gameDir(Helper.mc);
   }

   public static File gameDir(fqq var0) {
      File var1;
      return (var1 = var0.q.getAbsoluteFile()).getName().equals(".")?var1.getParentFile():var1;
   }

   // $FF: synthetic method
   private static boolean lambda$tabComplete$2(String var0) {
      return !var0.contains(" ");
   }

   // $FF: synthetic method
   private static boolean lambda$tabComplete$1(String var0, String var1) {
      return var1.toLowerCase(Locale.US).startsWith(var0.toLowerCase(Locale.US));
   }

   // $FF: synthetic method
   private static String lambda$tabComplete$0(Path var0, Path var1, File var2) {
      String.valueOf(var0.isAbsolute()?var2:var1.relativize(var2.toPath()).toString());
      return var2.isDirectory()?File.separator:"";
   }

   // $FF: synthetic method
   private static RelativeFile[] $values() {
      return new RelativeFile[]{INSTANCE};
   }

}
