package baritone.api.command.datatypes;

import baritone.api.command.argument.IArgConsumer;
import baritone.api.command.datatypes.IDatatypeContext;
import baritone.api.command.datatypes.IDatatypePost;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public enum RelativeCoordinate implements IDatatypePost {

   INSTANCE;
   private static String ScalesAliasRegex = "[kKmM]";
   private static Pattern PATTERN = Pattern.compile("[kKmM]");
   // $FF: synthetic field
   private static final RelativeCoordinate[] $VALUES = $values();


   public final Double apply(IDatatypeContext var1, Double var2) {
      if(var2 == null) {
         var2 = Double.valueOf(0.0D);
      }

      Matcher var6;
      if(!(var6 = PATTERN.matcher(var1.getConsumer().getString())).matches()) {
         throw new IllegalArgumentException("pattern doesn\'t match");
      } else {
         boolean var3 = !var6.group(1).isEmpty();
         double var4 = var6.group(2).isEmpty()?0.0D:Double.parseDouble(var6.group(2).replaceAll(ScalesAliasRegex, ""));
         if(var6.group(2).toLowerCase().contains("k")) {
            var4 *= 1000.0D;
         }

         if(var6.group(2).toLowerCase().contains("m")) {
            var4 *= 1000000.0D;
         }

         return var3?Double.valueOf(var2.doubleValue() + var4):Double.valueOf(var4);
      }
   }

   public final Stream tabComplete(IDatatypeContext var1) {
      IArgConsumer var2;
      return !(var2 = var1.getConsumer()).has(2) && var2.getString().matches("^(~|$)")?Stream.of("~"):Stream.empty();
   }

   // $FF: synthetic method
   private static RelativeCoordinate[] $values() {
      return new RelativeCoordinate[]{INSTANCE};
   }

}
