package baritone.api.command.argument;

import baritone.api.command.argument.ICommandArgument;
import baritone.api.command.datatypes.IDatatype;
import baritone.api.command.datatypes.IDatatypeFor;
import baritone.api.command.datatypes.IDatatypePost;
import java.util.Deque;
import java.util.LinkedList;
import java.util.stream.Stream;

public interface IArgConsumer {

   LinkedList getArgs();

   Deque getConsumed();

   boolean has(int var1);

   boolean hasAny();

   boolean hasAtMost(int var1);

   boolean hasAtMostOne();

   boolean hasExactly(int var1);

   boolean hasExactlyOne();

   ICommandArgument peek(int var1);

   ICommandArgument peek();

   boolean is(Class var1, int var2);

   boolean is(Class var1);

   String peekString(int var1);

   String peekString();

   Enum peekEnum(Class var1, int var2);

   Enum peekEnum(Class var1);

   Enum peekEnumOrNull(Class var1, int var2);

   Enum peekEnumOrNull(Class var1);

   Object peekAs(Class var1, int var2);

   Object peekAs(Class var1);

   Object peekAsOrDefault(Class var1, Object var2, int var3);

   Object peekAsOrDefault(Class var1, Object var2);

   Object peekAsOrNull(Class var1, int var2);

   Object peekAsOrNull(Class var1);

   Object peekDatatype(IDatatypeFor var1);

   Object peekDatatype(IDatatypePost var1);

   Object peekDatatype(IDatatypePost var1, Object var2);

   Object peekDatatypeOrNull(IDatatypeFor var1);

   Object peekDatatypeOrNull(IDatatypePost var1);

   Object peekDatatypePost(IDatatypePost var1, Object var2);

   Object peekDatatypePostOrDefault(IDatatypePost var1, Object var2, Object var3);

   Object peekDatatypePostOrNull(IDatatypePost var1, Object var2);

   Object peekDatatypeFor(Class var1);

   Object peekDatatypeForOrDefault(Class var1, Object var2);

   Object peekDatatypeForOrNull(Class var1);

   ICommandArgument get();

   String getString();

   Enum getEnum(Class var1);

   Enum getEnumOrDefault(Class var1, Enum var2);

   Enum getEnumOrNull(Class var1);

   Object getAs(Class var1);

   Object getAsOrDefault(Class var1, Object var2);

   Object getAsOrNull(Class var1);

   Object getDatatypePost(IDatatypePost var1, Object var2);

   Object getDatatypePostOrDefault(IDatatypePost var1, Object var2, Object var3);

   Object getDatatypePostOrNull(IDatatypePost var1, Object var2);

   Object getDatatypeFor(IDatatypeFor var1);

   Object getDatatypeForOrDefault(IDatatypeFor var1, Object var2);

   Object getDatatypeForOrNull(IDatatypeFor var1);

   Stream tabCompleteDatatype(IDatatype var1);

   String rawRest();

   void requireMin(int var1);

   void requireMax(int var1);

   void requireExactly(int var1);

   boolean hasConsumed();

   ICommandArgument consumed();

   String consumedString();

   IArgConsumer copy();
}
