package baritone.api.cache;

import baritone.api.cache.IWaypoint;
import baritone.api.utils.BetterBlockPos;
import java.util.Date;

public class Waypoint implements IWaypoint {

   private final String name;
   private final IWaypoint.Tag tag;
   private final long creationTimestamp;
   private final BetterBlockPos location;


   public Waypoint(String var1, IWaypoint.Tag var2, BetterBlockPos var3) {
      this(var1, var2, var3, System.currentTimeMillis());
   }

   public Waypoint(String var1, IWaypoint.Tag var2, BetterBlockPos var3, long var4) {
      this.name = var1;
      this.tag = var2;
      this.location = var3;
      this.creationTimestamp = var4;
   }

   public int hashCode() {
      return this.name.hashCode() ^ this.tag.hashCode() ^ this.location.hashCode() ^ Long.hashCode(this.creationTimestamp);
   }

   public String getName() {
      return this.name;
   }

   public IWaypoint.Tag getTag() {
      return this.tag;
   }

   public long getCreationTimestamp() {
      return this.creationTimestamp;
   }

   public BetterBlockPos getLocation() {
      return this.location;
   }

   public String toString() {
      return String.format("%s %s %s", new Object[]{this.name, BetterBlockPos.from(this.location).toString(), (new Date(this.creationTimestamp)).toString()});
   }

   public boolean equals(Object var1) {
      if(var1 == null) {
         return false;
      } else if(!(var1 instanceof IWaypoint)) {
         return false;
      } else {
         IWaypoint var2 = (IWaypoint)var1;
         return this.name.equals(var2.getName()) && this.tag == var2.getTag() && this.location.equals(var2.getLocation());
      }
   }
}
