package baritone.api.behavior;

import baritone.api.behavior.IBehavior;
import baritone.api.pathing.goals.Goal;
import baritone.api.pathing.path.IPathExecutor;
import java.util.Optional;

public interface IPathingBehavior extends IBehavior {

   default Optional ticksRemainingInSegment() {
      return this.ticksRemainingInSegment(true);
   }

   default Optional ticksRemainingInSegment(boolean var1) {
      IPathExecutor var2;
      if((var2 = this.getCurrent()) == null) {
         return Optional.empty();
      } else {
         int var3 = var1?var2.getPosition():var2.getPosition() + 1;
         return Optional.of(Double.valueOf(var2.getPath().ticksRemainingFrom(var3)));
      }
   }

   Optional estimatedTicksToGoal();

   Goal getGoal();

   boolean isPathing();

   default boolean hasPath() {
      return this.getCurrent() != null;
   }

   boolean cancelEverything();

   void forceCancel();

   default Optional getPath() {
      // $FF: Couldn't be decompiled
   }

   Optional getInProgress();

   IPathExecutor getCurrent();

   IPathExecutor getNext();
}
