package baritone.api;

import baritone.api.utils.Helper;
import baritone.api.utils.SettingsUtil;
import baritone.api.utils.TypeUtils;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Settings {

   private static final Logger LOGGER = LoggerFactory.getLogger("Baritone");
   public final Settings.Setting allowBreak;
   public final Settings.Setting allowBreakAnyway;
   public final Settings.Setting allowSprint;
   public final Settings.Setting allowPlace;
   public final Settings.Setting allowPlaceInFluidsSource;
   public final Settings.Setting allowPlaceInFluidsFlow;
   public final Settings.Setting allowInventory;
   public final Settings.Setting ticksBetweenInventoryMoves;
   public final Settings.Setting inventoryMoveOnlyIfStationary;
   public final Settings.Setting assumeExternalAutoTool;
   public final Settings.Setting autoTool;
   public final Settings.Setting blockPlacementPenalty;
   public final Settings.Setting blockBreakAdditionalPenalty;
   public final Settings.Setting jumpPenalty;
   public final Settings.Setting walkOnWaterOnePenalty;
   public final Settings.Setting strictLiquidCheck;
   public final Settings.Setting allowWaterBucketFall;
   public final Settings.Setting assumeWalkOnWater;
   public final Settings.Setting assumeWalkOnLava;
   public final Settings.Setting assumeStep;
   public final Settings.Setting assumeSafeWalk;
   public final Settings.Setting allowJumpAtBuildLimit;
   @Deprecated
   @Settings.JavaOnly
   public final Settings.Setting allowJumpAt256;
   public final Settings.Setting allowParkourAscend;
   public final Settings.Setting allowDiagonalDescend;
   public final Settings.Setting allowDiagonalAscend;
   public final Settings.Setting allowDownward;
   public final Settings.Setting acceptableThrowawayItems;
   public final Settings.Setting blocksToAvoid;
   public final Settings.Setting blocksToDisallowBreaking;
   public final Settings.Setting blocksToAvoidBreaking;
   public final Settings.Setting avoidBreakingMultiplier;
   public final Settings.Setting buildIgnoreBlocks;
   public final Settings.Setting buildSkipBlocks;
   public final Settings.Setting buildValidSubstitutes;
   public final Settings.Setting buildSubstitutes;
   public final Settings.Setting okIfAir;
   public final Settings.Setting buildIgnoreExisting;
   public final Settings.Setting buildIgnoreDirection;
   public final Settings.Setting buildIgnoreProperties;
   public final Settings.Setting avoidUpdatingFallingBlocks;
   public final Settings.Setting allowVines;
   public final Settings.Setting allowWalkOnBottomSlab;
   public final Settings.Setting allowParkour;
   public final Settings.Setting allowParkourPlace;
   public final Settings.Setting considerPotionEffects;
   public final Settings.Setting sprintAscends;
   public final Settings.Setting overshootTraverse;
   public final Settings.Setting pauseMiningForFallingBlocks;
   public final Settings.Setting rightClickSpeed;
   public final Settings.Setting randomLooking113;
   public final Settings.Setting blockReachDistance;
   public final Settings.Setting blockBreakSpeed;
   public final Settings.Setting randomLooking;
   public final Settings.Setting costHeuristic;
   public final Settings.Setting pathingMaxChunkBorderFetch;
   public final Settings.Setting backtrackCostFavoringCoefficient;
   public final Settings.Setting avoidance;
   public final Settings.Setting mobSpawnerAvoidanceCoefficient;
   public final Settings.Setting mobSpawnerAvoidanceRadius;
   public final Settings.Setting mobAvoidanceCoefficient;
   public final Settings.Setting mobAvoidanceRadius;
   public final Settings.Setting rightClickContainerOnArrival;
   public final Settings.Setting enterPortal;
   public final Settings.Setting minimumImprovementRepropagation;
   public final Settings.Setting cutoffAtLoadBoundary;
   public final Settings.Setting maxCostIncrease;
   public final Settings.Setting costVerificationLookahead;
   public final Settings.Setting pathCutoffFactor;
   public final Settings.Setting pathCutoffMinimumLength;
   public final Settings.Setting planningTickLookahead;
   public final Settings.Setting pathingMapDefaultSize;
   public final Settings.Setting pathingMapLoadFactor;
   public final Settings.Setting maxFallHeightNoWater;
   public final Settings.Setting maxFallHeightBucket;
   public final Settings.Setting allowOvershootDiagonalDescend;
   public final Settings.Setting simplifyUnloadedYCoord;
   public final Settings.Setting repackOnAnyBlockChange;
   public final Settings.Setting movementTimeoutTicks;
   public final Settings.Setting primaryTimeoutMS;
   public final Settings.Setting failureTimeoutMS;
   public final Settings.Setting planAheadPrimaryTimeoutMS;
   public final Settings.Setting planAheadFailureTimeoutMS;
   public final Settings.Setting slowPath;
   public final Settings.Setting slowPathTimeDelayMS;
   public final Settings.Setting slowPathTimeoutMS;
   public final Settings.Setting doBedWaypoints;
   public final Settings.Setting doDeathWaypoints;
   public final Settings.Setting chunkCaching;
   public final Settings.Setting pruneRegionsFromRAM;
   public final Settings.Setting chunkPackerQueueMaxSize;
   public final Settings.Setting backfill;
   public final Settings.Setting logAsToast;
   public final Settings.Setting chatDebug;
   public final Settings.Setting chatControl;
   public final Settings.Setting chatControlAnyway;
   public final Settings.Setting renderPath;
   public final Settings.Setting renderPathAsLine;
   public final Settings.Setting renderGoal;
   public final Settings.Setting renderGoalAnimated;
   public final Settings.Setting renderSelectionBoxes;
   public final Settings.Setting renderGoalIgnoreDepth;
   public final Settings.Setting renderGoalXZBeacon;
   public final Settings.Setting renderSelectionBoxesIgnoreDepth;
   public final Settings.Setting renderPathIgnoreDepth;
   public final Settings.Setting pathRenderLineWidthPixels;
   public final Settings.Setting goalRenderLineWidthPixels;
   public final Settings.Setting fadePath;
   public final Settings.Setting freeLook;
   public final Settings.Setting blockFreeLook;
   public final Settings.Setting elytraFreeLook;
   public final Settings.Setting smoothLook;
   public final Settings.Setting elytraSmoothLook;
   public final Settings.Setting smoothLookTicks;
   public final Settings.Setting remainWithExistingLookDirection;
   public final Settings.Setting antiCheatCompatibility;
   public final Settings.Setting pathThroughCachedOnly;
   public final Settings.Setting sprintInWater;
   public final Settings.Setting blacklistClosestOnFailure;
   public final Settings.Setting renderCachedChunks;
   public final Settings.Setting cachedChunksOpacity;
   public final Settings.Setting prefixControl;
   public final Settings.Setting prefix;
   public final Settings.Setting shortBaritonePrefix;
   public final Settings.Setting useMessageTag;
   public final Settings.Setting echoCommands;
   public final Settings.Setting censorCoordinates;
   public final Settings.Setting censorRanCommands;
   public final Settings.Setting itemSaver;
   public final Settings.Setting itemSaverThreshold;
   public final Settings.Setting preferSilkTouch;
   public final Settings.Setting walkWhileBreaking;
   public final Settings.Setting splicePath;
   public final Settings.Setting maxPathHistoryLength;
   public final Settings.Setting pathHistoryCutoffAmount;
   public final Settings.Setting mineGoalUpdateInterval;
   public final Settings.Setting maxCachedWorldScanCount;
   public final Settings.Setting mineMaxOreLocationsCount;
   public final Settings.Setting minYLevelWhileMining;
   public final Settings.Setting maxYLevelWhileMining;
   public final Settings.Setting allowOnlyExposedOres;
   public final Settings.Setting allowOnlyExposedOresDistance;
   public final Settings.Setting exploreForBlocks;
   public final Settings.Setting worldExploringChunkOffset;
   public final Settings.Setting exploreChunkSetMinimumSize;
   public final Settings.Setting exploreMaintainY;
   public final Settings.Setting replantCrops;
   public final Settings.Setting replantNetherWart;
   public final Settings.Setting farmMaxScanSize;
   public final Settings.Setting extendCacheOnThreshold;
   public final Settings.Setting buildInLayers;
   public final Settings.Setting layerOrder;
   public final Settings.Setting layerHeight;
   public final Settings.Setting startAtLayer;
   public final Settings.Setting skipFailedLayers;
   public final Settings.Setting buildOnlySelection;
   public final Settings.Setting buildRepeat;
   public final Settings.Setting buildRepeatCount;
   public final Settings.Setting buildRepeatSneaky;
   public final Settings.Setting breakFromAbove;
   public final Settings.Setting goalBreakFromAbove;
   public final Settings.Setting mapArtMode;
   public final Settings.Setting okIfWater;
   public final Settings.Setting incorrectSize;
   public final Settings.Setting breakCorrectBlockPenaltyMultiplier;
   public final Settings.Setting placeIncorrectBlockPenaltyMultiplier;
   public final Settings.Setting schematicOrientationX;
   public final Settings.Setting schematicOrientationY;
   public final Settings.Setting schematicOrientationZ;
   public final Settings.Setting buildSchematicRotation;
   public final Settings.Setting buildSchematicMirror;
   public final Settings.Setting schematicFallbackExtension;
   public final Settings.Setting builderTickScanRadius;
   public final Settings.Setting mineScanDroppedItems;
   public final Settings.Setting mineDropLoiterDurationMSThanksLouca;
   public final Settings.Setting distanceTrim;
   public final Settings.Setting cancelOnGoalInvalidation;
   public final Settings.Setting axisHeight;
   public final Settings.Setting disconnectOnArrival;
   public final Settings.Setting legitMine;
   public final Settings.Setting legitMineYLevel;
   public final Settings.Setting legitMineIncludeDiagonals;
   public final Settings.Setting forceInternalMining;
   public final Settings.Setting internalMiningAirException;
   public final Settings.Setting followOffsetDistance;
   public final Settings.Setting followOffsetDirection;
   public final Settings.Setting followRadius;
   public final Settings.Setting followTargetMaxDistance;
   public final Settings.Setting disableCompletionCheck;
   public final Settings.Setting cachedChunksExpirySeconds;
   @Settings.JavaOnly
   public final Settings.Setting logger;
   @Settings.JavaOnly
   public final Settings.Setting notifier;
   @Settings.JavaOnly
   public final Settings.Setting toaster;
   public final Settings.Setting verboseCommandExceptions;
   public final Settings.Setting yLevelBoxSize;
   public final Settings.Setting colorCurrentPath;
   public final Settings.Setting colorNextPath;
   public final Settings.Setting colorBlocksToBreak;
   public final Settings.Setting colorBlocksToPlace;
   public final Settings.Setting colorBlocksToWalkInto;
   public final Settings.Setting colorBestPathSoFar;
   public final Settings.Setting colorMostRecentConsidered;
   public final Settings.Setting colorGoalBox;
   public final Settings.Setting colorInvertedGoalBox;
   public final Settings.Setting colorSelection;
   public final Settings.Setting colorSelectionPos1;
   public final Settings.Setting colorSelectionPos2;
   public final Settings.Setting selectionOpacity;
   public final Settings.Setting selectionLineWidth;
   public final Settings.Setting renderSelection;
   public final Settings.Setting renderSelectionIgnoreDepth;
   public final Settings.Setting renderSelectionCorners;
   public final Settings.Setting useSwordToMine;
   public final Settings.Setting desktopNotifications;
   public final Settings.Setting notificationOnPathComplete;
   public final Settings.Setting notificationOnFarmFail;
   public final Settings.Setting notificationOnBuildFinished;
   public final Settings.Setting notificationOnExploreFinished;
   public final Settings.Setting notificationOnMineFail;
   public final Settings.Setting elytraSimulationTicks;
   public final Settings.Setting elytraPitchRange;
   public final Settings.Setting elytraFireworkSpeed;
   public final Settings.Setting elytraFireworkSetbackUseDelay;
   public final Settings.Setting elytraMinimumAvoidance;
   public final Settings.Setting elytraConserveFireworks;
   public final Settings.Setting elytraRenderRaytraces;
   public final Settings.Setting elytraRenderHitboxRaytraces;
   public final Settings.Setting elytraRenderSimulation;
   public final Settings.Setting elytraAutoJump;
   public final Settings.Setting elytraNetherSeed;
   public final Settings.Setting elytraPredictTerrain;
   public final Settings.Setting elytraAutoSwap;
   public final Settings.Setting elytraMinimumDurability;
   public final Settings.Setting elytraMinFireworksBeforeLanding;
   public final Settings.Setting elytraAllowEmergencyLand;
   public final Settings.Setting elytraTimeBetweenCacheCullSecs;
   public final Settings.Setting elytraCacheCullDistance;
   public final Settings.Setting elytraAllowLandOnNetherFortress;
   public final Settings.Setting elytraTermsAccepted;
   public final Settings.Setting elytraChatSpam;
   public final Map byLowerName;
   public final List allSettings;
   public final Map settingTypes;


   Settings() {
      // $FF: Couldn't be decompiled
   }

   public final List getAllValuesByType(Class var1) {
      ArrayList var2 = new ArrayList();
      Iterator var3 = this.allSettings.iterator();

      while(var3.hasNext()) {
         Settings.Setting var4;
         if((var4 = (Settings.Setting)var3.next()).getValueClass().equals(var1)) {
            var2.add(var4);
         }
      }

      return var2;
   }

   // $FF: synthetic method
   private void lambda$new$0(xg var1) {
      try {
         fqk var2 = ((Boolean)this.useMessageTag.value).booleanValue()?Helper.MESSAGE_TAG:null;
         fqq.Q().m.d().a(var1, (xs)null, var2);
      } catch (Throwable var3) {
         LOGGER.warn(var1.getString(), var3);
      }
   }


   public final class Setting {

      public Object value;
      public final Object defaultValue;
      String name;
      boolean javaOnly;


      Setting(Object var2) {
         if(var2 == null) {
            throw new IllegalArgumentException("Cannot determine value type class from null");
         } else {
            this.value = var2;
            this.defaultValue = var2;
            this.javaOnly = false;
         }
      }

      @Deprecated
      public final Object get() {
         return this.value;
      }

      public final String getName() {
         return this.name;
      }

      public final Class getValueClass() {
         return TypeUtils.resolveBaseClass(this.getType());
      }

      public final String toString() {
         return SettingsUtil.settingToString(this);
      }

      public final void reset() {
         this.value = this.defaultValue;
      }

      public final Type getType() {
         return (Type)Settings.this.settingTypes.get(this);
      }

      public final boolean isJavaOnly() {
         return this.javaOnly;
      }
   }

   @Retention(RetentionPolicy.RUNTIME)
   @Target({ElementType.FIELD})
   private @interface JavaOnly {
   }
}
