package baritone.api;

import baritone.api.IBaritone;
import baritone.api.cache.IWorldScanner;
import baritone.api.command.ICommandSystem;
import baritone.api.schematic.ISchematicSystem;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public interface IBaritoneProvider {

   IBaritone getPrimaryBaritone();

   List getAllBaritones();

   default IBaritone getBaritoneForPlayer(gqm var1) {
      Iterator var2 = this.getAllBaritones().iterator();

      IBaritone var3;
      do {
         if(!var2.hasNext()) {
            return null;
         }

         var3 = (IBaritone)var2.next();
      } while(!Objects.equals(var1, var3.getPlayerContext().player()));

      return var3;
   }

   default IBaritone getBaritoneForMinecraft(fqq var1) {
      Iterator var2 = this.getAllBaritones().iterator();

      IBaritone var3;
      do {
         if(!var2.hasNext()) {
            return null;
         }

         var3 = (IBaritone)var2.next();
      } while(!Objects.equals(var1, var3.getPlayerContext().minecraft()));

      return var3;
   }

   default IBaritone getBaritoneForConnection(glp var1) {
      Iterator var2 = this.getAllBaritones().iterator();

      IBaritone var3;
      gqm var4;
      do {
         if(!var2.hasNext()) {
            return null;
         }
      } while((var4 = (var3 = (IBaritone)var2.next()).getPlayerContext().player()) == null || var4.j != var1);

      return var3;
   }

   IBaritone createBaritone(fqq var1);

   boolean destroyBaritone(IBaritone var1);

   IWorldScanner getWorldScanner();

   ICommandSystem getCommandSystem();

   ISchematicSystem getSchematicSystem();
}
