/*
 * Decompiled with CFR 0.152.
 */
package com.segi.uhomecp.app.core.utils;

import com.segi.uhomecp.app.core.constant.MQDelayLevelE;
import com.segi.uhomecp.rocketMQ.RocketMQUtils;
import com.segi.uhomecp.utils.UhomePropUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketMQExtUtils {
    private static String namesrvAddr;
    private static String producerGroup;
    private static volatile DefaultMQProducer producer;
    private static final String property;
    public static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static DefaultMQProducer init() {
        if (null != producer) return producer;
        Class<RocketMQExtUtils> clazz = RocketMQExtUtils.class;
        synchronized (RocketMQExtUtils.class) {
            if (null != producer) return producer;
            producer = new DefaultMQProducer(producerGroup);
            producer.setNamesrvAddr(namesrvAddr);
            producer.setVipChannelEnabled(false);
            producer.setRetryTimesWhenSendFailed(3);
            try {
                producer.start();
            }
            catch (Exception e) {
                LOGGER.error("MQ producer error:", (Throwable)e);
            }
            return producer;
        }
    }

    public static SendResult send(String topic, String tag, String content, String keys) throws Exception {
        producer = RocketMQExtUtils.init();
        SendResult sendResult = RocketMQExtUtils.call(topic, tag, content, keys, null);
        return sendResult;
    }

    public static SendResult delaySend(String topic, String tag, String content, String keys, MQDelayLevelE delayLevelE) throws Exception {
        producer = RocketMQExtUtils.init();
        SendResult sendResult = RocketMQExtUtils.call(topic, tag, content, keys, delayLevelE.getLevel());
        return sendResult;
    }

    private static SendResult call(String topic, String tag, String messageBody, String keys, Integer delayLevel) throws Exception {
        SendResult send = null;
        Message msg = new Message();
        try {
            msg.setTopic(topic);
            msg.setTags(tag);
            if (StringUtils.isNotBlank((CharSequence)property)) {
                msg.setTags(tag + "_" + property);
            }
            if (StringUtils.isNotBlank((CharSequence)keys)) {
                msg.setKeys(keys);
            }
            if (delayLevel != null && delayLevel > 0) {
                msg.setDelayTimeLevel(delayLevel.intValue());
            }
            msg.setBody(messageBody.getBytes("UTF-8"));
            send = producer.send(msg);
            LOGGER.info("=========>>MQ\u53d1\u9001({})\u6d88\u606f\u5b8c\u6210\uff0csendStatus:{}, msgId:{}", new Object[]{topic, send.getSendStatus(), send.getMsgId()});
        }
        catch (Exception e) {
            LOGGER.error("=========>>MQ\u53d1\u9001({})\u6d88\u606f\u5f02\u5e38", (Object)topic, (Object)e);
            throw e;
        }
        finally {
            return send;
        }
    }

    static {
        property = UhomePropUtils.getProperty((String)"rocketmq.platform");
        LOGGER = LoggerFactory.getLogger(RocketMQUtils.class);
        System.setProperty("rocketmq.client.logRoot", "/log/rocketmq");
        namesrvAddr = UhomePropUtils.getProperty((String)"rocketmq.namesrvAddr");
        producerGroup = UhomePropUtils.getProperty((String)"rocketmq.producer.group");
    }
}

