/*
 * Decompiled with CFR 0.152.
 */
package com.segi.uhomecp.app.core.utils;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class JPEGReader {
    public static BufferedImage read(File input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("input == null!");
        }
        if (!input.canRead()) {
            throw new IIOException("Can't read input file!");
        }
        ImageInputStream stream = ImageIO.createImageInputStream(input);
        if (stream == null) {
            throw new IIOException("Can't create an ImageInputStream!");
        }
        BufferedImage bi = JPEGReader.read(stream);
        if (bi == null) {
            stream.close();
        }
        return bi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage read(ImageInputStream stream) throws IOException {
        BufferedImage bi;
        if (stream == null) {
            throw new IllegalArgumentException("stream == null!");
        }
        Iterator<ImageReader> iter = ImageIO.getImageReaders(stream);
        if (!iter.hasNext()) {
            return null;
        }
        ImageReader reader = iter.next();
        ImageReadParam param = reader.getDefaultReadParam();
        reader.setInput(stream, true, true);
        try {
            bi = reader.read(0, param);
        }
        catch (IIOException e) {
            Raster raster = reader.readRaster(0, null);
            bi = JPEGReader.createJPEG4(raster);
        }
        finally {
            reader.dispose();
            stream.close();
        }
        return bi;
    }

    private static BufferedImage createJPEG4(Raster raster) {
        int w = raster.getWidth();
        int h = raster.getHeight();
        byte[] rgb = new byte[w * h * 3];
        float[] Y = raster.getSamples(0, 0, w, h, 0, (float[])null);
        float[] Cb = raster.getSamples(0, 0, w, h, 1, (float[])null);
        float[] Cr = raster.getSamples(0, 0, w, h, 2, (float[])null);
        float[] K = raster.getSamples(0, 0, w, h, 3, (float[])null);
        int i = 0;
        int imax = Y.length;
        int base = 0;
        while (i < imax) {
            float k = 220.0f - K[i];
            float y = 255.0f - Y[i];
            float cb = 255.0f - Cb[i];
            float cr = 255.0f - Cr[i];
            double val = (double)y + 1.402 * (double)(cr - 128.0f) - (double)k;
            rgb[base] = (byte)((val = (val - 128.0) * (double)0.65f + 128.0) < 0.0 ? 0 : (byte)(val > 255.0 ? -1 : (byte)(val + 0.5)));
            val = (double)y - 0.34414 * (double)(cb - 128.0f) - 0.71414 * (double)(cr - 128.0f) - (double)k;
            val = (val - 128.0) * (double)0.65f + 128.0;
            rgb[base + 1] = (byte)(val < 0.0 ? 0 : (byte)(val > 255.0 ? -1 : (byte)(val + 0.5)));
            val = (double)y + 1.772 * (double)(cb - 128.0f) - (double)k;
            val = (val - 128.0) * (double)0.65f + 128.0;
            rgb[base + 2] = (byte)(val < 0.0 ? 0 : (byte)(val > 255.0 ? -1 : (byte)(val + 0.5)));
            ++i;
            base += 3;
        }
        raster = Raster.createInterleavedRaster(new DataBufferByte(rgb, rgb.length), w, h, w * 3, 3, new int[]{0, 1, 2}, null);
        ColorSpace cs = ColorSpace.getInstance(1000);
        ComponentColorModel cm = new ComponentColorModel(cs, false, true, 1, 0);
        return new BufferedImage(cm, (WritableRaster)raster, true, null);
    }
}

