/*
 * Decompiled with CFR 0.152.
 */
package com.segi.uhomecp.app.core.utils;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import com.segi.uhomecp.app.core.constant.MQConstant;
import com.segi.uhomecp.app.core.constant.MQDelayLevelE;
import com.segi.uhomecp.app.core.dto.ImageAttr;
import com.segi.uhomecp.app.core.dto.UploadedFile;
import com.segi.uhomecp.app.core.exception.ServiceException;
import com.segi.uhomecp.app.core.utils.AsyncProcessTaskUtil;
import com.segi.uhomecp.app.core.utils.RocketMQExtUtils;
import com.segi.uhomecp.utils.JacksonUtil;
import com.segi.uhomecp.utils.UhomePropUtils;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class ImageUtilsV2 {
    public static final Logger logger = LoggerFactory.getLogger(ImageUtilsV2.class);
    public static String ACCESS_PREEFIX = UhomePropUtils.getProperty((String)"SOURCE_PATH");
    public static String UPLOAD_ROOT = UhomePropUtils.getProperty((String)"UPLOAD_PATH");
    public static String UPLOAD_PICTURE = UhomePropUtils.getProperty((String)"UPLOAD_PICTURE");
    public static String SAMLL_CATEGORY = UhomePropUtils.getProperty((String)"ACRONYM_PATH");
    public static String UPLOAD_IMAGE_EXTENSION = UhomePropUtils.getProperty((String)"upload.image.extension", (String)"jpg,jpeg,png,gif,webp,bmp");
    public static String UPLOAD_FILE_EXTENSION = UhomePropUtils.getProperty((String)"upload.file.extension", (String)"");
    public static String UPLOAD_FILE_FORBIDDEN_EXTENSION = UhomePropUtils.getProperty((String)"upload.file.forbidden.extension", (String)"");
    public static Set<String> IMAGE_EXTENSIONS_SETS = Sets.newHashSet(Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)StringUtils.lowerCase((String)UPLOAD_IMAGE_EXTENSION)).iterator());
    public static Set<String> FILE_EXTENSIONS_SETS = StringUtils.isBlank((CharSequence)UPLOAD_FILE_EXTENSION) ? Sets.newHashSet() : Sets.newHashSet(Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)StringUtils.lowerCase((String)UPLOAD_FILE_EXTENSION)).iterator());
    public static Set<String> FILE_EXTENSIONS_FORBIDDEN_SETS = StringUtils.isBlank((CharSequence)UPLOAD_FILE_FORBIDDEN_EXTENSION) ? Sets.newHashSet() : Sets.newHashSet(Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)StringUtils.lowerCase((String)UPLOAD_FILE_FORBIDDEN_EXTENSION)).iterator());
    public static final int IMAGE_MAX_WIDTH = 1080;
    public static final int IMAGE_MAX_HEIGHT = 1920;

    public static Boolean compressImage(ImageAttr imageAttr) {
        logger.debug("\u5f00\u59cb\u5904\u7406\u56fe\u7247\u538b\u7f29\uff1a{}", (Object)JacksonUtil.objectToJackson((Object)imageAttr));
        try {
            ImageUtilsV2.compressSrcImage(imageAttr.getFilePath(), imageAttr.getTargetWidth(), imageAttr.getTargetHeight());
            ImageAttr thumbnailImageAttr = ImageUtilsV2.resizeThumbnailImage(imageAttr.getTargetHeight(), imageAttr.getTargetHeight(), 300, 300);
            ImageUtilsV2.compressThumbnailsImage(imageAttr.getThumbnailsPath(), thumbnailImageAttr.getTargetWidth(), thumbnailImageAttr.getTargetHeight());
        }
        catch (Exception e) {
            logger.error("================\u56fe\u7247\u538b\u7f29\u5904\u7406\u5f02\u5e38================", (Throwable)e);
            return false;
        }
        logger.debug("================\u5904\u7406\u56fe\u7247\u538b\u7f29\u5b8c\u6210==================");
        return true;
    }

    public static UploadedFile uploadFileByFile(String fileName, MultipartFile file) {
        long size = file == null ? 0L : file.getSize();
        UploadedFile uploadedFile = new UploadedFile(fileName, size);
        if (file == null || file.isEmpty() || size == 0L) {
            return uploadedFile;
        }
        if (size > 61644800L) {
            uploadedFile.setError("\u8d85\u8fc7\u6587\u4ef6\u6700\u5927\u9650\u5236");
            return uploadedFile;
        }
        String upLoadRoot = UhomePropUtils.getProperty((String)"UPLOAD_PATH");
        String uploadPath = UhomePropUtils.getProperty((String)"UPLOAD_DOC");
        uploadPath = uploadPath + ImageUtilsV2.getCurrentDatePath();
        String extension = StringUtils.trimToEmpty((String)FilenameUtils.getExtension((String)file.getOriginalFilename()));
        logger.debug("\u6587\u4ef6\u540d\u540e\u7f00\uff1a{}, \u7981\u7528\u6587\u4ef6\u6269\u5c55\u540d:{}-{}", new Object[]{extension, UPLOAD_FILE_FORBIDDEN_EXTENSION, FILE_EXTENSIONS_FORBIDDEN_SETS.toArray()});
        if (!FILE_EXTENSIONS_FORBIDDEN_SETS.isEmpty() && StringUtils.isNotBlank((CharSequence)extension) && FILE_EXTENSIONS_FORBIDDEN_SETS.contains(StringUtils.lowerCase((String)extension))) {
            uploadedFile.setError("\u7981\u6b62\u4e0a\u4f20\u8be5\u7c7b\u578b\u6587\u4ef6");
            return uploadedFile;
        }
        if (!FILE_EXTENSIONS_SETS.isEmpty() && StringUtils.isNotBlank((CharSequence)extension) && !FILE_EXTENSIONS_SETS.contains(StringUtils.lowerCase((String)extension))) {
            uploadedFile.setError("\u4e0d\u652f\u6301\u4e0a\u4f20\u8be5\u6587\u4ef6\u7c7b\u578b");
            return uploadedFile;
        }
        try {
            String absPath = upLoadRoot + uploadPath;
            File dir = new File(absPath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            dir.setReadable(true);
            dir.setWritable(true);
            file.transferTo(new File(absPath + File.separator + fileName));
            uploadedFile.setUrl(uploadPath + File.separator + fileName);
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38", (Throwable)e);
        }
        return uploadedFile;
    }

    public static ImageAttr resizeSourceImage(int imageWidth, int imageHeight) {
        ImageAttr imageAttr = new ImageAttr();
        imageAttr.setSrcWidth(imageWidth);
        imageAttr.setSrcHeight(imageHeight);
        int maxWidth = 1080;
        int maxHeight = 1920;
        logger.info("================>>\u4e0a\u4f20\u6587\u4ef6\u5c3a\u5bf8\uff1awidth\uff1a{}, height:{}, maxWidth:{}, maxHeight:{}", new Object[]{imageWidth, imageHeight, maxWidth, maxHeight});
        float aspectRatio = (float)imageWidth / (float)imageHeight;
        maxWidth = imageWidth < maxWidth ? imageWidth : (imageWidth / maxWidth > 0 ? (maxWidth += imageWidth / 2) : (maxWidth += imageWidth % maxWidth));
        maxHeight = imageHeight < maxHeight ? imageHeight : (imageHeight / maxHeight > 0 ? (maxHeight += imageHeight / 2) : (maxHeight += imageHeight % maxHeight));
        Dimension largestDimension = new Dimension(maxWidth, maxHeight);
        if (imageWidth > maxWidth || imageHeight > maxHeight) {
            if ((float)largestDimension.width / (float)largestDimension.height > aspectRatio) {
                largestDimension.width = (int)Math.ceil((float)largestDimension.height * aspectRatio);
            } else {
                largestDimension.height = (int)Math.ceil((float)largestDimension.width / aspectRatio);
            }
            imageWidth = largestDimension.width;
            imageHeight = largestDimension.height;
        }
        imageAttr.setTargetWidth(imageWidth);
        imageAttr.setTargetHeight(imageHeight);
        logger.info("================>>\u4e0a\u4f20\u6587\u4ef6\u538b\u7f29\u5c3a\u5bf8\uff1awidth\uff1a{}, height\uff1a{}", (Object)imageWidth, (Object)imageHeight);
        return imageAttr;
    }

    public static ImageAttr resizeThumbnailImage(int imageWidth, int imageHeight, int maxWidth, int maxHeight) {
        ImageAttr imageAttr = new ImageAttr();
        imageAttr.setSrcHeight(imageHeight);
        imageAttr.setSrcWidth(imageWidth);
        float aspectRatio = (float)imageWidth / (float)imageHeight;
        Dimension largestDimension = new Dimension(maxWidth, maxHeight);
        if (imageWidth > maxWidth || imageHeight > maxHeight) {
            if ((float)largestDimension.width / (float)largestDimension.height > aspectRatio) {
                largestDimension.width = (int)Math.ceil((float)largestDimension.height * aspectRatio);
            } else {
                largestDimension.height = (int)Math.ceil((float)largestDimension.width / aspectRatio);
            }
            imageWidth = largestDimension.width;
            imageHeight = largestDimension.height;
        }
        imageAttr.setTargetWidth(imageWidth);
        imageAttr.setTargetHeight(imageHeight);
        return imageAttr;
    }

    public static void compressSrcImage(String filePath, int imageWidth, int imageHeight) {
        try {
            File file = new File(filePath);
            if (!file.exists() || !file.isFile() || file.length() == 0L) {
                logger.warn("================>>\u539f\u56fe\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a{}", (Object)filePath);
                return;
            }
            Thumbnails.of((File[])new File[]{file}).size(imageWidth, imageHeight).outputQuality(0.7f).toFile(file);
            logger.info("\u539f\u56fe\u538b\u7f29\u6210\u529f\uff0cimageWidth\uff1a{}\uff0cimageHeight\uff1a{}, file\uff1a{}", new Object[]{imageWidth, imageHeight, filePath});
        }
        catch (Exception e) {
            logger.error("\u539f\u56fe\u538b\u7f29\u5f02\u5e38.", (Throwable)e);
            throw new RuntimeException("\u539f\u56fe\u538b\u7f29\u5f02\u5e38");
        }
    }

    public static void compressThumbnailsImage(String thumbnailsPath, int imageWidth, int imageHeight) {
        logger.debug("=================>>\u751f\u6210\u7f29\u7565\u56fe\uff0c{}", (Object)thumbnailsPath);
        try {
            File file = new File(thumbnailsPath);
            if (!file.exists() || !file.isFile() || file.length() == 0L) {
                logger.warn("================>>\u7f29\u7565\u56fe\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a{}", (Object)thumbnailsPath);
                return;
            }
            Thumbnails.of((File[])new File[]{file}).size(imageWidth, imageHeight).outputQuality(0.85f).allowOverwrite(true).toFile(file);
            logger.debug("\u7f29\u7565\u56fe\u538b\u7f29\u6210\u529f\uff0cimageWidth\uff1a{}\uff0cimageHeight\uff1a{}\uff0cfilePath:{}", new Object[]{imageWidth, imageHeight, thumbnailsPath});
        }
        catch (Exception e) {
            logger.error("\u7f29\u7565\u56fe\u538b\u7f29\u5f02\u5e38.", (Throwable)e);
            throw new RuntimeException("\u7f29\u7565\u56fe\u538b\u7f29\u5f02\u5e38");
        }
    }

    public static String getCurrentDatePath() {
        long l = System.currentTimeMillis() / 1000L;
        return "/" + ImageUtilsV2.getCurrentDateByFormat("yyyy/MM/dd") + "/" + l % 1024L;
    }

    public static String getNewFileName() {
        SecureRandom random = new SecureRandom();
        return StringUtils.rightPad((String)(ImageUtilsV2.getCurrentDateByFormat("yyyyMMddHHmmss") + random.nextInt(10000)), (int)18, (char)'0');
    }

    public static String getCurrentDateByFormat(String pattern) {
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            pattern = "yyyy-MM-dd";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        return dateFormat.format(new Date());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static UploadedFile saveImage(MultipartFile file, String category) {
        UploadedFile uploadedFile = new UploadedFile("", 0L);
        if (file == null) {
            uploadedFile.setError("\u56fe\u7247\u4e3a\u7a7a\u3002\u8bf7\u91cd\u65b0\u4e0a\u4f20");
            return uploadedFile;
        }
        logger.debug("\u5f00\u59cb\u5904\u7406\u4e0a\u4f20\u6e90\u56fe\u7247: fileName:{}, fileSize:{}, fileContentType:{}, category:{}, maxWidth:{}, maxHeight:{}, formatName:{}", new Object[]{file.getOriginalFilename(), file.getSize(), category});
        long fileSize = file.getSize();
        if (fileSize == 0L) {
            uploadedFile.setError("\u56fe\u7247\u5927\u5c0f\u4e3a\u7a7a\u3002\u8bf7\u91cd\u65b0\u4e0a\u4f20");
            return uploadedFile;
        }
        if (fileSize > 12328960L) {
            uploadedFile.setError("\u4e0a\u4f20\u56fe\u7247\u6700\u5927\u4e0d\u53ef\u8d85\u8fc710M");
            return uploadedFile;
        }
        String extension = StringUtils.trimToEmpty((String)FilenameUtils.getExtension((String)file.getOriginalFilename()));
        if (StringUtils.isNotBlank((CharSequence)category)) {
            category = UhomePropUtils.getProperty((String)category);
        }
        if (StringUtils.isBlank((CharSequence)category)) {
            category = UPLOAD_PICTURE;
        }
        String uploadDir = category + ImageUtilsV2.getCurrentDatePath();
        String toFilePath = UPLOAD_ROOT + uploadDir;
        String thumbnailsPath = UPLOAD_ROOT + SAMLL_CATEGORY + uploadDir;
        try (InputStream is = file.getInputStream();){
            ImageAttr imageAttr = ImageUtilsV2.getImageWidthHeight(is);
            if (imageAttr.getSrcWidth() == null || imageAttr.getSrcWidth() == 0 || imageAttr.getSrcHeight() == null || imageAttr.getSrcHeight() == 0) {
                uploadedFile.setError("\u8bfb\u53d6\u56fe\u7247\u5931\u8d25");
                UploadedFile uploadedFile2 = uploadedFile;
                return uploadedFile2;
            }
            if (StringUtils.isBlank((CharSequence)extension)) {
                extension = StringUtils.trimToEmpty((String)imageAttr.getFormatName());
            }
            if (!IMAGE_EXTENSIONS_SETS.contains(StringUtils.lowerCase((String)extension))) {
                uploadedFile.setError("\u4e0a\u4f20\u56fe\u7247\u683c\u5f0f\u4e0d\u6b63\u786e");
                UploadedFile uploadedFile3 = uploadedFile;
                return uploadedFile3;
            }
            ImageAttr srcImageAttr = ImageUtilsV2.resizeSourceImage(imageAttr.getSrcWidth(), imageAttr.getSrcHeight());
            String saveFileName = ImageUtilsV2.getNewFileName() + "_" + srcImageAttr.getTargetWidth() + "_" + srcImageAttr.getTargetHeight() + "." + extension;
            ImageUtilsV2.createImageDir(toFilePath);
            ImageUtilsV2.createImageDir(thumbnailsPath);
            String saveFilePath = toFilePath + (toFilePath.endsWith("/") || toFilePath.endsWith("\\") ? "" : "/") + saveFileName;
            logger.debug("\u6e90\u56fe\u4fdd\u5b58\u8def\u5f84\uff1a{}", (Object)saveFilePath);
            String saveThumbnailsPath = thumbnailsPath + (thumbnailsPath.endsWith("/") || thumbnailsPath.endsWith("\\") ? "" : "/") + saveFileName;
            logger.debug("\u7f29\u7565\u56fe\u4fdd\u5b58\u8def\u5f84\uff1a{}", (Object)saveThumbnailsPath);
            file.transferTo(new File(saveFilePath));
            file.transferTo(new File(saveThumbnailsPath));
            srcImageAttr.setFilePath(saveFilePath);
            srcImageAttr.setThumbnailsPath(saveThumbnailsPath);
            uploadedFile.setName(saveFileName);
            uploadedFile.setUrl(uploadDir + "/" + saveFileName);
            AsyncProcessTaskUtil.executeTask(() -> {
                try {
                    RocketMQExtUtils.delaySend(MQConstant.IMAGE_COMPRESS_TOPIC, "COMPRESS_IMAGE_TAG", JacksonUtil.objectToFormateJackson((Object)srcImageAttr), saveFileName, MQDelayLevelE.LEVEL_5S);
                }
                catch (Exception e) {
                    logger.error("\u56fe\u7247\u5904\u7406\u53d1\u9001MQ\u6d88\u606f\u5f02\u5e38", (Throwable)e);
                }
            });
            return uploadedFile;
        }
        catch (ServiceException e) {
            uploadedFile.setError(e.getMessage());
            return uploadedFile;
        }
        catch (Exception e) {
            logger.error("\u6e90\u6587\u4ef6\u4fdd\u5b58\u5f02\u5e38", (Throwable)e);
        }
        return uploadedFile;
    }

    private static void createImageDir(String path) {
        File target = new File(path);
        if (!target.exists()) {
            target.mkdirs();
        }
        target.setReadable(true);
        target.setWritable(true);
    }

    public static ImageAttr getImageWidthHeight(InputStream fileInputStream) {
        ImageAttr imageAttr = new ImageAttr();
        ImageReader imageReader = null;
        ImageInputStream iis = null;
        try {
            iis = ImageIO.createImageInputStream(fileInputStream);
            Iterator<ImageReader> iter = ImageIO.getImageReaders(iis);
            if (!iter.hasNext()) {
                throw new ServiceException("\u4e0d\u652f\u6301\u7684\u56fe\u7247\u683c\u5f0f");
            }
            imageReader = iter.next();
            if (null != imageReader) {
                imageReader.setInput(iis, true);
                imageAttr.setSrcWidth(imageReader.getWidth(0));
                imageAttr.setSrcHeight(imageReader.getHeight(0));
                imageAttr.setFormatName(imageReader.getFormatName());
            }
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u56fe\u7247\u6d41\u5f02\u5e38", (Throwable)e);
            throw new ServiceException("\u8bfb\u53d6\u56fe\u7247\u5931\u8d25");
        }
        finally {
            if (iis != null) {
                try {
                    iis.flush();
                    iis.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95edImageInputStream\u5f02\u5e38", (Throwable)e);
                }
            }
            if (imageReader != null) {
                imageReader.dispose();
            }
        }
        return imageAttr;
    }
}

