/*
 * Decompiled with CFR 0.152.
 */
package com.segi.uhomecp.app.core.utils;

import com.segi.uhomecp.app.core.dto.UploadedFile;
import com.segi.uhomecp.app.core.utils.JPEGReader;
import com.segi.uhomecp.utils.UhomePropUtils;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.UnknownFormatFlagsException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class ImageUtils {
    public static final Logger logger = LoggerFactory.getLogger(ImageUtils.class);
    public static String ACCESS_PREEFIX = UhomePropUtils.getProperty((String)"SOURCE_PATH");
    public static String UPLOAD_ROOT = UhomePropUtils.getProperty((String)"UPLOAD_PATH");
    public static String UPLOAD_PICTURE = UhomePropUtils.getProperty((String)"UPLOAD_PICTURE");
    public static String SAMLL_CATEGORY = UhomePropUtils.getProperty((String)"ACRONYM_PATH");
    public static final int IMAGE_MAX_WIDTH = 1080;
    public static final int IMAGE_MAX_HEIGHT = 1920;
    public static final long MAX_FILE_SIZE = 12328960L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UploadedFile upload(String fileName, InputStream fileInputStream, long fileSize, String fileContentType, String category, int maxWidth, int maxHeight) throws IOException {
        logger.debug("\u5f00\u59cb\u5904\u7406\u4e0a\u4f20\u56fe\u7247: fileName:{}, fileSize:{}, fileContentType:{}, category:{}, maxWidth:{}, maxHeight:{}", new Object[]{fileName, fileSize, fileContentType, category, maxWidth, maxHeight});
        UploadedFile uploadedFile = new UploadedFile(fileName, fileSize);
        if (fileSize == 0L || fileInputStream == null) {
            uploadedFile.setError("\u56fe\u7247\u5927\u5c0f\u4e3a\u7a7a\u3002\u8bf7\u91cd\u65b0\u4e0a\u4f20");
            return uploadedFile;
        }
        if (fileSize > 12328960L) {
            uploadedFile.setError("\u4e0a\u4f20\u56fe\u7247\u6700\u5927\u4e0d\u53ef\u8d85\u8fc710M");
            return uploadedFile;
        }
        if (StringUtils.isNotBlank((CharSequence)category)) {
            category = UhomePropUtils.getProperty((String)category);
        }
        if (StringUtils.isBlank((CharSequence)category)) {
            category = UPLOAD_PICTURE;
        }
        if (maxWidth <= 0 || maxWidth > 1080) {
            maxWidth = 1080;
        }
        if (maxHeight <= 0 || maxHeight > 1920) {
            maxHeight = 1920;
        }
        String uploadPath = category + ImageUtils.getCurrentDatePath();
        String smallUploadPath = SAMLL_CATEGORY + uploadPath;
        logger.debug("=================>>\u4e0a\u4f20\u7684\u6587\u4ef6\u8def\u5f84\uff1a{}, \u7f29\u7565\u56fe\u8def\u5f84:{}", (Object)uploadPath, (Object)smallUploadPath);
        ImageReader reader = null;
        ImageInputStream iis = null;
        try {
            iis = ImageIO.createImageInputStream(fileInputStream);
            Iterator<ImageReader> iter = ImageIO.getImageReaders(iis);
            if (!iter.hasNext()) {
                uploadedFile.setError("\u4e0a\u4f20\u56fe\u7247\u683c\u5f0f\u9519\u8bef");
                UploadedFile uploadedFile2 = uploadedFile;
                return uploadedFile2;
            }
            reader = iter.next();
            String formatName = reader.getFormatName();
            logger.debug("=================>>\u4e0a\u4f20\u7684\u6587\u4ef6\u683c\u5f0f\uff1a{}", (Object)formatName);
            BufferedImage sourceImage = ImageUtils.resizeSourceImage(ImageUtils.getBufferedImage(reader, iis), formatName, 1080, 1920);
            String newFileName = ImageUtils.getNewFileName() + "_" + sourceImage.getWidth() + "_" + sourceImage.getHeight();
            ImageUtils.saveSourceImage(sourceImage, UPLOAD_ROOT + uploadPath, newFileName, formatName);
            BufferedImage compressedImage = ImageUtils.resizeImage(sourceImage, formatName, maxWidth, maxHeight);
            ImageUtils.saveCompressedImage(compressedImage, UPLOAD_ROOT + smallUploadPath, newFileName, formatName);
            String fullFileName = newFileName + "." + formatName;
            uploadedFile.setName(fullFileName);
            uploadedFile.setThumbnailUrl(ACCESS_PREEFIX + smallUploadPath + "/" + fullFileName);
            uploadedFile.setUrl(uploadPath + "/" + fullFileName);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u538b\u7f29\u56fe\u7247\u51fa\u9519.", (Throwable)e);
            uploadedFile.setError("\u4fdd\u5b58\u538b\u7f29\u56fe\u7247\u51fa\u9519.");
        }
        finally {
            IOUtils.closeQuietly((Closeable)iis);
            if (reader != null) {
                reader.dispose();
            }
        }
        logger.debug("========================================\u7ed3\u675f\u5904\u7406\u4e0a\u4f20\u56fe\u7247==========================================================");
        return uploadedFile;
    }

    private static BufferedImage getBufferedImage(ImageReader reader, ImageInputStream iis) {
        ImageReadParam param = reader.getDefaultReadParam();
        reader.setInput(iis, true, true);
        BufferedImage bi = null;
        try {
            bi = reader.read(0, param);
        }
        catch (Exception e) {
            logger.warn("================>>\u8bfb\u53d6\u56fe\u7247\u6d41\u5f02\u5e38\uff0c\u5c1d\u8bd5JPEGReader\u91cd\u65b0\u8bfb\u53d6", (Throwable)e);
            try {
                bi = JPEGReader.read(iis);
                return bi;
            }
            catch (Exception ex) {
                logger.error("================>>JPEGReader\u91cd\u65b0\u8bfb\u53d6\u56fe\u7247\u6d41\u5f02\u5e38", (Throwable)e);
                throw new RuntimeException("\u8bfb\u53d6\u56fe\u7247\u6d41\u5f02\u5e38");
            }
        }
        return bi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UploadedFile uploadFileByFile(String fileName, MultipartFile file) {
        UploadedFile uploadedFile;
        block7: {
            uploadedFile = new UploadedFile(fileName, file == null ? 0L : file.getSize());
            if (file == null || file.isEmpty() || file.getSize() == 0L) {
                return uploadedFile;
            }
            String upLoadRoot = UhomePropUtils.getProperty((String)"UPLOAD_PATH");
            String uploadPath = UhomePropUtils.getProperty((String)"UPLOAD_DOC");
            uploadPath = uploadPath + ImageUtils.getCurrentDatePath();
            FileInputStream fis = null;
            FileOutputStream fos = null;
            FileChannel inChannel = null;
            FileChannel outChannel = null;
            try {
                String path = upLoadRoot + uploadPath;
                File dir = new File(path);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                dir.setReadable(true);
                dir.setWritable(true);
                fis = (FileInputStream)file.getInputStream();
                fos = new FileOutputStream(path + File.separator + fileName);
                inChannel = fis.getChannel();
                outChannel = fos.getChannel();
                inChannel.transferTo(0L, inChannel.size(), outChannel);
                uploadedFile.setUrl(uploadPath + File.separator + fileName);
                IOUtils.closeQuietly((InputStream)fis);
            }
            catch (IOException e) {
                logger.error("\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38", (Throwable)e);
                break block7;
            }
            finally {
                IOUtils.closeQuietly(fis);
                IOUtils.closeQuietly(fos);
                IOUtils.closeQuietly(inChannel);
                IOUtils.closeQuietly(outChannel);
            }
            IOUtils.closeQuietly((OutputStream)fos);
            IOUtils.closeQuietly((Closeable)inChannel);
            IOUtils.closeQuietly((Closeable)outChannel);
        }
        return uploadedFile;
    }

    public static BufferedImage resizeSourceImage(BufferedImage image, String formatName, int maxWidth, int maxHeight) {
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        logger.info("================>>\u4e0a\u4f20\u7684\u6587\u4ef6width\uff1a{}, height:{}, maxWidth:{}, maxHeight:{}", new Object[]{imageWidth, imageHeight, maxWidth, maxHeight});
        float aspectRatio = (float)imageWidth / (float)imageHeight;
        maxWidth = imageWidth < maxWidth ? imageWidth : (imageWidth / maxWidth > 0 ? (maxWidth += imageWidth / 2) : (maxWidth += imageWidth % maxWidth));
        maxHeight = imageHeight < maxHeight ? imageHeight : (imageHeight / maxHeight > 0 ? (maxHeight += imageHeight / 2) : (maxHeight += imageHeight % maxHeight));
        Dimension largestDimension = new Dimension(maxWidth, maxHeight);
        if (imageWidth > maxWidth || imageHeight > maxHeight) {
            if ((float)largestDimension.width / (float)largestDimension.height > aspectRatio) {
                largestDimension.width = (int)Math.ceil((float)largestDimension.height * aspectRatio);
            } else {
                largestDimension.height = (int)Math.ceil((float)largestDimension.width / aspectRatio);
            }
            imageWidth = largestDimension.width;
            imageHeight = largestDimension.height;
        }
        logger.info("================>>\u4e0a\u4f20\u7684\u6587\u4ef6\u6700\u7ec8\u751f\u6210width\uff1a{}, height\uff1a{}", (Object)imageWidth, (Object)imageHeight);
        return ImageUtils.createHeadlessBufferedImage(image, formatName, imageWidth, imageHeight);
    }

    public static BufferedImage resizeImage(BufferedImage image, String formatName, int maxWidth, int maxHeight) {
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        float aspectRatio = (float)imageWidth / (float)imageHeight;
        Dimension largestDimension = new Dimension(maxWidth, maxHeight);
        if (imageWidth > maxWidth || imageHeight > maxHeight) {
            if ((float)largestDimension.width / (float)largestDimension.height > aspectRatio) {
                largestDimension.width = (int)Math.ceil((float)largestDimension.height * aspectRatio);
            } else {
                largestDimension.height = (int)Math.ceil((float)largestDimension.width / aspectRatio);
            }
            imageWidth = largestDimension.width;
            imageHeight = largestDimension.height;
        }
        return ImageUtils.createHeadlessBufferedImage(image, formatName, imageWidth, imageHeight);
    }

    public static void resizeSourceImage(String srcFileName, String toFileName) {
        if (StringUtils.isEmpty((CharSequence)srcFileName)) {
            throw new IllegalArgumentException("\u6e90\u56fe\u7247\u53c2\u6570\u4e3a\u7a7a");
        }
        File srcFile = new File(srcFileName);
        if (srcFile == null || !srcFile.canRead()) {
            throw new IllegalArgumentException("\u6e90\u56fe\u7247\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u8bfb\u5199");
        }
        try {
            ImageInputStream iis = ImageIO.createImageInputStream(srcFile);
            Iterator<ImageReader> iter = ImageIO.getImageReaders(iis);
            if (!iter.hasNext()) {
                throw new RuntimeException("\u4e0d\u652f\u6301\u56fe\u7247\u5904\u7406.");
            }
            ImageReader reader = iter.next();
            String formatName = reader.getFormatName();
            File target = new File(toFileName);
            if (!target.exists()) {
                target.mkdirs();
            }
            target.setReadable(true);
            target.setWritable(true);
            BufferedImage image1 = ImageUtils.resizeSourceImage(ImageUtils.getBufferedImage(reader, iis), formatName, 1080, 1920);
            String newFileName = ImageUtils.getNewFileName() + "_" + image1.getWidth() + "_" + image1.getHeight();
            ImageUtils.saveSourceImage(image1, toFileName, newFileName, formatName);
        }
        catch (IOException e) {
            logger.error("\u4fdd\u5b58\u538b\u7f29\u56fe\u7247\u51fa\u9519.", (Throwable)e);
            throw new RuntimeException("\u4fdd\u5b58\u538b\u7f29\u56fe\u7247\u51fa\u9519.", e);
        }
    }

    public static void saveSourceImage(String srcFileName, String toFileName) {
        if (StringUtils.isEmpty((CharSequence)srcFileName)) {
            throw new IllegalArgumentException("\u6e90\u56fe\u7247\u53c2\u6570\u4e3a\u7a7a");
        }
        File srcFile = new File(srcFileName);
        if (srcFile == null || !srcFile.canRead()) {
            throw new IllegalArgumentException("\u6e90\u56fe\u7247\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u8bfb\u5199");
        }
        try {
            ImageInputStream iis = ImageIO.createImageInputStream(srcFile);
            Iterator<ImageReader> iter = ImageIO.getImageReaders(iis);
            if (!iter.hasNext()) {
                throw new RuntimeException("\u4e0d\u652f\u6301\u56fe\u7247\u5904\u7406.");
            }
            ImageReader reader = iter.next();
            String formatName = reader.getFormatName();
            BufferedImage image = ImageIO.read(iis);
            String newFileName = ImageUtils.getNewFileName() + "_" + image.getWidth() + "_" + image.getHeight();
            ImageUtils.saveSourceImage(image, toFileName, newFileName, formatName);
        }
        catch (IOException e) {
            logger.error("\u4fdd\u5b58\u538b\u7f29\u56fe\u7247\u51fa\u9519.", (Throwable)e);
            throw new RuntimeException("\u4fdd\u5b58\u538b\u7f29\u56fe\u7247\u51fa\u9519.", e);
        }
    }

    public static void saveSourceImage(BufferedImage image, String toFileName, String fileName, String formatName) {
        File target;
        if (StringUtils.isEmpty((CharSequence)formatName)) {
            throw new IllegalArgumentException("\u751f\u6210\u7684\u56fe\u7247\u683c\u5f0f\u672a\u5b9a\u4e49.");
        }
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(formatName);
        if (!iter.hasNext()) {
            throw new UnknownFormatFlagsException("\u672a\u627e\u5230\u56fe\u7247\u5904\u7406\u7684\u5b9e\u73b0.");
        }
        ImageWriter writer = iter.next();
        ImageWriteParam writeParam = writer.getDefaultWriteParam();
        if (writeParam.canWriteCompressed()) {
            writeParam.setCompressionMode(2);
            writeParam.setCompressionQuality(0.7f);
        }
        if (!(target = new File(toFileName)).exists()) {
            target.mkdirs();
        }
        target.setReadable(true);
        target.setWritable(true);
        String fileNameString = toFileName + (toFileName.endsWith("/") || toFileName.endsWith("\\") ? "" : "/") + fileName + "." + formatName;
        try (ImageOutputStream ios = ImageIO.createImageOutputStream(new File(fileNameString));){
            if (ios == null) {
                throw new IOException("\u5199\u5165\u56fe\u7247\u8def\u5f84\u4e3a\u7a7a.");
            }
            if (formatName.equalsIgnoreCase("jpg") || formatName.equalsIgnoreCase("jpeg") || formatName.equalsIgnoreCase("bmp")) {
                int width = image.getWidth();
                int height = image.getHeight();
                BufferedImage newImage = new BufferedImage(width, height, 1);
                Graphics2D g = newImage.createGraphics();
                g.drawImage((Image)image, 0, 0, null);
                g.dispose();
            }
            writer.setOutput(ios);
            writer.write(null, new IIOImage(image, null, null), writeParam);
        }
        catch (IOException e) {
            logger.error("\u4fdd\u5b58\u538b\u7f29\u56fe\u7247\u51fa\u9519.", (Throwable)e);
            throw new RuntimeException("\u4fdd\u5b58\u538b\u7f29\u56fe\u7247\u51fa\u9519.", e);
        }
        finally {
            if (writer != null) {
                writer.dispose();
            }
        }
    }

    public static void saveCompressedImage(BufferedImage image, String toFileName, String fileName, String formatName) {
        File target;
        if (StringUtils.isEmpty((CharSequence)formatName)) {
            throw new IllegalArgumentException("\u751f\u6210\u7684\u56fe\u7247\u683c\u5f0f\u672a\u5b9a\u4e49.");
        }
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(formatName);
        if (!iter.hasNext()) {
            throw new UnknownFormatFlagsException("\u672a\u627e\u5230\u56fe\u7247\u5904\u7406\u7684\u5b9e\u73b0.");
        }
        ImageWriter writer = iter.next();
        ImageWriteParam writeParam = writer.getDefaultWriteParam();
        if (writeParam.canWriteCompressed()) {
            writeParam.setCompressionMode(2);
            writeParam.setCompressionQuality(0.85f);
        }
        if (!(target = new File(toFileName)).exists()) {
            target.mkdirs();
        }
        target.setReadable(true);
        target.setWritable(true);
        String fileNameString = toFileName + (toFileName.endsWith("/") || toFileName.endsWith("\\") ? "" : "/") + fileName + "." + formatName;
        try (ImageOutputStream ios = ImageIO.createImageOutputStream(new File(fileNameString));){
            if (ios == null) {
                throw new IOException("\u5199\u5165\u56fe\u7247\u8def\u5f84\u4e3a\u7a7a.");
            }
            if (formatName.equalsIgnoreCase("jpg") || formatName.equalsIgnoreCase("jpeg") || formatName.equalsIgnoreCase("bmp")) {
                int width = image.getWidth();
                int height = image.getHeight();
                BufferedImage newImage = new BufferedImage(width, height, 1);
                Graphics2D g = newImage.createGraphics();
                g.drawImage((Image)image, 0, 0, null);
                g.dispose();
            }
            writer.setOutput(ios);
            writer.write(null, new IIOImage(image, null, null), writeParam);
        }
        catch (IOException e) {
            logger.error("\u4fdd\u5b58\u538b\u7f29\u56fe\u7247\u51fa\u9519.", (Throwable)e);
            throw new RuntimeException("\u4fdd\u5b58\u538b\u7f29\u56fe\u7247\u51fa\u9519.", e);
        }
        finally {
            if (writer != null) {
                writer.dispose();
            }
        }
    }

    public static BufferedImage createHeadlessBufferedImage(BufferedImage image, String formatName, int width, int height) {
        int type = 1;
        if (formatName.equalsIgnoreCase("png") && ImageUtils.hasAlpha(image)) {
            type = 2;
        }
        int w = image.getWidth();
        int h = image.getHeight();
        BufferedImage bi = new BufferedImage(width, height, type);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                bi.setRGB(x, y, image.getRGB(x * w / width, y * h / height));
            }
        }
        bi.flush();
        return bi;
    }

    public static BufferedImage createHeadlessSmoothBufferedImage(BufferedImage source, String formatName, int width, int height) {
        int type = 1;
        if (formatName.equalsIgnoreCase("png") && ImageUtils.hasAlpha(source)) {
            type = 2;
        }
        BufferedImage dest = new BufferedImage(width, height, type);
        double scalex = (double)width / (double)source.getWidth();
        double scaley = (double)height / (double)source.getHeight();
        for (int y = 0; y < height; ++y) {
            int sourcey = y * source.getHeight() / dest.getHeight();
            double ydiff = ImageUtils.scale(y, scaley) - (double)sourcey;
            for (int x = 0; x < width; ++x) {
                int sourcex = x * source.getWidth() / dest.getWidth();
                double xdiff = ImageUtils.scale(x, scalex) - (double)sourcex;
                int x1 = Math.min(source.getWidth() - 1, sourcex + 1);
                int y1 = Math.min(source.getHeight() - 1, sourcey + 1);
                int rgb1 = ImageUtils.getRGBInterpolation(source.getRGB(sourcex, sourcey), source.getRGB(x1, sourcey), xdiff);
                int rgb2 = ImageUtils.getRGBInterpolation(source.getRGB(sourcex, y1), source.getRGB(x1, y1), xdiff);
                int rgb = ImageUtils.getRGBInterpolation(rgb1, rgb2, ydiff);
                dest.setRGB(x, y, rgb);
            }
        }
        return dest;
    }

    private static double scale(int point, double scale) {
        return (double)point / scale;
    }

    private static int getRGBInterpolation(int value1, int value2, double distance) {
        int alpha1 = (value1 & 0xFF000000) >>> 24;
        int red1 = (value1 & 0xFF0000) >> 16;
        int green1 = (value1 & 0xFF00) >> 8;
        int blue1 = value1 & 0xFF;
        int alpha2 = (value2 & 0xFF000000) >>> 24;
        int red2 = (value2 & 0xFF0000) >> 16;
        int green2 = (value2 & 0xFF00) >> 8;
        int blue2 = value2 & 0xFF;
        int rgb = (int)((double)alpha1 * (1.0 - distance) + (double)alpha2 * distance) << 24 | (int)((double)red1 * (1.0 - distance) + (double)red2 * distance) << 16 | (int)((double)green1 * (1.0 - distance) + (double)green2 * distance) << 8 | (int)((double)blue1 * (1.0 - distance) + (double)blue2 * distance);
        return rgb;
    }

    public static boolean hasAlpha(Image image) {
        try {
            PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
            pg.grabPixels();
            return pg.getColorModel().hasAlpha();
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public static String getCurrentDatePath() {
        long l = System.currentTimeMillis() / 1000L;
        return "/" + ImageUtils.getCurrentDateByFormat("yyyy/MM/dd") + "/" + l % 1024L;
    }

    public static String getNewFileName() {
        SecureRandom random = new SecureRandom();
        return StringUtils.rightPad((String)(ImageUtils.getCurrentDateByFormat("yyyyMMddHHmmss") + random.nextInt(10000)), (int)18, (char)'0');
    }

    public static String getCurrentDateByFormat(String pattern) {
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            pattern = "yyyy-MM-dd";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        return dateFormat.format(new Date());
    }

    public static void main(String[] args) {
        System.out.println("===================:0");
    }
}

