/*
 * Decompiled with CFR 0.152.
 */
package com.segi.uhomecp.app.core.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncProcessTaskUtil {
    private static final Logger logger = LoggerFactory.getLogger(AsyncProcessTaskUtil.class);
    private static final ExecutorService threadPool = new ThreadPoolExecutor(5, 15, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(2000), new ThreadPoolExecutor.AbortPolicy());

    public static <E> List<E> submitTask(List<Callable<E>> list) {
        ArrayList resultlist = new ArrayList();
        try {
            int i;
            ExecutorCompletionService<E> pool = new ExecutorCompletionService<E>(threadPool);
            int size = list.size();
            for (i = 0; i < size; ++i) {
                pool.submit(list.get(i));
            }
            for (i = 0; i < size; ++i) {
                Object result = pool.take().get();
                resultlist.add(result);
            }
        }
        catch (Exception e) {
            logger.error("\u5f02\u6b65\u5904\u7406\u5f02\u5e38", (Throwable)e);
        }
        return resultlist;
    }

    public static void executeTask(Runnable runnable) {
        threadPool.execute(runnable);
    }
}

