/*
 * Decompiled with CFR 0.152.
 */
package com.segi.uhomecp.app.core.service.impl;

import com.segi.uhomecp.app.core.mapper.CommonMapper;
import com.segi.uhomecp.app.core.model.SystemTip;
import com.segi.uhomecp.app.core.service.CommonService;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class CommonServiceImpl
implements CommonService {
    @Autowired
    private CommonMapper commonMapper;

    public Map<String, Object> findAppVersion(String clientType, String device) {
        List<Map<String, Object>> appVersionList = this.commonMapper.findAppVersion(clientType, device);
        return appVersionList != null && appVersionList.size() > 0 ? appVersionList.get(0) : null;
    }

    @Override
    @Cacheable(value={"common"})
    public String getUploadPath() {
        String uploadPath = this.findSyscfgInfo("ACCECC_PATH");
        return StringUtils.isBlank((CharSequence)uploadPath) ? "/" : uploadPath;
    }

    @Override
    public String getUploadAcronymPath() {
        return this.findSyscfgInfo("ACRONYM_PATH");
    }

    @Override
    @Cacheable(value={"common"})
    public String getUploadRoot() {
        return this.findSyscfgInfo("UPLOAD_PATH");
    }

    @Override
    public String getAccessRootPath() {
        return this.findSyscfgInfo("SOURCE_PATH");
    }

    @Override
    public SystemTip querySysTip(Integer sysId) {
        return this.commonMapper.querySysTip(sysId);
    }

    @Override
    public String findSyscfgInfo(String code) {
        return this.commonMapper.findSyscfgInfo(code);
    }
}

