/*
 * Decompiled with CFR 0.152.
 */
package com.segi.uhomecp.app.core.listener;

import com.segi.uhomecp.app.core.dto.ImageAttr;
import com.segi.uhomecp.app.core.utils.ImageUtilsV2;
import com.segi.uhomecp.rocketMQ.RocketMqMessageListener;
import com.segi.uhomecp.utils.JacksonUtil;
import java.util.List;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.common.message.MessageExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageCompressHandler
implements RocketMqMessageListener {
    private static final Logger logger = LoggerFactory.getLogger(ImageCompressHandler.class);

    public boolean onMessage(List<MessageExt> list, ConsumeConcurrentlyContext consumeConcurrentlyContext) {
        try {
            logger.debug("\u3010\u4e0a\u4f20\u56fe\u7247\u538b\u7f29\u76d1\u542c\u5668\u3011\u6d88\u606fid\uff1a{}", (Object)list.get(0).getMsgId());
            String body = new String(list.get(0).getBody(), "UTF-8");
            logger.debug("\u3010\u4e0a\u4f20\u56fe\u7247\u538b\u7f29\u76d1\u542c\u5668\u3011\u5f00\u59cb\u5904\u7406\u4e1a\u52a1\uff0c\u672c\u6b21\u8bf7\u6c42\u7684\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)body);
            ImageAttr imageAttr = (ImageAttr)JacksonUtil.jacksonToObject((String)body, ImageAttr.class);
            if (imageAttr == null) {
                logger.warn("\u3010\u4e0a\u4f20\u56fe\u7247\u538b\u7f29\u76d1\u542c\u5668\u3011MQ\u6d88\u606f\u4f53\u89e3\u6790\u5931\u8d25");
                return true;
            }
            ImageUtilsV2.compressImage(imageAttr);
            logger.debug("\u3010\u4e0a\u4f20\u56fe\u7247\u538b\u7f29\u76d1\u542c\u5668\u3011\u6d88\u606f\u5904\u7406\u6210\u529f");
            return true;
        }
        catch (Exception e) {
            logger.error("\u3010\u4e0a\u4f20\u56fe\u7247\u538b\u7f29\u76d1\u542c\u5668\u3011\u6d88\u606f\u5904\u7406\u5f02\u5e38 \uff1a\u4e22\u5f03\u6d88\u606f", (Throwable)e);
            return false;
        }
    }
}

