/*
 * Decompiled with CFR 0.152.
 */
package com.wb.util;

import com.rw.dao.BaseDAO;
import com.rw.model.FileModel;
import com.rw.util.SpringContextHolder;
import com.wb.common.Base;
import com.wb.common.Parser;
import com.wb.common.Str;
import com.wb.common.UrlBuffer;
import com.wb.common.Var;
import com.wb.common.XwlBuffer;
import com.wb.tool.Console;
import com.wb.util.FileUtil;
import com.wb.util.LogUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class WebUtil {
    public static String submit(String url, JSONObject params) throws IOException {
        return WebUtil.submit((String)url, (String)"POST", (JSONObject)params);
    }

    public static String submit(String url, String method, JSONObject params) throws IOException {
        return new String(WebUtil.submitBytes((String)url, (String)method, (JSONObject)params), "utf-8");
    }

    public static byte[] submitBytes(String url, JSONObject params) throws IOException {
        return WebUtil.submitBytes((String)url, (String)"POST", (JSONObject)params);
    }

    public static byte[] submitBytes(String url, String method, JSONObject params) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        try {
            int timeout = Var.getInt((String)"sys.session.submitTimeout");
            conn.setConnectTimeout(timeout);
            conn.setReadTimeout(timeout);
            conn.setUseCaches(false);
            conn.setRequestMethod(method);
            if (params != null) {
                byte[] data = WebUtil.getParamsText((JSONObject)params).getBytes("utf-8");
                conn.setDoOutput(true);
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
                conn.setRequestProperty("Content-Length", Integer.toString(data.length));
                try (OutputStream os = conn.getOutputStream();){
                    os.write(data);
                    os.flush();
                }
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try (InputStream is = conn.getInputStream();){
                IOUtils.copy((InputStream)is, (OutputStream)bos);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            conn.disconnect();
        }
    }

    private static String getParamsText(JSONObject jo) throws IOException {
        StringBuilder sb = new StringBuilder();
        Set es = jo.entrySet();
        boolean isFirst = true;
        for (Map.Entry e : es) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("&");
            }
            sb.append((String)e.getKey());
            sb.append("=");
            sb.append(URLEncoder.encode(e.getValue().toString(), "utf-8"));
        }
        return sb.toString();
    }

    public static String[] getSortInfo(HttpServletRequest request) {
        String sort = request.getParameter("sort");
        if (StringUtil.isEmpty((String)sort)) {
            return null;
        }
        JSONObject jo = new JSONArray(sort).getJSONObject(0);
        String[] result = new String[]{jo.getString("property"), jo.optString("direction")};
        return result;
    }

    public static String encodeFilename(HttpServletRequest request, String filename) throws IOException {
        String agent = StringUtil.opt((String)request.getHeader("user-agent")).toLowerCase();
        if (agent.indexOf("opera") != -1) {
            return StringUtil.concat((String[])new String[]{"filename*=\"utf-8''", WebUtil.encode((String)filename), "\""});
        }
        if (agent.indexOf("trident") != -1 || agent.indexOf("msie") != -1 || agent.indexOf("edge") != -1) {
            return StringUtil.concat((String[])new String[]{"filename=\"", WebUtil.encode((String)filename), "\""});
        }
        return StringUtil.concat((String[])new String[]{"filename=\"", new String(filename.getBytes("utf-8"), "ISO-8859-1"), "\""});
    }

    public static String encode(String string) throws IOException {
        return StringUtil.replaceAll((String)URLEncoder.encode(string, "utf-8"), (String)"+", (String)"%20");
    }

    public static String decode(String string) throws IOException {
        if (Var.urlEncoding.isEmpty() || StringUtil.isEmpty((String)string)) {
            return string;
        }
        return new String(string.getBytes(Var.urlEncoding), "utf-8");
    }

    public static void clearUpload(HttpServletRequest request, List<FileItem> list) {
        for (FileItem item : list) {
            if (!item.isFormField()) {
                IOUtils.closeQuietly((InputStream)((InputStream)request.getAttribute(item.getFieldName())));
            }
            item.delete();
        }
        String uploadId = (String)request.getAttribute("sys.uploadId");
        if (uploadId != null) {
            HttpSession session = request.getSession(true);
            session.removeAttribute("sys.upread." + uploadId);
            session.removeAttribute("sys.uplen." + uploadId);
        }
    }

    public static String getIdWithUser(HttpServletRequest request, String id) {
        String user = WebUtil.fetch((HttpServletRequest)request, (String)"sys.user");
        return StringUtil.concat((String[])new String[]{id, "@", StringUtil.opt((String)user)});
    }

    public static void setSessionValue(HttpServletRequest request, String name, Object value) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            throw new RuntimeException("Session does not exist.");
        }
        session.setAttribute(name, value);
    }

    public static Object fetchObject(HttpServletRequest request, String name) {
        Object value;
        HttpSession session = request.getSession(false);
        if (session == null || (value = session.getAttribute(name)) == null) {
            value = request.getAttribute(name);
            if (value == null) {
                return request.getParameter(name);
            }
            return value;
        }
        return value;
    }

    public static String fetch(HttpServletRequest request, String name) {
        Object object = WebUtil.fetchObject((HttpServletRequest)request, (String)name);
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public static JSONObject fetch(HttpServletRequest request) {
        String name;
        JSONObject json = new JSONObject();
        Iterator requestParams = request.getParameterMap().entrySet().iterator();
        Enumeration requestAttrs = request.getAttributeNames();
        while (requestParams.hasNext()) {
            Map.Entry entry = requestParams.next();
            json.put((String)entry.getKey(), (Object)((String[])entry.getValue())[0]);
        }
        while (requestAttrs.hasMoreElements()) {
            name = requestAttrs.nextElement().toString();
            if ("sys.app".equals(name) || "sys.varMap".equals(name)) continue;
            json.put(name, request.getAttribute(name));
        }
        HttpSession session = request.getSession(false);
        if (session != null) {
            Enumeration sessionAttrs = session.getAttributeNames();
            while (sessionAttrs.hasMoreElements()) {
                name = sessionAttrs.nextElement().toString();
                if ("sys.simpleListener".equals(name) || "sys.userAgent".equals(name) || "sys.out".equals(name)) continue;
                json.put(name, session.getAttribute(name));
            }
        }
        return json;
    }

    public static String replaceParams(HttpServletRequest request, String text) {
        if (request == null) {
            return text;
        }
        int start = 0;
        int startPos = text.indexOf("{#", start);
        int endPos = text.indexOf("#}", startPos + 2);
        if (startPos != -1 && endPos != -1) {
            StringBuilder buf = new StringBuilder(text.length());
            while (startPos != -1 && endPos != -1) {
                String paramName = text.substring(startPos + 2, endPos);
                String paramValue = paramName.startsWith("Var.") ? Var.getString((String)paramName.substring(4)) : (paramName.startsWith("Str.") ? Str.format((HttpServletRequest)request, (String)paramName.substring(4), (Object[])new Object[0]) : WebUtil.fetch((HttpServletRequest)request, (String)paramName));
                buf.append(text.substring(start, startPos));
                if (paramValue != null) {
                    buf.append(paramValue);
                }
                start = endPos + 2;
                startPos = text.indexOf("{#", start);
                endPos = text.indexOf("#}", startPos + 2);
            }
            buf.append(text.substring(start));
            return buf.toString();
        }
        return text;
    }

    public static String replaceParams(JSONObject jo, String text) {
        if (jo == null) {
            return text;
        }
        int start = 0;
        int startPos = text.indexOf("{#", start);
        int endPos = text.indexOf("#}", startPos + 2);
        if (startPos != -1 && endPos != -1) {
            StringBuilder buf = new StringBuilder(text.length());
            while (startPos != -1 && endPos != -1) {
                String paramName = text.substring(startPos + 2, endPos);
                String paramValue = paramName.startsWith("Var.") ? Var.getString((String)paramName.substring(4)) : jo.optString(paramName);
                buf.append(text.substring(start, startPos));
                if (paramValue != null) {
                    buf.append(paramValue);
                }
                start = endPos + 2;
                startPos = text.indexOf("{#", start);
                endPos = text.indexOf("#}", startPos + 2);
            }
            buf.append(text.substring(start));
            return buf.toString();
        }
        return text;
    }

    public static void send(HttpServletResponse response, Object object) throws IOException {
        if (response.isCommitted()) {
            return;
        }
        ServletOutputStream outputStream = response.getOutputStream();
        if (object instanceof InputStream) {
            try (InputStream inputStream = (InputStream)object;){
                if (Var.sendStreamGzip) {
                    response.setHeader("Content-Encoding", "gzip");
                    try (GZIPOutputStream gos = new GZIPOutputStream((OutputStream)outputStream);){
                        IOUtils.copy((InputStream)inputStream, (OutputStream)gos);
                    }
                }
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
        } else {
            byte[] bytes;
            if (object instanceof byte[]) {
                bytes = (byte[])object;
            } else {
                String text = object == null ? "" : object.toString();
                bytes = text.getBytes("utf-8");
                if (StringUtil.isEmpty((String)response.getContentType())) {
                    response.setContentType("text/html;charset=utf-8");
                }
            }
            int len = bytes.length;
            if (len >= Var.sendGzipMinSize && Var.sendGzipMinSize != -1) {
                response.setHeader("Content-Encoding", "gzip");
                try (GZIPOutputStream gos = new GZIPOutputStream((OutputStream)outputStream);){
                    gos.write(bytes);
                }
            } else {
                response.setContentLength(len);
                outputStream.write(bytes);
            }
        }
        response.flushBuffer();
    }

    public static void send(HttpServletResponse response, String text, boolean successful) throws IOException {
        WebUtil.send((HttpServletResponse)response, (Object)StringUtil.textareaQuote((String)StringUtil.concat((String[])new String[]{"{success:", Boolean.toString(successful), ",value:", StringUtil.quote((String)text), "}"})));
    }

    public static boolean fromAjax(HttpServletRequest request) {
        try {
            return "XMLHttpRequest".equalsIgnoreCase(request.getHeader("X-Requested-With"));
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static void showException(Throwable exception, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        boolean isAjax = WebUtil.fromAjax((HttpServletRequest)request);
        boolean jsonResp = WebUtil.jsonResponse((HttpServletRequest)request);
        boolean directOutput = isAjax || jsonResp;
        StringWriter writer = new StringWriter();
        PrintWriter pwriter = new PrintWriter((Writer)writer, true);
        exception.printStackTrace(pwriter);
        pwriter.close();
        String errorMessage = writer.toString();
        Console.error((HttpServletRequest)request, (Object)errorMessage);
        if (Var.printError && !directOutput) {
            Throwable rootExcept = SysUtil.getRootExcept((Throwable)exception);
            if (rootExcept instanceof ServletException) {
                throw (ServletException)rootExcept;
            }
            throw new ServletException(rootExcept);
        }
        try {
            if (Var.printError) {
                System.err.println(errorMessage);
            }
            if (!response.isCommitted()) {
                String rootError = SysUtil.getRootError((Throwable)exception);
                response.reset();
                if (directOutput) {
                    if (jsonResp) {
                        WebUtil.send((HttpServletResponse)response, (String)rootError, (boolean)false);
                    } else {
                        response.setStatus(500);
                        WebUtil.send((HttpServletResponse)response, (Object)rootError);
                    }
                } else {
                    response.sendError(500, rootError);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean checkLogin(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(false);
        if (session == null || session.getAttribute("sys.logined") == null) {
            boolean directOutput;
            boolean isAjax = WebUtil.fromAjax((HttpServletRequest)request);
            boolean jsonResp = WebUtil.jsonResponse((HttpServletRequest)request);
            boolean bl = directOutput = isAjax || jsonResp;
            if (directOutput) {
                if (jsonResp) {
                    WebUtil.send((HttpServletResponse)response, (String)"$WBE201: Login required", (boolean)false);
                } else {
                    response.setStatus(401);
                    WebUtil.send((HttpServletResponse)response, (Object)"Login required");
                }
            } else {
                Parser parser = new Parser(request, response);
                if (WebUtil.isTouchModule((HttpServletRequest)request)) {
                    parser.parse("sys/session/tlogin.xwl");
                } else {
                    parser.parse("sys/session/login.xwl");
                }
            }
            return false;
        }
        return true;
    }

    private static boolean isTouchModule(HttpServletRequest request) throws IOException {
        JSONObject module;
        String xwl = UrlBuffer.get((String)request.getServletPath());
        if (xwl.isEmpty()) {
            xwl = request.getParameter("xwl");
            if (StringUtil.isEmpty((String)xwl)) {
                return false;
            }
            xwl = StringUtil.concat((String[])new String[]{xwl, ".xwl"});
        }
        if ((module = XwlBuffer.get((String)xwl, (boolean)true)) == null) {
            return false;
        }
        return module.has("hasTouch");
    }

    public static boolean hasRole(HttpServletRequest request, String roleName) {
        String[] roles = (String[])WebUtil.fetchObject((HttpServletRequest)request, (String)"sys.roles");
        return StringUtil.indexOf((String[])roles, (String)roleName) != -1;
    }

    public static List<FileItem> setUploadFile(HttpServletRequest request) throws Exception {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        List list = null;
        String uploadId = request.getParameter("uploadId");
        String objectId = request.getParameter("objectId");
        int maxKbSize = Var.getInt((String)"sys.service.upload.maxSize");
        Integer maxSize = maxKbSize * 1024;
        HashMap<String, Integer> multiFilesMap = null;
        factory.setSizeThreshold(Var.getInt((String)"sys.service.upload.bufferSize"));
        if (uploadId != null && uploadId.indexOf(46) == -1) {
            request.setAttribute("sys.uploadId", (Object)uploadId);
            HttpSession session = request.getSession(true);
            if (session != null) {
                upload.setProgressListener((ProgressListener)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        if ((list = upload.parseRequest(request)) == null || list.size() == 0) {
            return null;
        }
        try {
            for (FileItem item : list) {
                String fieldName = item.getFieldName();
                if (fieldName.indexOf(46) != -1 || fieldName.indexOf(64) != -1) continue;
                if (item.isFormField()) {
                    if (request.getAttribute(fieldName) != null) {
                        throw new RuntimeException("Duplicate parameters \"" + fieldName + "\" found.");
                    }
                    request.setAttribute(fieldName, (Object)item.getString("utf-8"));
                    continue;
                }
                String fileName = FileUtil.getFilename((String)item.getName());
                String fieldExtType = FileUtil.getFileExt((String)fileName);
                if (StringUtils.isNotBlank((String)Var.allowType) && !StringUtils.containsIgnoreCase((String)Var.allowType, (String)fieldExtType)) {
                    throw new IllegalArgumentException("\u6587\u4ef6\u7c7b\u578b\u8d85\u51fa\u4e86\u5141\u8bb8\u8303\u56f4(" + Var.allowType + ")");
                }
                if (StringUtils.isBlank((String)Var.allowType) && StringUtils.isNotBlank((String)Var.notAllowType) && StringUtils.containsIgnoreCase((String)Var.notAllowType, (String)fieldExtType)) {
                    throw new IllegalArgumentException("\u8be5\u7c7b\u578b\u6587\u4ef6\u4e0d\u5141\u8bb8\u4e0a\u4f20!!!");
                }
                long fileSize = item.getSize();
                if (fileSize > (long)maxSize.intValue()) {
                    throw new IllegalArgumentException("\u6587\u4ef6\u8d85\u51fa\u6700\u5927\u503c" + maxKbSize / 1024 + "M");
                }
                InputStream inputStream = item.getInputStream();
                File tempfile = WebUtil.checkImage((FileItem)item);
                if (tempfile != null) {
                    fileSize = tempfile.length();
                    inputStream = new FileInputStream(tempfile);
                }
                if (request.getAttribute(fieldName) != null) {
                    Integer fileIndex;
                    if (multiFilesMap == null) {
                        multiFilesMap = new HashMap<String, Integer>();
                    }
                    if ((fileIndex = (Integer)multiFilesMap.get(fieldName)) == null) {
                        fileIndex = 0;
                    }
                    fileIndex = fileIndex + 1;
                    multiFilesMap.put(fieldName, fileIndex);
                    String fileIndexText = "@" + Integer.toString(fileIndex);
                    if (StringUtil.isEmpty((String)fileName) && fileSize == 0L) {
                        request.setAttribute(String.valueOf(fieldName) + fileIndexText, (Object)"");
                    } else if (StringUtils.isNotBlank((String)objectId)) {
                        WebUtil.saveFileToDB((FileItem)item, (String)objectId, (String)WebUtil.fetch((HttpServletRequest)request, (String)"sys.username"));
                    } else {
                        request.setAttribute(String.valueOf(fieldName) + fileIndexText, (Object)inputStream);
                    }
                    request.setAttribute(StringUtil.concat((String[])new String[]{fieldName, fileIndexText, "__name"}), (Object)fileName);
                    request.setAttribute(StringUtil.concat((String[])new String[]{fieldName, fileIndexText, "__size"}), (Object)fileSize);
                    continue;
                }
                if (StringUtil.isEmpty((String)fileName) && fileSize == 0L) {
                    request.setAttribute(fieldName, (Object)"");
                } else if (StringUtils.isNotBlank((String)objectId)) {
                    WebUtil.saveFileToDB((FileItem)item, (String)objectId, (String)WebUtil.fetch((HttpServletRequest)request, (String)"sys.username"));
                } else {
                    request.setAttribute(fieldName, (Object)inputStream);
                }
                request.setAttribute(String.valueOf(fieldName) + "__name", (Object)fileName);
                request.setAttribute(String.valueOf(fieldName) + "__size", (Object)fileSize);
            }
        }
        catch (Throwable e) {
            WebUtil.clearUploadFile((HttpServletRequest)request, (List)list);
            throw new Exception(e);
        }
        return list;
    }

    public static void saveFileToDB(FileItem item, String objectId, String username) throws IOException, RuntimeException, SQLException {
        BaseDAO baseDAO = (BaseDAO)SpringContextHolder.getBean((String)"baseDAO");
        FileModel fileModel = new FileModel();
        String id = SysUtil.getId();
        fileModel.setId(id);
        fileModel.setName(FileUtil.getFilename((String)item.getName()));
        fileModel.setObjectId(objectId);
        fileModel.setFileSize(Long.valueOf(item.getSize()));
        fileModel.setExtension(FileUtil.getFileExt((String)item.getName()));
        fileModel.setCreateBy(username);
        fileModel.setFileFlag(username);
        File tempFile = new File(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + id);
        com.xiaoleilu.hutool.io.FileUtil.writeFromStream((InputStream)item.getInputStream(), (File)tempFile);
        baseDAO.saveFileToDB(fileModel, tempFile);
    }

    public static File zipImage(FileItem item) {
        BufferedImage bi;
        File file;
        block5: {
            file = null;
            file = com.xiaoleilu.hutool.io.FileUtil.file((File)Base.path, (String)("template" + File.separatorChar + "tempUpload" + File.separatorChar + item.getName()));
            bi = ImageIO.read(file);
            if (bi != null) break block5;
            return null;
        }
        try {
            int width = bi.getWidth();
            int height = bi.getHeight();
            if (width > 1800) {
                width = 1800;
            }
            if (height > 1800) {
                height = 1800;
            }
            Thumbnails.of((InputStream[])new InputStream[]{item.getInputStream()}).size(width, height).toFile(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    public static File checkImage(FileItem item) throws Exception {
        File file = null;
        BufferedImage bi = null;
        try (ImageInputStream iis = null;){
            String uploadDirectory = Var.getString((String)"sys.controls.uploadDirectory");
            file = StringUtil.isEmpty((String)uploadDirectory) ? com.xiaoleilu.hutool.io.FileUtil.file((File)Base.path, (String)("template" + File.separator + "tempUpload" + File.separator + FileUtil.getFilename((String)item.getName()))) : com.xiaoleilu.hutool.io.FileUtil.file((String)(String.valueOf(uploadDirectory) + File.separator + FileUtil.getFilename((String)item.getName())));
            IOUtils.copy((InputStream)item.getInputStream(), (OutputStream)new FileOutputStream(file));
            iis = ImageIO.createImageInputStream(file);
            Iterator<ImageReader> iter = ImageIO.getImageReaders(iis);
            if (!iter.hasNext()) {
                return null;
            }
            bi = ImageIO.read(file);
            if (bi == null) {
                return null;
            }
            try {
                int width = bi.getWidth();
                int height = bi.getHeight();
                boolean resize = false;
                if (width > 1800) {
                    width = 1800;
                    resize = true;
                }
                if (height > 1800) {
                    height = 1800;
                    resize = true;
                }
                if (resize) {
                    Thumbnails.of((InputStream[])new InputStream[]{item.getInputStream()}).size(width, height).toFile(file);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                LogUtil.error((Object)e.getMessage());
                throw e;
            }
        }
        return file;
    }

    public static boolean hasFile(HttpServletRequest request, String name) {
        return request.getAttribute(name) instanceof InputStream;
    }

    public static void clearUploadFile(HttpServletRequest request, List<FileItem> list) {
        for (FileItem item : list) {
            if (item.isFormField() || item.isInMemory()) continue;
            Object object = request.getAttribute(item.getFieldName());
            if (object instanceof InputStream) {
                IOUtils.closeQuietly((InputStream)((InputStream)object));
            }
            item.delete();
        }
        String uploadId = (String)request.getAttribute("sys.uploadId");
        if (uploadId != null) {
            HttpSession session = request.getSession(true);
            session.removeAttribute("sys.upread." + uploadId);
            session.removeAttribute("sys.uplen." + uploadId);
        }
    }

    public static void setLanguage(HttpServletRequest request) {
        String sessionLan;
        HttpSession session = request.getSession(false);
        String setLan = Var.language;
        if (session != null && (sessionLan = (String)session.getAttribute("sys.lang")) != null) {
            setLan = sessionLan;
        }
        if (setLan.equals("auto")) {
            setLan = Var.defaultLanguage;
            String acceptLang = request.getHeader("Accept-Language");
            if (acceptLang != null) {
                String language;
                String mappedLang;
                int pos = acceptLang.indexOf(44);
                if (pos != -1) {
                    acceptLang = acceptLang.substring(0, pos);
                }
                if ((pos = acceptLang.indexOf(59)) != -1) {
                    acceptLang = acceptLang.substring(0, pos);
                }
                setLan = (pos = acceptLang.indexOf(45)) == -1 ? acceptLang.toLowerCase() : ((mappedLang = Str.getMappedLang((String)(language = StringUtil.concat((String[])new String[]{acceptLang.substring(0, pos).toLowerCase(), "_", acceptLang.substring(pos + 1).toUpperCase()})))) == null ? language : mappedLang);
            }
        }
        request.setAttribute("sys.useLang", (Object)setLan);
    }

    public static boolean jsonResponse(HttpServletRequest request) {
        return WebUtil.exists((HttpServletRequest)request, (String)"_jsonresp");
    }

    public static boolean exists(HttpServletRequest request, String name) {
        Object value = name.startsWith("sys.") ? request.getAttribute(name) : WebUtil.fetch((HttpServletRequest)request, (String)name);
        if (value == null) {
            return false;
        }
        return "1".equals(value.toString());
    }

    public static Object getObject(HttpServletRequest request, String name) {
        Object object = request.getAttribute("sys.varMap");
        if (object != null) {
            ConcurrentHashMap map = JSONObject.toConHashMap((Object)object);
            return map.get(name);
        }
        return null;
    }

    public static void include(HttpServletRequest request, HttpServletResponse response, String path) throws Exception {
        WebUtil.doInclude((HttpServletRequest)request, (HttpServletResponse)response, (String)path, (boolean)false);
    }

    public static void forward(HttpServletRequest request, HttpServletResponse response, String path) throws Exception {
        WebUtil.doInclude((HttpServletRequest)request, (HttpServletResponse)response, (String)path, (boolean)true);
    }

    private static void doInclude(HttpServletRequest request, HttpServletResponse response, String path, boolean isForward) throws Exception {
        String xwl = path.endsWith(".xwl") ? path : UrlBuffer.get((String)("/" + path));
        if (xwl == null) {
            if (isForward) {
                request.getRequestDispatcher(path).forward((ServletRequest)request, (ServletResponse)response);
            } else {
                request.getRequestDispatcher(path).include((ServletRequest)request, (ServletResponse)response);
            }
        } else {
            if (isForward) {
                response.resetBuffer();
            }
            if (xwl.isEmpty()) {
                xwl = request.getParameter("xwl");
                if (xwl == null) {
                    response.sendError(400, "null xwl");
                    return;
                }
                xwl = StringUtil.concat((String[])new String[]{xwl, ".xwl"});
            }
            Parser parser = new Parser(request, response);
            parser.parse(xwl);
        }
    }

    public static void setObject(HttpServletRequest request, String name, Object value) {
        Object object = request.getAttribute("sys.varMap");
        if (object != null) {
            ConcurrentHashMap map = JSONObject.toConHashMap((Object)object);
            if (map.containsKey(name)) {
                throw new IllegalArgumentException("Key \"" + name + "\" already exists.");
            }
            map.put(name, value);
        }
    }
}

