/*
 * Decompiled with CFR 0.152.
 */
package com.wb.util;

import com.wb.util.DateUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.mail.internet.MimeUtility;
import org.apache.commons.io.IOUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class StringUtil {
    public static String repeat(String text, int count) {
        StringBuilder buf = new StringBuilder(text.length() * count);
        int i = 0;
        while (i < count) {
            buf.append(text);
            ++i;
        }
        return buf.toString();
    }

    public static String[] split(String string, String separator) {
        return StringUtil.split((String)string, (String)separator, (boolean)false);
    }

    public static String[] split(String string, String separator, boolean trim) {
        int pos = 0;
        int oldPos = 0;
        int index = 0;
        int separatorLen = separator.length();
        ArrayList<Integer> posData = new ArrayList<Integer>();
        if (string == null) {
            string = "";
        }
        while ((pos = string.indexOf(separator, pos)) != -1) {
            posData.add(pos);
            pos += separatorLen;
        }
        posData.add(string.length());
        String[] result = new String[posData.size()];
        Iterator iterator = posData.iterator();
        while (iterator.hasNext()) {
            int p = (Integer)iterator.next();
            result[index] = trim ? string.substring(oldPos, p).trim() : string.substring(oldPos, p);
            oldPos = p + separatorLen;
            ++index;
        }
        return result;
    }

    public static String[] split(String string, char separator) {
        return StringUtil.split((String)string, (char)separator, (boolean)false);
    }

    public static String[] split(String string, char separator, boolean trim) {
        int pos = 0;
        int oldPos = 0;
        int index = 0;
        ArrayList<Integer> posData = new ArrayList<Integer>();
        if (string == null) {
            string = "";
        }
        while ((pos = string.indexOf(separator, pos)) != -1) {
            posData.add(pos);
            ++pos;
        }
        posData.add(string.length());
        String[] result = new String[posData.size()];
        Iterator iterator = posData.iterator();
        while (iterator.hasNext()) {
            int p = (Integer)iterator.next();
            result[index] = trim ? string.substring(oldPos, p).trim() : string.substring(oldPos, p);
            oldPos = p + 1;
            ++index;
        }
        return result;
    }

    public static boolean isSame(String string1, String string2) {
        if (string1 != null) {
            return string1.equalsIgnoreCase(string2);
        }
        if (string2 != null) {
            return string2.equalsIgnoreCase(string1);
        }
        return true;
    }

    public static boolean isEqual(String string1, String string2) {
        if (string1 != null) {
            return string1.equals(string2);
        }
        if (string2 != null) {
            return string2.equals(string1);
        }
        return true;
    }

    public static String toString(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof java.util.Date) {
            return DateUtil.dateToStr((java.util.Date)((java.util.Date)object));
        }
        return object.toString();
    }

    public static String textareaQuote(String text) {
        return StringUtil.concat((String[])new String[]{"<textarea>", text, "</textarea>"});
    }

    public static String toHTMLKey(String text) {
        if (StringUtil.isEmpty((String)text)) {
            return "";
        }
        int j = text.length();
        StringBuilder out = new StringBuilder(text.length());
        int i = 0;
        while (i < j) {
            char c = text.charAt(i);
            switch (c) {
                case '&': {
                    out.append("&amp;");
                    break;
                }
                case '<': {
                    out.append("&lt;");
                    break;
                }
                case '>': {
                    out.append("&gt;");
                    break;
                }
                case '\'': {
                    out.append("&#39;");
                    break;
                }
                case '\"': {
                    out.append("&quot;");
                    break;
                }
                default: {
                    out.append(c);
                }
            }
            ++i;
        }
        return out.toString();
    }

    public static String toHTML(String text) {
        return StringUtil.toHTML((String)text, (boolean)false, (boolean)true);
    }

    public static String toHTML(String text, boolean nbspAsEmpty, boolean allowNewLine) {
        if (StringUtil.isEmpty((String)text)) {
            if (nbspAsEmpty) {
                return "&nbsp;";
            }
            return "";
        }
        int j = text.length();
        StringBuilder out = new StringBuilder(text.length());
        int i = 0;
        while (i < j) {
            char c = text.charAt(i);
            switch (c) {
                case ' ': {
                    if (i < j - 1 && text.charAt(i + 1) == ' ' || i > 1 && text.charAt(i - 1) == ' ') {
                        out.append("&nbsp;");
                        break;
                    }
                    out.append(" ");
                    break;
                }
                case '\"': {
                    out.append("&quot;");
                    break;
                }
                case '\'': {
                    out.append("&#39;");
                    break;
                }
                case '<': {
                    out.append("&lt;");
                    break;
                }
                case '>': {
                    out.append("&gt;");
                    break;
                }
                case '&': {
                    out.append("&amp;");
                    break;
                }
                case '\n': {
                    if (allowNewLine) {
                        out.append("<br>");
                        break;
                    }
                    out.append("&nbsp;");
                    break;
                }
                case '\r': {
                    break;
                }
                case '\t': {
                    out.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                    break;
                }
                default: {
                    out.append(c);
                }
            }
            ++i;
        }
        return out.toString();
    }

    public static int indexOf(String[] list, String string) {
        if (list == null) {
            return -1;
        }
        int j = list.length;
        int i = 0;
        while (i < j) {
            if (list[i].equals(string)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String convertBool(String value) {
        if ("true".equalsIgnoreCase(value)) {
            return "1";
        }
        if ("false".equalsIgnoreCase(value)) {
            return "0";
        }
        return value;
    }

    public static String concat(String ... string) {
        int length = 0;
        String[] stringArray = string;
        int n = string.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            length += str.length();
            ++n2;
        }
        StringBuilder buf = new StringBuilder(length);
        String[] stringArray2 = string;
        int n3 = string.length;
        n = 0;
        while (n < n3) {
            String str = stringArray2[n];
            buf.append(str);
            ++n;
        }
        return buf.toString();
    }

    public static int stringOccur(String source, char dest) {
        return StringUtil.stringOccur((String)source, (char)dest, (int)0, (int)source.length())[0];
    }

    public static int[] stringOccur(String source, char dest, int startIndex, int endIndex) {
        int newPos;
        int[] result = new int[2];
        int pos = startIndex;
        int count = 0;
        while ((newPos = source.indexOf(dest, pos)) != -1) {
            if (newPos > endIndex) break;
            pos = newPos + 1;
            ++count;
        }
        result[0] = count;
        result[1] = count == 0 ? source.lastIndexOf(dest, endIndex) + 1 : pos;
        return result;
    }

    public static boolean isNumeric(String string, boolean decimal) {
        int j;
        String ts = string.trim();
        if (decimal && StringUtil.stringOccur((String)string, (char)'.') > 1) {
            return false;
        }
        if (ts.startsWith("-")) {
            ts = ts.substring(1);
        }
        if ((j = ts.length()) == 0) {
            return false;
        }
        int i = 0;
        while (i < j) {
            char ch = ts.charAt(i);
            if (!(ch >= '0' && ch <= '9' || decimal && ch == '.')) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isNumeric(String string) {
        return StringUtil.isNumeric((String)string, (boolean)false);
    }

    public static String toLine(String string) {
        int len = string.length();
        if (len == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    buffer.append(' ');
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String getNamePart(String string) {
        if (string == null) {
            return "";
        }
        int index = string.indexOf(61);
        if (index == -1) {
            return string;
        }
        return string.substring(0, index);
    }

    public static String getValuePart(String string) {
        if (string == null) {
            return "";
        }
        int index = string.indexOf(61);
        if (index == -1) {
            return "";
        }
        return string.substring(index + 1);
    }

    public static String replaceAll(String string, String oldString, String newString) {
        return StringUtil.innerReplace((String)string, (String)oldString, (String)newString, (boolean)true);
    }

    public static String replaceFirst(String string, String oldString, String newString) {
        return StringUtil.innerReplace((String)string, (String)oldString, (String)newString, (boolean)false);
    }

    private static String innerReplace(String string, String oldString, String newString, boolean isAll) {
        int index = string.indexOf(oldString);
        if (index == -1) {
            return string;
        }
        int start = 0;
        int len = oldString.length();
        if (len == 0) {
            return string;
        }
        StringBuilder buffer = new StringBuilder(string.length());
        do {
            buffer.append(string.substring(start, index));
            buffer.append(newString);
            start = index + len;
        } while (isAll && (index = string.indexOf(oldString, start)) != -1);
        buffer.append(string.substring(start));
        return buffer.toString();
    }

    public static String getString(InputStream stream) throws IOException {
        return StringUtil.getString((InputStream)stream, (String)"utf-8");
    }

    public static String getString(InputStream stream, String charset) throws IOException {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)stream, (OutputStream)os);
            if (StringUtil.isEmpty((String)charset)) {
                String string = new String(os.toByteArray());
                return string;
            }
            String string = new String(os.toByteArray(), charset);
            return string;
        }
        finally {
            stream.close();
        }
    }

    public static String ellipsis(String string, int length) {
        if (string.length() > length) {
            return String.valueOf(string.substring(0, length - 3)) + "...";
        }
        return string;
    }

    public static String quote(String string) {
        return StringUtil.quote((String)string, (boolean)true);
    }

    public static String text(String string) {
        return StringUtil.quote((String)string, (boolean)false);
    }

    public static String quote(String string, boolean addQuotes) {
        int len;
        if (string == null || (len = string.length()) == 0) {
            if (addQuotes) {
                return "\"\"";
            }
            return "";
        }
        char curChar = '\u0000';
        StringBuilder sb = new StringBuilder(len + 10);
        if (addQuotes) {
            sb.append('\"');
        }
        int i = 0;
        while (i < len) {
            char lastChar = curChar;
            curChar = string.charAt(i);
            switch (curChar) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(curChar);
                    break;
                }
                case '/': {
                    if (lastChar == '<') {
                        sb.append('\\');
                    }
                    sb.append(curChar);
                    break;
                }
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                default: {
                    if (curChar < ' ' || curChar >= '\u0080' && curChar < '\u00a0' || curChar >= '\u2000' && curChar < '\u2100') {
                        sb.append("\\u");
                        String str = Integer.toHexString(curChar);
                        sb.append("0000", 0, 4 - str.length());
                        sb.append(str);
                        break;
                    }
                    sb.append(curChar);
                }
            }
            ++i;
        }
        if (addQuotes) {
            sb.append('\"');
        }
        return sb.toString();
    }

    public static String opt(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    public static String force(String string) {
        if (StringUtil.isEmpty((String)string)) {
            return null;
        }
        return string;
    }

    public static String select(String ... string) {
        String[] stringArray = string;
        int n = string.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!StringUtil.isEmpty((String)s)) {
                return s;
            }
            ++n2;
        }
        return "";
    }

    public static boolean getBool(String value) {
        return value != null && !value.equalsIgnoreCase("false") && !value.equals("0") && !value.isEmpty();
    }

    public static Boolean getBoolA(String value) {
        if (value == null) {
            return null;
        }
        return StringUtil.getBool((String)value);
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static String encodeBase64(byte[] bytes) throws Exception {
        ByteArrayOutputStream data;
        try (OutputStream os = null;){
            data = new ByteArrayOutputStream();
            os = MimeUtility.encode((OutputStream)data, (String)"base64");
            os.write(bytes);
        }
        return new String(data.toByteArray());
    }

    public static String encodeBase64(InputStream is) throws Exception {
        OutputStream os = null;
        ByteArrayOutputStream inData = null;
        ByteArrayOutputStream outData = null;
        try {
            inData = new ByteArrayOutputStream();
            outData = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)is, (OutputStream)inData);
            os = MimeUtility.encode((OutputStream)outData, (String)"base64");
            os.write(inData.toByteArray());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)os);
        return new String(outData.toByteArray());
    }

    public static byte[] decodeBase64(String data) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(data.getBytes());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (InputStream base64is = MimeUtility.decode((InputStream)is, (String)"base64");){
            IOUtils.copy((InputStream)base64is, (OutputStream)os);
        }
        return os.toByteArray();
    }

    public static String encode(Object object) throws Exception {
        if (object == null) {
            return "null";
        }
        if (object instanceof InputStream) {
            return StringUtil.quote((String)StringUtil.encodeBase64((InputStream)((InputStream)object)));
        }
        if (object instanceof Number || object instanceof Boolean) {
            return object.toString();
        }
        if (object instanceof Timestamp || object instanceof Date || object instanceof Time) {
            return StringUtil.quote((String)object.toString());
        }
        if (object instanceof java.util.Date) {
            return StringUtil.quote((String)DateUtil.dateToStr((java.util.Date)((java.util.Date)object)));
        }
        return StringUtil.quote((String)object.toString());
    }

    public static boolean checkName(String name) {
        return StringUtil.checkName((String)name, (boolean)false);
    }

    public static boolean checkName(String name, boolean containtDot) {
        int j = name.length();
        int i = 0;
        while (i < j) {
            char c = name.charAt(i);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || i > 0 && c >= '0' && c <= '9' || containtDot && c == '.')) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String quoteIf(String name) {
        if (StringUtil.checkName((String)name)) {
            return name;
        }
        return StringUtil.quote((String)name);
    }

    public static String join(String[] strings, char splitter) {
        StringBuilder buf = new StringBuilder();
        boolean added = false;
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!StringUtil.isEmpty((String)s)) {
                if (added) {
                    buf.append(splitter);
                } else {
                    added = true;
                }
                buf.append(s);
            }
            ++n2;
        }
        return buf.toString();
    }

    public static String join(List<String> list, char splitter) {
        StringBuilder buf = new StringBuilder();
        boolean added = false;
        for (String item : list) {
            if (StringUtil.isEmpty((String)item)) continue;
            if (added) {
                buf.append(splitter);
            } else {
                added = true;
            }
            buf.append(item);
        }
        return buf.toString();
    }

    public static String substring(String string, int beginIndex, int endIndex) {
        if (string == null) {
            return null;
        }
        if (string.length() > endIndex) {
            return string.substring(beginIndex, endIndex);
        }
        return string;
    }

    public static String formatNumber(double value, String format) {
        DecimalFormat df = new DecimalFormat(format);
        df.setRoundingMode(RoundingMode.HALF_UP);
        return df.format(value);
    }
}

