/*
 * Decompiled with CFR 0.152.
 */
package com.wb.util;

import com.wb.common.Base;
import com.wb.common.Dictionary;
import com.wb.common.KVBuffer;
import com.wb.common.Var;
import com.wb.tool.DictRecord;
import com.wb.tool.Query;
import com.wb.tool.Updater;
import com.wb.util.DateUtil;
import com.wb.util.FileUtil;
import com.wb.util.JsonUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.TradeDateUtil;
import com.wb.util.WebUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.InitialContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class DbUtil {
    public static final Object[][] sqlTypes = new Object[][]{{"BIT", -7}, {"TINYINT", -6}, {"SMALLINT", 5}, {"INTEGER", 4}, {"BIGINT", -5}, {"FLOAT", 6}, {"REAL", 7}, {"DOUBLE", 8}, {"NUMERIC", 2}, {"DECIMAL", 3}, {"CHAR", 1}, {"VARCHAR", 12}, {"LONGVARCHAR", -1}, {"DATE", 91}, {"TIME", 92}, {"TIMESTAMP", 93}, {"BINARY", -2}, {"VARBINARY", -3}, {"LONGVARBINARY", -4}, {"NULL", 0}, {"OTHER", 1111}, {"JAVA_OBJECT", 2000}, {"DISTINCT", 2001}, {"STRUCT", 2002}, {"ARRAY", 2003}, {"BLOB", 2004}, {"CLOB", 2005}, {"REF", 2006}, {"DATALINK", 70}, {"BOOLEAN", 16}, {"ROWID", -8}, {"NCHAR", -15}, {"NVARCHAR", -9}, {"LONGNVARCHAR", -16}, {"NCLOB", 2011}, {"SQLXML", 2009}};
    public static ConcurrentHashMap<String, Connection> buffer = new ConcurrentHashMap();

    public static Integer getFieldType(String name) {
        if (StringUtil.isEmpty((String)name)) {
            return 12;
        }
        int j = sqlTypes.length;
        int i = 0;
        while (i < j) {
            if (name.equalsIgnoreCase((String)sqlTypes[i][0])) {
                return (Integer)sqlTypes[i][1];
            }
            ++i;
        }
        if (StringUtil.isNumeric((String)name)) {
            return Integer.parseInt(name);
        }
        return null;
    }

    public static String getTypeName(int type) {
        int j = sqlTypes.length;
        switch (type) {
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                return null;
            }
        }
        int i = 0;
        while (i < j) {
            if (type == (Integer)sqlTypes[i][1]) {
                return ((String)sqlTypes[i][0]).toLowerCase();
            }
            ++i;
        }
        return Integer.toString(type);
    }

    public static void importData(Connection connection, String tableName, BufferedReader reader) throws Exception {
        DbUtil.importData((Connection)connection, (String)tableName, (BufferedReader)reader, null, (char)' ');
    }

    public static void importData(Connection connection, String tableName, BufferedReader reader, String[] fieldList, char fieldSeparator) throws Exception {
        ResultSet rs = null;
        PreparedStatement st = null;
        boolean jsonFormat = fieldList == null;
        try {
            String line;
            st = connection.prepareStatement(StringUtil.concat((String[])new String[]{"select * from ", tableName, " where 1=0"}));
            rs = st.executeQuery();
            ResultSetMetaData meta = rs.getMetaData();
            int j = meta.getColumnCount();
            int[] indexList = jsonFormat ? null : new int[j];
            int[] types = new int[j];
            String[] fieldNames = new String[j];
            String[] quoteNames = new String[j];
            int i = 0;
            while (i < j) {
                int k = i + 1;
                types[i] = meta.getColumnType(k);
                fieldNames[i] = meta.getColumnLabel(k);
                fieldNames[i] = DbUtil.getFieldName((String)fieldNames[i]);
                quoteNames[i] = StringUtil.quoteIf((String)fieldNames[i]);
                if (!jsonFormat) {
                    indexList[i] = StringUtil.indexOf((String[])fieldList, (String)fieldNames[i]);
                }
                ++i;
            }
            DbUtil.close((Object)rs);
            DbUtil.close((Object)st);
            st = connection.prepareStatement(StringUtil.concat((String[])new String[]{"insert into ", tableName, "(", StringUtil.join((String[])quoteNames, (char)','), ") values (?", StringUtil.repeat((String)",?", (int)(j - 1)), ")"}));
            while ((line = reader.readLine()) != null) {
                if (jsonFormat) {
                    JSONObject record = new JSONObject(line);
                    i = 0;
                    while (i < j) {
                        DbUtil.setObject((PreparedStatement)st, (int)(i + 1), (int)types[i], (Object)JsonUtil.opt((JSONObject)record, (String)fieldNames[i]));
                        ++i;
                    }
                } else {
                    String[] values = StringUtil.split((String)line, (char)fieldSeparator);
                    i = 0;
                    while (i < j) {
                        String value = indexList[i] == -1 ? null : values[indexList[i]];
                        DbUtil.setObject((PreparedStatement)st, (int)(i + 1), (int)types[i], (Object)value);
                        ++i;
                    }
                }
                DbUtil.addBatch((PreparedStatement)st);
            }
            DbUtil.executeBatch((PreparedStatement)st);
        }
        catch (Throwable throwable) {
            DbUtil.close(rs);
            DbUtil.close(st);
            reader.close();
            throw throwable;
        }
        DbUtil.close((Object)rs);
        DbUtil.close((Object)st);
        reader.close();
    }

    public static void exportData(ResultSet rs, Writer writer) throws Exception {
        ResultSetMetaData meta = rs.getMetaData();
        boolean newLine = false;
        int j = meta.getColumnCount();
        int[] types = new int[j];
        String[] names = new String[j];
        int i = 0;
        while (i < j) {
            types[i] = meta.getColumnType(i + 1);
            names[i] = meta.getColumnLabel(i + 1);
            names[i] = DbUtil.getFieldName((String)names[i]);
            ++i;
        }
        while (rs.next()) {
            if (newLine) {
                writer.write(10);
            } else {
                newLine = true;
            }
            writer.write(123);
            i = 0;
            while (i < j) {
                int k = i + 1;
                if (i > 0) {
                    writer.write(44);
                }
                writer.write(StringUtil.quote((String)names[i]));
                writer.write(58);
                if (DbUtil.isBlobField((int)types[i])) {
                    InputStream stream = rs.getBinaryStream(k);
                    try {
                        writer.write(StringUtil.encode((Object)stream));
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)stream);
                    }
                } else {
                    writer.write(StringUtil.encode((Object)DbUtil.getObject((ResultSet)rs, (int)k, (int)types[i])));
                }
                ++i;
            }
            writer.write(125);
        }
        writer.flush();
    }

    public static void addBatch(PreparedStatement statement) throws SQLException {
        if (Var.batchUpdate) {
            statement.addBatch();
        } else {
            statement.executeUpdate();
        }
    }

    public static int[] executeBatch(PreparedStatement statement) throws SQLException {
        if (Var.batchUpdate) {
            return statement.executeBatch();
        }
        return null;
    }

    public static Connection getConnection() throws Exception {
        return DbUtil.getConnection((String)"");
    }

    public static Connection getConnection(HttpServletRequest request) throws Exception {
        return DbUtil.getConnection((HttpServletRequest)request, null);
    }

    public static Connection getConnection(String jndi) throws Exception {
        jndi = StringUtil.isEmpty((String)jndi) ? Var.jndi : Var.getString((String)("sys.jndi." + jndi));
        InitialContext context = new InitialContext();
        DataSource ds = (DataSource)context.lookup(jndi);
        Connection conn = ds.getConnection();
        buffer.put(com.xiaoleilu.hutool.date.DateUtil.now(), conn);
        return conn;
    }

    public static Connection getConnection(HttpServletRequest request, String jndi) throws Exception {
        Connection conn;
        String storeName = StringUtil.isEmpty((String)jndi) ? "conn@@" : "conn@@" + jndi;
        Object obj = WebUtil.getObject((HttpServletRequest)request, (String)storeName);
        if (obj == null) {
            conn = DbUtil.getConnection((String)jndi);
            WebUtil.setObject((HttpServletRequest)request, (String)storeName, (Object)conn);
        } else {
            conn = (Connection)obj;
        }
        return conn;
    }

    public static void startTransaction(Connection connection, String isolation) throws Exception {
        if (!connection.getAutoCommit()) {
            connection.commit();
        }
        connection.setAutoCommit(false);
        if (!StringUtil.isEmpty((String)isolation)) {
            if (isolation.equals("readUncommitted")) {
                connection.setTransactionIsolation(1);
            } else if (isolation.equals("readCommitted")) {
                connection.setTransactionIsolation(2);
            } else if (isolation.equals("repeatableRead")) {
                connection.setTransactionIsolation(4);
            } else if (isolation.equals("serializable")) {
                connection.setTransactionIsolation(8);
            }
        }
    }

    private static void closeResult(ResultSet resultSet) {
        try {
            resultSet.close();
            resultSet = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void closeStatement(Statement statement) {
        try {
            statement.close();
            statement = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void closeConnection(Connection connection, boolean rollback) {
        block10: {
            try {
                if (connection.isClosed()) {
                    return;
                }
                try {
                    try {
                        if (connection.getAutoCommit()) break block10;
                        if (rollback) {
                            connection.rollback();
                            break block10;
                        }
                        connection.commit();
                    }
                    catch (Throwable e) {
                        if (!rollback) {
                            connection.rollback();
                        }
                        connection.close();
                        connection = null;
                    }
                }
                finally {
                    connection.close();
                    connection = null;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void close(Object object) {
        if (object instanceof ResultSet) {
            DbUtil.closeResult((ResultSet)((ResultSet)object));
        } else if (object instanceof Statement) {
            DbUtil.closeStatement((Statement)((Statement)object));
        } else if (object instanceof Connection) {
            DbUtil.closeConnection((Connection)((Connection)object), (boolean)true);
        }
    }

    public static void closeCommit(Connection connection) {
        if (connection != null) {
            DbUtil.closeConnection((Connection)connection, (boolean)false);
        }
    }

    public static boolean isBlobField(int type) {
        switch (type) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return true;
            }
        }
        return false;
    }

    public static boolean isTextField(int type) {
        switch (type) {
            case -16: 
            case -1: 
            case 2005: 
            case 2011: {
                return true;
            }
        }
        return false;
    }

    public static boolean isStringField(int type) {
        switch (type) {
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public static boolean maybeFloatField(int type) {
        switch (type) {
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static void loadFirstRow(HttpServletRequest request, ResultSet resultSet, String prefix) throws Exception {
        if (!resultSet.next()) {
            return;
        }
        ResultSetMetaData meta = resultSet.getMetaData();
        int j = meta.getColumnCount();
        boolean hasPrefix = !StringUtil.isEmpty((String)prefix);
        int i = 1;
        while (i <= j) {
            Object object;
            String name = meta.getColumnLabel(i);
            name = DbUtil.getFieldName((String)name);
            if (hasPrefix) {
                name = StringUtil.concat((String[])new String[]{prefix, ".", name});
            }
            if ((object = DbUtil.getObject((ResultSet)resultSet, (int)i, (int)meta.getColumnType(i))) instanceof ResultSet || object instanceof InputStream) {
                WebUtil.setObject((HttpServletRequest)request, (String)SysUtil.getId(), (Object)object);
            }
            request.setAttribute(name, object);
            ++i;
        }
    }

    public static String getTypeCategory(int type) {
        switch (type) {
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 16: {
                return "int";
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return "float";
            }
            case 91: 
            case 92: 
            case 93: {
                return "date";
            }
        }
        return "string";
    }

    public static String getText(ResultSet rs, int index) throws Exception {
        return (String)DbUtil.getObject((ResultSet)rs, (int)index, (int)-1);
    }

    public static String getText(ResultSet rs, String fieldName) throws Exception {
        return (String)DbUtil.getObject((ResultSet)rs, (String)fieldName, (int)-1);
    }

    public static void setText(PreparedStatement statement, int index, String value) throws Exception {
        DbUtil.setObject((PreparedStatement)statement, (int)index, (int)-1, (Object)value);
    }

    public static Object getObject(CallableStatement statement, int index, int type) throws Exception {
        Object obj;
        switch (type) {
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                obj = statement.getString(index);
                break;
            }
            case 4: {
                obj = statement.getInt(index);
                break;
            }
            case -6: {
                obj = statement.getByte(index);
                break;
            }
            case 5: {
                obj = statement.getShort(index);
                break;
            }
            case -5: {
                obj = statement.getLong(index);
                break;
            }
            case 6: 
            case 7: {
                obj = Float.valueOf(statement.getFloat(index));
                break;
            }
            case 8: {
                obj = statement.getDouble(index);
                break;
            }
            case 2: 
            case 3: {
                obj = statement.getBigDecimal(index);
                break;
            }
            case 93: {
                obj = statement.getTimestamp(index);
                break;
            }
            case 91: {
                obj = statement.getDate(index);
                break;
            }
            case 92: {
                obj = statement.getTime(index);
                break;
            }
            case -7: 
            case 16: {
                obj = statement.getBoolean(index) ? 1 : 0;
                break;
            }
            case -16: 
            case -1: 
            case 2005: 
            case 2011: {
                Reader rd = statement.getCharacterStream(index);
                if (rd == null) {
                    obj = null;
                    break;
                }
                obj = SysUtil.readString((Reader)rd);
                break;
            }
            default: {
                obj = statement.getObject(index);
            }
        }
        if (statement.wasNull()) {
            return null;
        }
        return obj;
    }

    public static Object getObject(ResultSet rs, int index, int type) throws Exception {
        Object obj;
        switch (type) {
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                obj = rs.getString(index);
                break;
            }
            case 4: {
                obj = rs.getInt(index);
                break;
            }
            case -6: {
                obj = rs.getByte(index);
                break;
            }
            case 5: {
                obj = rs.getShort(index);
                break;
            }
            case -5: {
                obj = rs.getLong(index);
                break;
            }
            case 6: 
            case 7: {
                obj = Float.valueOf(rs.getFloat(index));
                break;
            }
            case 8: {
                obj = rs.getDouble(index);
                break;
            }
            case 2: 
            case 3: {
                obj = rs.getBigDecimal(index);
                break;
            }
            case 93: {
                obj = rs.getTimestamp(index);
                break;
            }
            case 91: {
                obj = rs.getDate(index);
                break;
            }
            case 92: {
                obj = rs.getTime(index);
                break;
            }
            case -7: 
            case 16: {
                obj = rs.getBoolean(index) ? 1 : 0;
                break;
            }
            case -16: 
            case -1: 
            case 2005: 
            case 2011: {
                Reader rd = rs.getCharacterStream(index);
                if (rd == null) {
                    obj = null;
                    break;
                }
                obj = SysUtil.readString((Reader)rd);
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                InputStream is = rs.getBinaryStream(index);
                if (is != null) {
                    is.close();
                }
                obj = "(blob)";
                break;
            }
            default: {
                obj = rs.getObject(index);
            }
        }
        if (rs.wasNull()) {
            return null;
        }
        return obj;
    }

    public static Object getObject(ResultSet rs, String fieldName, int type) throws Exception {
        Object obj;
        switch (type) {
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                obj = rs.getString(fieldName);
                break;
            }
            case 4: {
                obj = rs.getInt(fieldName);
                break;
            }
            case -6: {
                obj = rs.getByte(fieldName);
                break;
            }
            case 5: {
                obj = rs.getShort(fieldName);
                break;
            }
            case -5: {
                obj = rs.getLong(fieldName);
                break;
            }
            case 6: 
            case 7: {
                obj = Float.valueOf(rs.getFloat(fieldName));
                break;
            }
            case 8: {
                obj = rs.getDouble(fieldName);
                break;
            }
            case 2: 
            case 3: {
                obj = rs.getBigDecimal(fieldName);
                break;
            }
            case 93: {
                obj = rs.getTimestamp(fieldName);
                break;
            }
            case 91: {
                obj = rs.getDate(fieldName);
                break;
            }
            case 92: {
                obj = rs.getTime(fieldName);
                break;
            }
            case -7: 
            case 16: {
                obj = rs.getBoolean(fieldName) ? 1 : 0;
                break;
            }
            case -16: 
            case -1: 
            case 2005: 
            case 2011: {
                Reader rd = rs.getCharacterStream(fieldName);
                if (rd == null) {
                    obj = null;
                    break;
                }
                obj = SysUtil.readString((Reader)rd);
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                InputStream is = rs.getBinaryStream(fieldName);
                if (is != null) {
                    is.close();
                }
                obj = "(blob)";
                break;
            }
            default: {
                obj = rs.getObject(fieldName);
            }
        }
        if (rs.wasNull()) {
            return null;
        }
        return obj;
    }

    public static void setObject(PreparedStatement statement, int index, int type, Object object) throws Exception {
        if (object == null || object instanceof String) {
            String value = object == null ? null : (String)object;
            if (StringUtil.isEmpty((String)value)) {
                statement.setNull(index, type);
            } else {
                switch (type) {
                    case -15: 
                    case -9: 
                    case 1: 
                    case 12: {
                        if (Var.emptyString.equals(value)) {
                            statement.setString(index, "");
                            break;
                        }
                        statement.setString(index, value);
                        break;
                    }
                    case 4: {
                        statement.setInt(index, Integer.parseInt(StringUtil.convertBool((String)value)));
                        break;
                    }
                    case -6: {
                        statement.setByte(index, Byte.parseByte(StringUtil.convertBool((String)value)));
                        break;
                    }
                    case 5: {
                        statement.setShort(index, Short.parseShort(StringUtil.convertBool((String)value)));
                        break;
                    }
                    case -5: {
                        statement.setLong(index, Long.parseLong(StringUtil.convertBool((String)value)));
                        break;
                    }
                    case 6: 
                    case 7: {
                        statement.setFloat(index, Float.parseFloat(StringUtil.convertBool((String)value)));
                        break;
                    }
                    case 8: {
                        statement.setDouble(index, Double.parseDouble(StringUtil.convertBool((String)value)));
                        break;
                    }
                    case 2: 
                    case 3: {
                        statement.setBigDecimal(index, new BigDecimal(StringUtil.convertBool((String)value)));
                        break;
                    }
                    case 93: {
                        statement.setTimestamp(index, Timestamp.valueOf(DateUtil.fixTimestamp((String)value, (boolean)false)));
                        break;
                    }
                    case 91: {
                        if (value.indexOf(32) != -1) {
                            statement.setTimestamp(index, Timestamp.valueOf(DateUtil.fixTimestamp((String)value, (boolean)false)));
                            break;
                        }
                        statement.setDate(index, Date.valueOf(DateUtil.fixTimestamp((String)value, (boolean)true)));
                        break;
                    }
                    case 92: {
                        if (value.indexOf(32) != -1 || value.indexOf(45) != -1) {
                            statement.setTimestamp(index, Timestamp.valueOf(DateUtil.fixTimestamp((String)value, (boolean)false)));
                            break;
                        }
                        statement.setTime(index, Time.valueOf(DateUtil.fixTime((String)value)));
                        break;
                    }
                    case -7: 
                    case 16: {
                        statement.setBoolean(index, StringUtil.getBool((String)value));
                        break;
                    }
                    case -16: 
                    case -1: 
                    case 2005: 
                    case 2011: {
                        statement.setCharacterStream(index, (Reader)new StringReader(value), value.length());
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: 
                    case 2004: {
                        ByteArrayInputStream is = new ByteArrayInputStream(StringUtil.decodeBase64((String)value));
                        statement.setBinaryStream(index, (InputStream)is, ((InputStream)is).available());
                        break;
                    }
                    default: {
                        statement.setObject(index, (Object)value, type);
                        break;
                    }
                }
            }
        } else if (object instanceof InputStream) {
            statement.setBinaryStream(index, (InputStream)object, ((InputStream)object).available());
        } else if (object instanceof java.util.Date) {
            statement.setTimestamp(index, new Timestamp(((java.util.Date)object).getTime()));
        } else {
            statement.setObject(index, object, type);
        }
    }

    public static Object run(HttpServletRequest request, String sql, String jndi) throws Exception {
        Query query = new Query();
        query.request = request;
        query.sql = sql;
        query.jndi = jndi;
        return query.run();
    }

    public static Object run(HttpServletRequest request, String sql) throws Exception {
        return DbUtil.run((HttpServletRequest)request, (String)sql, null);
    }

    public static void update(HttpServletRequest request, String tableName, String mode) throws Exception {
        Updater updater = new Updater();
        updater.request = request;
        updater.tableName = tableName;
        updater.mode = mode;
        updater.run();
    }

    public static String getFieldName(String fieldName) {
        if (Var.forceUpperCase) {
            if (fieldName.startsWith("#")) {
                return fieldName.substring(1);
            }
            return fieldName.toUpperCase();
        }
        return fieldName;
    }

    public static JSONArray getFields(ResultSetMetaData meta, String[] dictTableNames, JSONObject dictFieldsMap, JSONObject keyDefines) throws Exception {
        int j = meta.getColumnCount();
        String[] mapTable = new String[1];
        JSONArray ja = new JSONArray();
        boolean hasDict = dictTableNames != null;
        int i = 0;
        while (i < j) {
            String format;
            int k = i + 1;
            JSONObject jo = new JSONObject();
            String name = meta.getColumnLabel(k);
            if (StringUtil.isEmpty((String)(name = DbUtil.getFieldName((String)name)))) {
                name = "FIELD" + Integer.toString(k);
            }
            int type = meta.getColumnType(k);
            String category = keyDefines != null && keyDefines.has(name) ? "string" : DbUtil.getTypeCategory((int)type);
            switch (type) {
                case 93: {
                    format = "Y-m-d H:i:s.u";
                    break;
                }
                case 91: {
                    format = "Y-m-d";
                    break;
                }
                case 92: {
                    format = "H:i:s";
                    break;
                }
                default: {
                    format = null;
                }
            }
            jo.put("name", (Object)name);
            jo.put("type", (Object)category);
            if (format != null) {
                jo.put("dateFormat", (Object)format);
            }
            if (category.equals("string")) {
                jo.put("useNull", false);
            }
            ja.put((Object)jo);
            if (hasDict) {
                DictRecord dictRecord = null;
                if (dictFieldsMap != null) {
                    mapTable[0] = dictFieldsMap.optString(name);
                    if (!StringUtil.isEmpty((String)mapTable[0])) {
                        dictRecord = Dictionary.find((String[])mapTable, (String)name);
                    }
                }
                if (dictRecord != null) {
                    dictRecord = Dictionary.find((String[])dictTableNames, (String)name);
                }
                if (dictRecord != null && dictRecord.keyName != null) {
                    jo = new JSONObject();
                    jo.put("name", (Object)(String.valueOf(name) + "__V"));
                    jo.put("type", (Object)"string");
                    jo.put("useNull", false);
                    ja.put((Object)jo);
                }
            }
            ++i;
        }
        return ja;
    }

    public static HashMap<String, String> createVarMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (Var.preTradeDate) {
            map.put("sys.predate", TradeDateUtil.getPrevTradeDate());
        }
        map.put("sys.nowdate", TradeDateUtil.getNowTradeDate());
        map.put("sys.nowyear", TradeDateUtil.getNowYearFirstDay());
        map.put("sys.nowmonth", TradeDateUtil.getNowYMonthFirstDay());
        map.put("sys.nowCurrentMonth", TradeDateUtil.getNowMonth());
        map.put("sys.nowYFirstMonth", TradeDateUtil.getNowYFirstMonth());
        map.put("sys.beforeMonth", TradeDateUtil.getBeforeMonth());
        map.put("sys.beforeMonthFirstDay", TradeDateUtil.getBeforeMonthfirstDay());
        map.put("sys.beforeMonthEndDay", TradeDateUtil.getBeforeMonthEndDay());
        return map;
    }

    public static String getColumns(ResultSetMetaData meta, String[] dictTableNames, JSONObject dictFieldsMap, JSONObject keyDefines) throws Exception {
        int j = meta.getColumnCount();
        String[] mapTable = new String[1];
        String keyItems = null;
        StringBuilder buf = new StringBuilder();
        DictRecord fieldDict = null;
        buf.append('[');
        buf.append("{\"xtype\":\"rownumberer\"}");
        int i = 0;
        while (i < j) {
            String category;
            int type;
            String scale;
            String precision;
            int len;
            boolean hasKeyName;
            int index = i + 1;
            String fieldName = meta.getColumnLabel(index);
            if (StringUtil.isEmpty((String)(fieldName = DbUtil.getFieldName((String)fieldName)))) {
                fieldName = "FIELD" + Integer.toString(index);
            }
            fieldDict = null;
            if (dictFieldsMap != null) {
                mapTable[0] = dictFieldsMap.optString(fieldName);
                if (!StringUtil.isEmpty((String)mapTable[0])) {
                    fieldDict = Dictionary.find((String[])mapTable, (String)fieldName);
                }
            }
            if (fieldDict == null && dictTableNames != null) {
                fieldDict = Dictionary.find((String[])dictTableNames, (String)fieldName);
            }
            boolean hasFieldDict = fieldDict != null;
            boolean bl = hasKeyName = hasFieldDict && fieldDict.keyName != null;
            if (keyDefines != null && keyDefines.has(fieldName)) {
                len = 200;
                precision = "200";
                scale = "0";
                type = 12;
            } else {
                if (hasKeyName) {
                    len = 10;
                } else {
                    len = meta.getPrecision(index);
                    if (len <= 0) {
                        len = 100;
                    }
                }
                precision = Integer.toString(len);
                int scaleNum = meta.getScale(index);
                if (scaleNum < 0) {
                    scaleNum = 100;
                }
                scale = Integer.toString(scaleNum);
                type = meta.getColumnType(index);
                if ((type == -9 || type == 12) && len > Var.stringAsText) {
                    type = 2005;
                }
            }
            int fieldNameLen = fieldName.length();
            fieldName = StringUtil.quote((String)fieldName);
            buf.append(',');
            buf.append("{\"dataIndex\":");
            buf.append(fieldName);
            buf.append(",\"text\":");
            buf.append(hasFieldDict && fieldDict.dispText != null ? StringUtil.quote((String)fieldDict.dispText) : fieldName);
            String editor = null;
            boolean isDateTime = false;
            boolean hasRenderer = hasFieldDict && (fieldDict.renderer != null || hasKeyName);
            switch (type) {
                case 93: {
                    category = "timestamp";
                    editor = "\"datetimefield\"";
                    isDateTime = true;
                    len = 18;
                    break;
                }
                case 91: {
                    category = "date";
                    editor = "\"datefield\"";
                    isDateTime = true;
                    len = 12;
                    break;
                }
                case 92: {
                    category = "time";
                    editor = "\"timefield\"";
                    isDateTime = true;
                    len = 10;
                    if (hasRenderer) break;
                    buf.append(",\"renderer\":Wb.timeRenderer");
                    break;
                }
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    category = "number";
                    if (!hasKeyName) {
                        buf.append(",\"align\":\"right\"");
                    }
                    if (hasFieldDict) {
                        String dictSize = fieldDict.fieldSize == -1 ? precision : Integer.toString(fieldDict.fieldSize);
                        String dictScale = fieldDict.decimalPrecision == -1 ? scale : Integer.toString(fieldDict.decimalPrecision);
                        editor = StringUtil.concat((String[])new String[]{"\"numberfield\",\"decimalPrecision\":", dictScale});
                        if (fieldDict.validator != null) break;
                        editor = StringUtil.concat((String[])new String[]{editor, ",\"validator\":Wb.numValidator(", dictSize, ",", dictScale, ")"});
                        break;
                    }
                    editor = StringUtil.concat((String[])new String[]{"\"numberfield\",\"decimalPrecision\":", scale, ",\"validator\":Wb.numValidator(", precision, ",", scale, ")"});
                    break;
                }
                case -16: 
                case -1: 
                case 2005: 
                case 2011: {
                    category = "text";
                    editor = "\"textarea\",\"height\":120";
                    len = 18;
                    break;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    category = "blob";
                    editor = "\"filefield\"";
                    len = 16;
                    if (hasRenderer) break;
                    buf.append(",\"renderer\":Wb.blobRenderer");
                    break;
                }
                case -7: 
                case 16: {
                    category = "number";
                    if (!hasKeyName) {
                        buf.append(",\"align\":\"right\"");
                    }
                    editor = "\"numberfield\",\"maxValue\":1,\"minValue\":0";
                    break;
                }
                default: {
                    category = "string";
                    editor = "\"textfield\",\"maxLength\":" + (hasFieldDict && fieldDict.fieldSize != -1 ? Integer.toString(fieldDict.fieldSize) : precision);
                }
            }
            if (hasFieldDict) {
                if (isDateTime && fieldDict.fieldSize != -1) {
                    switch (fieldDict.fieldSize) {
                        case 1: {
                            editor = "\"datefield\"";
                            len = 12;
                            break;
                        }
                        case 2: {
                            editor = "\"timefield\"";
                            len = 10;
                            break;
                        }
                        case 3: {
                            category = "timestamp";
                            editor = "\"datetimefield\"";
                            len = 18;
                        }
                    }
                }
                if (!fieldDict.listable) {
                    buf.append(",\"hidden\":true,\"showInMenu\":false");
                }
                if (fieldDict.dispFormat != null) {
                    buf.append(",\"format\":");
                    buf.append(StringUtil.quote((String)fieldDict.dispFormat));
                }
                if (hasRenderer) {
                    if (fieldDict.renderer != null) {
                        buf.append(",\"renderer\":function(value,metaData,record,rowIndex,colIndex,store,view){");
                        buf.append(fieldDict.renderer);
                        buf.append('}');
                    } else {
                        buf.append(",\"renderer\":Wb.kvRenderer");
                    }
                }
                if (fieldDict.autoWrap) {
                    buf.append(",\"autoWrap\":true");
                }
            }
            buf.append(",\"category\":\"");
            buf.append(category);
            if (hasFieldDict && fieldDict.dispWidth != -1) {
                if (fieldDict.dispWidth < 10) {
                    buf.append("\",\"flex\":");
                    buf.append(fieldDict.dispWidth);
                } else {
                    buf.append("\",\"width\":");
                    buf.append(fieldDict.dispWidth);
                }
            } else {
                buf.append("\",\"width\":");
                len = Math.max(len, fieldNameLen + 3);
                if (len < 5) {
                    len = 5;
                }
                if (len > 18) {
                    len = 18;
                }
                buf.append(len * 10);
            }
            if (hasKeyName) {
                keyItems = KVBuffer.getList((String)fieldDict.keyName);
                buf.append(",\"keyName\":");
                buf.append(StringUtil.quote((String)fieldDict.keyName));
                buf.append(",\"keyItems\":");
                buf.append(keyItems);
            }
            if ((!hasFieldDict || fieldDict.editable) && editor != null) {
                if (hasFieldDict && fieldDict.validator != null && fieldDict.validator.trim().startsWith("{")) {
                    if ("blob".equals(category)) {
                        buf.append(",\"blobEditor\":");
                    } else {
                        buf.append(",\"editor\":");
                    }
                    buf.append(fieldDict.validator);
                    buf.append(",\"editable\":true");
                } else {
                    if ("blob".equals(category)) {
                        buf.append(",\"blobEditor\":{\"xtype\":");
                    } else {
                        buf.append(",\"editor\":{\"xtype\":");
                    }
                    if (hasKeyName) {
                        buf.append("\"combo\",\"keyName\":");
                        buf.append(StringUtil.quote((String)fieldDict.keyName));
                        buf.append(",\"displayField\":\"V\",\"valueField\":\"K\",\"forceSelection\":true,\"queryMode\":\"local\",\"store\":{\"fields\":[\"K\",\"V\"],\"sorters\":\"K\",\"data\":");
                        buf.append(keyItems);
                        buf.append('}');
                    } else {
                        buf.append(editor);
                    }
                    if (hasFieldDict) {
                        if (fieldDict.allowBlank == null) {
                            if (meta.isNullable(index) == 0) {
                                buf.append(",\"allowBlank\":false,\"required\":true");
                            }
                        } else if (!fieldDict.allowBlank.booleanValue()) {
                            buf.append(",\"allowBlank\":false,\"required\":true");
                        }
                        if (fieldDict.readOnly == null) {
                            if (meta.isReadOnly(index)) {
                                buf.append(",\"readOnly\":true");
                            }
                        } else if (fieldDict.readOnly.booleanValue()) {
                            buf.append(",\"readOnly\":true");
                        }
                        if (fieldDict.validator != null) {
                            buf.append(",\"validator\":function(value){");
                            buf.append(fieldDict.validator);
                            buf.append('}');
                        }
                    } else {
                        if (meta.isNullable(index) == 0) {
                            buf.append(",\"allowBlank\":false,\"required\":true");
                        }
                        if (meta.isReadOnly(index)) {
                            buf.append(",\"readOnly\":true");
                        }
                    }
                    buf.append("},\"editable\":true");
                }
            }
            buf.append(",\"metaType\":\"");
            buf.append(meta.getColumnTypeName(index));
            buf.append("\",\"metaRequired\":");
            buf.append(meta.isNullable(index) == 0 ? "true" : "false");
            buf.append(",\"metaSize\":");
            buf.append(precision);
            buf.append(",\"metaScale\":");
            buf.append(scale);
            buf.append('}');
            ++i;
        }
        buf.append(']');
        return buf.toString();
    }

    public static String getColumns(ResultSetMetaData meta, String[] dictTableNames, JSONObject dictFieldsMap, JSONObject keyDefines, HttpServletRequest request) throws Exception {
        int j = meta.getColumnCount();
        String[] mapTable = new String[1];
        String keyItems = null;
        StringBuilder buf = new StringBuilder();
        DictRecord fieldDict = null;
        HashMap varMap = DbUtil.createVarMap();
        varMap.put("sys.user", WebUtil.fetch((HttpServletRequest)request, (String)"sys.username"));
        buf.append('[');
        buf.append("{\"xtype\":\"rownumberer\"}");
        int i = 0;
        while (i < j) {
            String category;
            int type;
            String scale;
            String precision;
            int len;
            boolean hasKeyName;
            int index = i + 1;
            String fieldName = meta.getColumnLabel(index);
            if (StringUtil.isEmpty((String)(fieldName = DbUtil.getFieldName((String)fieldName)))) {
                fieldName = "FIELD" + Integer.toString(index);
            }
            fieldDict = null;
            if (dictFieldsMap != null) {
                mapTable[0] = dictFieldsMap.optString(fieldName);
                if (!StringUtil.isEmpty((String)mapTable[0])) {
                    fieldDict = Dictionary.find((String[])mapTable, (String)fieldName);
                }
            }
            if (fieldDict == null && dictTableNames != null) {
                fieldDict = Dictionary.find((String[])dictTableNames, (String)fieldName);
            }
            boolean hasFieldDict = fieldDict != null;
            boolean bl = hasKeyName = hasFieldDict && fieldDict.keyName != null;
            if (keyDefines != null && keyDefines.has(fieldName)) {
                len = 200;
                precision = "200";
                scale = "0";
                type = 12;
            } else {
                if (hasKeyName) {
                    len = 10;
                } else {
                    len = meta.getPrecision(index);
                    if (len <= 0) {
                        len = 100;
                    }
                }
                precision = Integer.toString(len);
                int scaleNum = meta.getScale(index);
                if (scaleNum < 0) {
                    scaleNum = 100;
                }
                scale = Integer.toString(scaleNum);
                type = meta.getColumnType(index);
                if ((type == -9 || type == 12) && len > Var.stringAsText) {
                    type = 2005;
                }
            }
            int fieldNameLen = fieldName.length();
            fieldName = StringUtil.quote((String)fieldName);
            buf.append(',');
            buf.append("{\"dataIndex\":");
            buf.append(fieldName);
            buf.append(",\"text\":");
            buf.append(hasFieldDict && fieldDict.dispText != null ? StringUtil.quote((String)fieldDict.dispText) : fieldName);
            if (hasFieldDict && fieldDict.asInput) {
                buf.append(",\"asInput\":true");
            }
            String editor = null;
            boolean isDateTime = false;
            boolean hasRenderer = hasFieldDict && (fieldDict.renderer != null || hasKeyName);
            switch (type) {
                case 93: {
                    category = "timestamp";
                    editor = "\"datetimefield\"";
                    isDateTime = true;
                    len = 18;
                    break;
                }
                case 91: {
                    category = "date";
                    editor = "\"datefield\"";
                    isDateTime = true;
                    len = 12;
                    break;
                }
                case 92: {
                    category = "time";
                    editor = "\"timefield\"";
                    isDateTime = true;
                    len = 10;
                    if (hasRenderer) break;
                    buf.append(",\"renderer\":Wb.timeRenderer");
                    break;
                }
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    category = "number";
                    if (!hasKeyName) {
                        buf.append(",\"align\":\"right\"");
                    }
                    if (hasFieldDict) {
                        String dictSize = fieldDict.fieldSize == -1 ? precision : Integer.toString(fieldDict.fieldSize);
                        String dictScale = fieldDict.decimalPrecision == -1 ? scale : Integer.toString(fieldDict.decimalPrecision);
                        editor = StringUtil.concat((String[])new String[]{"\"numberfield\",\"decimalPrecision\":", dictScale});
                        if (fieldDict.validator != null) break;
                        editor = StringUtil.concat((String[])new String[]{editor, ",\"validator\":Wb.numValidator(", dictSize, ",", dictScale, ")"});
                        break;
                    }
                    editor = StringUtil.concat((String[])new String[]{"\"numberfield\",\"decimalPrecision\":", scale, ",\"validator\":Wb.numValidator(", precision, ",", scale, ")"});
                    break;
                }
                case -16: 
                case -1: 
                case 2005: 
                case 2011: {
                    category = "text";
                    editor = "\"textarea\",\"height\":120";
                    len = 18;
                    break;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    category = "blob";
                    editor = "\"filefield\"";
                    len = 16;
                    if (hasRenderer) break;
                    buf.append(",\"renderer\":Wb.blobRenderer");
                    break;
                }
                case -7: 
                case 16: {
                    category = "number";
                    if (!hasKeyName) {
                        buf.append(",\"align\":\"right\"");
                    }
                    editor = "\"numberfield\",\"maxValue\":1,\"minValue\":0";
                    break;
                }
                default: {
                    category = "string";
                    editor = "\"textfield\",\"maxLength\":" + (hasFieldDict && fieldDict.fieldSize != -1 ? Integer.toString(fieldDict.fieldSize) : precision);
                }
            }
            if (hasFieldDict) {
                if (isDateTime && fieldDict.fieldSize != -1) {
                    switch (fieldDict.fieldSize) {
                        case 1: {
                            editor = "\"datefield\"";
                            len = 12;
                            break;
                        }
                        case 2: {
                            editor = "\"timefield\"";
                            len = 10;
                            break;
                        }
                        case 3: {
                            category = "timestamp";
                            editor = "\"datetimefield\"";
                            len = 18;
                        }
                    }
                }
                if (!fieldDict.listable) {
                    buf.append(",\"hidden\":true,\"showInMenu\":false");
                }
                if (fieldDict.dispFormat != null) {
                    buf.append(",\"format\":");
                    buf.append(StringUtil.quote((String)fieldDict.dispFormat));
                }
                if (hasRenderer) {
                    if (fieldDict.renderer != null) {
                        buf.append(",\"renderer\":function(value,metaData,record,rowIndex,colIndex,store,view){");
                        buf.append(fieldDict.renderer);
                        buf.append('}');
                    } else {
                        buf.append(",\"renderer\":Wb.kvRenderer");
                    }
                }
                if (fieldDict.autoWrap) {
                    buf.append(",\"autoWrap\":true");
                }
                if (fieldDict.showStar) {
                    buf.append(",\"showStar\":true");
                }
            }
            buf.append(",\"category\":\"");
            buf.append(category);
            if (hasFieldDict && fieldDict.dispWidth != -1) {
                if (fieldDict.dispWidth < 10) {
                    buf.append("\",\"flex\":");
                    buf.append(fieldDict.dispWidth);
                } else {
                    buf.append("\",\"width\":");
                    buf.append(fieldDict.dispWidth);
                }
            } else {
                buf.append("\",\"width\":");
                len = Math.max(len, fieldNameLen + 3);
                if (len < 5) {
                    len = 5;
                }
                if (len > 18) {
                    len = 18;
                }
                buf.append(len * 10);
            }
            if (hasKeyName) {
                keyItems = KVBuffer.getList((String)fieldDict.keyName);
                buf.append(",\"keyName\":");
                buf.append(StringUtil.quote((String)fieldDict.keyName));
                buf.append(",\"keyItems\":");
                buf.append(keyItems);
            }
            if ((!hasFieldDict || fieldDict.editable) && editor != null) {
                if (hasFieldDict && fieldDict.controlType != null) {
                    String json;
                    if ("blob".equals(category)) {
                        buf.append(",\"blobEditor\":");
                    } else {
                        buf.append(",\"editor\":");
                    }
                    if ("02".equals(fieldDict.controlType)) {
                        json = "{xtype:\"numberfield\"";
                    } else if ("03".equals(fieldDict.controlType)) {
                        json = "{xtype:\"datefield\"";
                    } else if ("04".equals(fieldDict.controlType)) {
                        json = "{xtype:\"combo\",store:";
                        json = fieldDict.dataSource.startsWith("[") ? String.valueOf(json) + fieldDict.dataSource : (!fieldDict.dataSource.isEmpty() ? String.valueOf(json) + "{autoLoad:true,url:\"" + fieldDict.dataSource + "\"},displayField:\"D\",valueField:\"V\"" : String.valueOf(json) + "[]");
                    } else {
                        json = "05".equals(fieldDict.controlType) ? "{xtype:\"stringdatefield\"" : ("06".equals(fieldDict.controlType) ? "{xtype:\"yybpicker\"" : ("07".equals(fieldDict.controlType) ? "{xtype:\"yybpickermul\"" : "{xtype:\"textfield\""));
                    }
                    buf.append(json);
                    if (fieldDict.defaultValue != null) {
                        if (varMap.containsKey(fieldDict.defaultValue)) {
                            buf.append(",\"value\":\"{#" + fieldDict.defaultValue + "#}\"");
                        } else {
                            buf.append(",\"value\":" + fieldDict.defaultValue);
                        }
                    }
                    buf.append("},\"editable\":true");
                } else if (hasFieldDict && fieldDict.validator != null && fieldDict.validator.trim().startsWith("{")) {
                    if ("blob".equals(category)) {
                        buf.append(",\"blobEditor\":");
                    } else {
                        buf.append(",\"editor\":");
                    }
                    buf.append(fieldDict.validator);
                    buf.append(",\"editable\":true");
                } else {
                    if ("blob".equals(category)) {
                        buf.append(",\"blobEditor\":{\"xtype\":");
                    } else {
                        buf.append(",\"editor\":{\"xtype\":");
                    }
                    if (hasKeyName) {
                        buf.append("\"combo\",\"keyName\":");
                        buf.append(StringUtil.quote((String)fieldDict.keyName));
                        buf.append(",\"displayField\":\"V\",\"valueField\":\"K\",\"forceSelection\":true,\"queryMode\":\"local\",\"store\":{\"fields\":[\"K\",\"V\"],\"sorters\":\"K\",\"data\":");
                        buf.append(keyItems);
                        buf.append('}');
                    } else {
                        buf.append(editor);
                    }
                    if (hasFieldDict) {
                        if (fieldDict.allowBlank == null) {
                            if (meta.isNullable(index) == 0) {
                                buf.append(",\"allowBlank\":false,\"required\":true");
                            }
                        } else if (!fieldDict.allowBlank.booleanValue()) {
                            buf.append(",\"allowBlank\":false,\"required\":true");
                        }
                        if (fieldDict.readOnly == null) {
                            if (meta.isReadOnly(index)) {
                                buf.append(",\"readOnly\":true");
                            }
                        } else if (fieldDict.readOnly.booleanValue()) {
                            buf.append(",\"readOnly\":true");
                        }
                        if (fieldDict.validator != null) {
                            buf.append(",\"validator\":function(value){");
                            buf.append(fieldDict.validator);
                            buf.append('}');
                        }
                    } else {
                        if (meta.isNullable(index) == 0) {
                            buf.append(",\"allowBlank\":false,\"required\":true");
                        }
                        if (meta.isReadOnly(index)) {
                            buf.append(",\"readOnly\":true");
                        }
                    }
                    if (hasFieldDict && fieldDict.defaultValue != null) {
                        if (varMap.containsKey(fieldDict.defaultValue)) {
                            buf.append(",\"value\":\"{#" + fieldDict.defaultValue + "#}\"");
                        } else {
                            buf.append(",\"value\":" + fieldDict.defaultValue);
                        }
                    }
                    buf.append("},\"editable\":true");
                }
            }
            buf.append(",\"metaType\":\"");
            buf.append(meta.getColumnTypeName(index));
            buf.append("\",\"metaRequired\":");
            buf.append(meta.isNullable(index) == 0 ? "true" : "false");
            buf.append(",\"metaSize\":");
            buf.append(precision);
            buf.append(",\"metaScale\":");
            buf.append(scale);
            buf.append('}');
            ++i;
        }
        buf.append(']');
        return buf.toString();
    }

    public static void outputBlob(ResultSet resultSet, HttpServletRequest request, HttpServletResponse response, String contentType) throws Exception {
        InputStream inputStream = null;
        try {
            ResultSetMetaData meta = resultSet.getMetaData();
            int rowCount = meta.getColumnCount();
            String name = DbUtil.getFieldName((String)meta.getColumnLabel(1));
            String size = null;
            if (StringUtil.isEmpty((String)name)) {
                name = "blob";
            }
            response.reset();
            if (resultSet.next()) {
                switch (rowCount) {
                    case 1: {
                        inputStream = resultSet.getBinaryStream(1);
                        break;
                    }
                    case 2: {
                        name = resultSet.getString(2);
                        inputStream = resultSet.getBinaryStream(1);
                        break;
                    }
                    case 3: {
                        name = resultSet.getString(2);
                        size = resultSet.getString(3);
                        inputStream = resultSet.getBinaryStream(1);
                    }
                }
            } else {
                throw new Exception("Empty ResultSet.");
            }
            ServletOutputStream outputStream = response.getOutputStream();
            if ("download".equals(contentType)) {
                contentType = "application/force-download";
            } else if ("stream".equals(contentType)) {
                contentType = "application/octet-stream";
            } else if ("image".equals(contentType)) {
                if (inputStream == null) {
                    File nullGif = new File(Base.path, "wb/images/null.gif");
                    inputStream = new FileInputStream(nullGif);
                    size = Long.toString(nullGif.length());
                    contentType = "image/gif";
                } else {
                    String extName = FileUtil.getFileExt((String)name);
                    contentType = extName.isEmpty() ? "image/jpg" : "image/" + extName;
                }
            }
            response.setHeader("content-type", contentType);
            response.setHeader("content-disposition", "attachment;" + WebUtil.encodeFilename((HttpServletRequest)request, (String)name));
            if (size != null) {
                response.setHeader("content-length", size);
            }
            if (inputStream != null) {
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            response.flushBuffer();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    public static String[] buildSQLs(String jndi, String tableName, boolean ignoreBlob, int scriptType, HttpServletRequest request, JSONObject fields, JSONObject whereFields, JSONObject fieldsMap) throws Exception {
        String[] sqls = new String[4];
        Connection conn = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        StringBuilder selectFields = new StringBuilder();
        StringBuilder insertFields = new StringBuilder();
        StringBuilder insertParams = new StringBuilder();
        StringBuilder condition = new StringBuilder();
        StringBuilder updateParams = new StringBuilder();
        boolean isFirstSelect = true;
        boolean isFirstUpdate = true;
        boolean isFirstCondi = true;
        boolean hasRequest = request != null;
        try {
            conn = request == null ? DbUtil.getConnection((String)jndi) : DbUtil.getConnection((HttpServletRequest)request, (String)jndi);
            st = conn.prepareStatement("select * from " + tableName + " where 1=0");
            rs = st.executeQuery();
            ResultSetMetaData meta = rs.getMetaData();
            int j = meta.getColumnCount() + 1;
            int i = 1;
            while (i < j) {
                String mapName;
                boolean isFloat;
                int type = meta.getColumnType(i);
                String typeName = DbUtil.getTypeName((int)type);
                int precision = meta.getPrecision(i);
                if (precision <= 0) {
                    precision = 100;
                }
                boolean isText = DbUtil.isTextField((int)type) || precision > 10000;
                boolean isBlob = DbUtil.isBlobField((int)type);
                int scale = meta.getScale(i);
                if (scale < 0) {
                    scale = 100;
                }
                boolean bl = isFloat = DbUtil.maybeFloatField((int)type) && scale > 0;
                if (isFloat && Var.useDouble) {
                    type = 8;
                    typeName = "double";
                }
                boolean required = meta.isNullable(i) == 0;
                boolean readOnly = meta.isReadOnly(i);
                String fieldName = meta.getColumnLabel(i);
                String fieldValueName = fieldName = DbUtil.getFieldName((String)fieldName);
                fieldName = StringUtil.quoteIf((String)fieldName);
                if (fieldsMap != null && (mapName = fieldsMap.optString(fieldValueName, null)) != null) {
                    fieldValueName = mapName;
                }
                if (!isBlob || !hasRequest || !StringUtil.isEmpty((String)WebUtil.fetch((HttpServletRequest)request, (String)fieldValueName)) || "1".equals(WebUtil.fetch((HttpServletRequest)request, (String)("$" + fieldValueName)))) {
                    if (!(ignoreBlob && isBlob || fields != null && !fields.has(fieldValueName) && !fields.has("$" + fieldValueName))) {
                        if (isFirstSelect) {
                            isFirstSelect = false;
                        } else {
                            selectFields.append(',');
                        }
                        selectFields.append(fieldName);
                        if (!readOnly) {
                            String param;
                            if (isFirstUpdate) {
                                isFirstUpdate = false;
                            } else {
                                insertFields.append(',');
                                insertParams.append(',');
                                updateParams.append(',');
                            }
                            switch (scriptType) {
                                case 1: {
                                    if (typeName == null) {
                                        param = StringUtil.concat((String[])new String[]{"{?", fieldValueName, "?}"});
                                        break;
                                    }
                                    param = StringUtil.concat((String[])new String[]{"{?", typeName, ".", fieldValueName, "?}"});
                                    break;
                                }
                                case 2: {
                                    param = StringUtil.concat((String[])new String[]{"{#", fieldValueName, "#}"});
                                    break;
                                }
                                default: {
                                    param = fieldValueName;
                                }
                            }
                            insertFields.append(fieldName);
                            insertParams.append(param);
                            updateParams.append(fieldName);
                            updateParams.append('=');
                            updateParams.append(param);
                        }
                    }
                    if (!(isText || isBlob || whereFields != null && !whereFields.has(fieldValueName))) {
                        if (isFirstCondi) {
                            isFirstCondi = false;
                        } else {
                            condition.append(" and ");
                        }
                        condition.append(DbUtil.getCondition((String)tableName, (String)fieldName, (String)fieldValueName, (boolean)DbUtil.isStringField((int)type), (String)typeName, (boolean)required, (int)scriptType));
                    }
                }
                ++i;
            }
            sqls[0] = StringUtil.concat((String[])new String[]{"insert into ", tableName, " (", insertFields.toString(), ") values (", insertParams.toString(), ")"});
            sqls[1] = StringUtil.concat((String[])new String[]{"update ", tableName, " set ", updateParams.toString(), " where ", condition.toString()});
            sqls[2] = StringUtil.concat((String[])new String[]{"delete from ", tableName, " where ", condition.toString()});
            sqls[3] = StringUtil.concat((String[])new String[]{"select ", selectFields.toString(), " from ", tableName, " where ", condition.toString()});
        }
        catch (Throwable throwable) {
            DbUtil.close(rs);
            DbUtil.close(st);
            if (request == null) {
                DbUtil.close((Object)conn);
            }
            throw throwable;
        }
        DbUtil.close((Object)rs);
        DbUtil.close((Object)st);
        if (request == null) {
            DbUtil.close((Object)conn);
        }
        return sqls;
    }

    public static String[] buildSQLsWb(String jndi, String tableName, boolean ignoreBlob, int scriptType, HttpServletRequest request, JSONObject fields, JSONObject whereFields, JSONObject fieldsMap) throws Exception {
        String[] sqls = new String[4];
        Connection conn = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        StringBuilder selectFields = new StringBuilder();
        StringBuilder insertFields = new StringBuilder();
        StringBuilder insertParams = new StringBuilder();
        StringBuilder condition = new StringBuilder();
        StringBuilder updateParams = new StringBuilder();
        boolean isFirstSelect = true;
        boolean isFirstUpdate = true;
        boolean isFirstCondi = true;
        boolean hasRequest = request != null;
        try {
            conn = request == null ? DbUtil.getConnection((String)jndi) : DbUtil.getConnection((HttpServletRequest)request, (String)jndi);
            st = conn.prepareStatement("select * from " + tableName + " where 1=0");
            rs = st.executeQuery();
            ResultSetMetaData meta = rs.getMetaData();
            int j = meta.getColumnCount() + 1;
            int i = 1;
            while (i < j) {
                String mapName;
                boolean isFloat;
                int type = meta.getColumnType(i);
                String typeName = DbUtil.getTypeName((int)type);
                int precision = meta.getPrecision(i);
                if (precision <= 0) {
                    precision = 100;
                }
                boolean isText = DbUtil.isTextField((int)type) || precision > 10000;
                boolean isBlob = DbUtil.isBlobField((int)type);
                int scale = meta.getScale(i);
                if (scale < 0) {
                    scale = 100;
                }
                boolean bl = isFloat = DbUtil.maybeFloatField((int)type) && scale > 0;
                if (isFloat && Var.useDouble) {
                    type = 8;
                    typeName = "double";
                }
                boolean required = meta.isNullable(i) == 0;
                boolean readOnly = meta.isReadOnly(i);
                String fieldName = meta.getColumnLabel(i);
                String fieldValueName = fieldName = DbUtil.getFieldName((String)fieldName);
                fieldName = StringUtil.quoteIf((String)fieldName);
                if (fieldsMap != null && (mapName = fieldsMap.optString(fieldValueName, null)) != null) {
                    fieldValueName = mapName;
                }
                if (!isBlob || !hasRequest || !StringUtil.isEmpty((String)WebUtil.fetch((HttpServletRequest)request, (String)fieldValueName)) || "1".equals(WebUtil.fetch((HttpServletRequest)request, (String)("$" + fieldValueName)))) {
                    if (!(ignoreBlob && isBlob || fields != null && !fields.has(fieldValueName) && !fields.has("$" + fieldValueName))) {
                        if (isFirstSelect) {
                            isFirstSelect = false;
                        } else {
                            selectFields.append(',');
                        }
                        selectFields.append(fieldName);
                        if (!readOnly) {
                            String param;
                            if (isFirstUpdate) {
                                isFirstUpdate = false;
                            } else {
                                insertFields.append(',');
                                insertParams.append(',');
                                updateParams.append(',');
                            }
                            switch (scriptType) {
                                case 1: {
                                    if (typeName == null) {
                                        param = StringUtil.concat((String[])new String[]{"{?", fieldValueName, "?}"});
                                        break;
                                    }
                                    param = StringUtil.concat((String[])new String[]{"{?", typeName, ".", fieldValueName, "?}"});
                                    break;
                                }
                                case 2: {
                                    param = StringUtil.concat((String[])new String[]{"{#", fieldValueName, "#}"});
                                    break;
                                }
                                default: {
                                    param = fieldValueName;
                                }
                            }
                            insertFields.append(fieldName);
                            insertParams.append(param);
                            updateParams.append(fieldName);
                            updateParams.append('=');
                            updateParams.append(param);
                        }
                    }
                    if (!(isText || isBlob || whereFields != null && !whereFields.has(fieldValueName))) {
                        if (isFirstCondi) {
                            isFirstCondi = false;
                        } else {
                            condition.append(" and ");
                        }
                        condition.append(DbUtil.getConditionOther((String)tableName, (String)fieldName, (String)fieldValueName, (boolean)DbUtil.isStringField((int)type), (String)typeName, (boolean)required, (int)scriptType));
                    }
                }
                ++i;
            }
            sqls[0] = StringUtil.concat((String[])new String[]{"insert into ", tableName, " (", insertFields.toString(), ") values (", insertParams.toString(), ")"});
            sqls[1] = StringUtil.concat((String[])new String[]{"update ", tableName, " set ", updateParams.toString(), " where ", condition.toString()});
            sqls[2] = StringUtil.concat((String[])new String[]{"delete from ", tableName, " where ", condition.toString()});
            sqls[3] = StringUtil.concat((String[])new String[]{"select ", selectFields.toString(), " from ", tableName, " where ", condition.toString()});
        }
        catch (Throwable throwable) {
            DbUtil.close(rs);
            DbUtil.close(st);
            if (request == null) {
                DbUtil.close((Object)conn);
            }
            throw throwable;
        }
        DbUtil.close((Object)rs);
        DbUtil.close((Object)st);
        if (request == null) {
            DbUtil.close((Object)conn);
        }
        return sqls;
    }

    private static String getConditionOther(String tableName, String fieldName, String fieldValueName, boolean isStringField, String typeName, boolean required, int scriptType) {
        StringBuilder buf = new StringBuilder();
        switch (scriptType) {
            case 1: {
                if (isStringField) {
                    buf.append("({?#");
                    buf.append(fieldValueName);
                    buf.append("?} is null and (");
                    buf.append(fieldName);
                    buf.append(" is null or ");
                    buf.append(fieldName);
                    buf.append("='') or ");
                    buf.append(fieldName);
                    buf.append("={?");
                    if (typeName == null) {
                        buf.append('#');
                    } else {
                        buf.append(typeName);
                        buf.append(".#");
                    }
                    buf.append(fieldValueName);
                    buf.append("?})");
                    break;
                }
                if (!required) {
                    buf.append("({?#");
                    buf.append(fieldValueName);
                    buf.append("?} is null and ");
                    buf.append(fieldName);
                    buf.append(" is null or ");
                }
                buf.append(fieldName);
                buf.append("={?");
                if (typeName == null) {
                    buf.append('#');
                } else {
                    buf.append(typeName);
                    buf.append(".#");
                }
                buf.append(fieldValueName);
                if (required) {
                    buf.append("?}");
                    break;
                }
                buf.append("?})");
                break;
            }
            case 2: {
                if (!required) {
                    buf.append("({##");
                    buf.append(fieldValueName);
                    buf.append("#} is null and ");
                    buf.append(fieldName);
                    buf.append(" is null or ");
                }
                buf.append(fieldName);
                buf.append("={##");
                buf.append(fieldValueName);
                if (required) {
                    buf.append("#}");
                    break;
                }
                buf.append("#})");
                break;
            }
            default: {
                if (!required) {
                    buf.append("(#");
                    buf.append(fieldValueName);
                    buf.append(" is null and ");
                    buf.append(fieldName);
                    buf.append(" is null or ");
                }
                buf.append(fieldName);
                buf.append("=#");
                buf.append(fieldValueName);
                if (required) break;
                buf.append(')');
            }
        }
        return buf.toString();
    }

    private static String getCondition(String tableName, String fieldName, String fieldValueName, boolean isStringField, String typeName, boolean required, int scriptType) {
        StringBuilder buf = new StringBuilder();
        switch (scriptType) {
            case 1: {
                if (isStringField) {
                    buf.append("({?#");
                    buf.append(fieldValueName);
                    buf.append("?} is null and (");
                    buf.append(fieldName);
                    buf.append(" is null or ");
                    buf.append(fieldName);
                    buf.append("='') or ");
                    buf.append(fieldName);
                    buf.append(DbUtil.getOpType((String)tableName, (String)typeName, (String)fieldValueName, (boolean)required));
                    buf.append("?})");
                    break;
                }
                if (!required) {
                    buf.append("({?#");
                    buf.append(fieldValueName);
                    buf.append("?} is null and ");
                    buf.append(fieldName);
                    buf.append(" is null or ");
                }
                buf.append(fieldName);
                buf.append(DbUtil.getOpType((String)tableName, (String)typeName, (String)fieldValueName, (boolean)required));
                if (required) {
                    buf.append("?}");
                    break;
                }
                buf.append("?})");
                break;
            }
            case 2: {
                if (!required) {
                    buf.append("({##");
                    buf.append(fieldValueName);
                    buf.append("#} is null and ");
                    buf.append(fieldName);
                    buf.append(" is null or ");
                }
                buf.append(fieldName);
                buf.append("={##");
                buf.append(fieldValueName);
                if (required) {
                    buf.append("#}");
                    break;
                }
                buf.append("#})");
                break;
            }
            default: {
                if (!required) {
                    buf.append("(#");
                    buf.append(fieldValueName);
                    buf.append(" is null and ");
                    buf.append(fieldName);
                    buf.append(" is null or ");
                }
                buf.append(fieldName);
                buf.append("=#");
                buf.append(fieldValueName);
                if (required) break;
                buf.append(')');
            }
        }
        return buf.toString();
    }

    private static String getOpType(String tableName, String typeName, String fieldValueName, boolean required) {
        String[] tableNames = new String[]{tableName, "WB_ALL_FIELD"};
        DictRecord dr = Dictionary.find((String[])tableNames, (String)fieldValueName);
        StringBuilder buf = new StringBuilder();
        if (dr == null || StringUtils.isEmpty((String)dr.opType)) {
            buf.append("={?");
            if (typeName == null) {
                buf.append('#');
            } else {
                buf.append(typeName);
                buf.append(".#");
            }
            buf.append(fieldValueName);
        } else {
            buf.append(dr.opType);
            buf.append("{?");
            if (typeName == null) {
                buf.append('#');
            } else {
                buf.append(typeName);
                buf.append(".#");
            }
            buf.append(fieldValueName);
        }
        return buf.toString();
    }
}

